/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import be.iminds.ilabt.jfed.json.util.JsonGeniUrnDeserializer;
import be.iminds.ilabt.jfed.json.util.JsonGeniUrnSerializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Serializer;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
public class ErrorDetails {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorDetails.class);
    private final String error;
    private final GeniUrn sliverUrn;
    private final GeniUrn componentUrn;
    private final Instant timestamp;

    public ErrorDetails(@JsonProperty(value="error") String error, @JsonProperty(value="sliverUrn") GeniUrn sliverUrn, @JsonProperty(value="componentUrn") GeniUrn componentUrn, @JsonProperty(value="timestamp") Instant timestamp) {
        this.error = error;
        this.sliverUrn = sliverUrn;
        this.componentUrn = componentUrn;
        this.timestamp = timestamp;
    }

    @JsonProperty
    public String getError() {
        return this.error;
    }

    @JsonProperty
    @JsonSerialize(using=JsonGeniUrnSerializer.class)
    @JsonDeserialize(using=JsonGeniUrnDeserializer.class)
    public GeniUrn getSliverUrn() {
        return this.sliverUrn;
    }

    @JsonProperty
    @JsonSerialize(using=JsonGeniUrnSerializer.class)
    @JsonDeserialize(using=JsonGeniUrnDeserializer.class)
    public GeniUrn getComponentUrn() {
        return this.componentUrn;
    }

    @JsonProperty
    @JsonSerialize(using=JsonInstantRFC3339Serializer.class)
    @JsonDeserialize(using=JsonInstantRFC3339Deserializer.class)
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getName() + " to JSON", e);
            return "Exception converting Testbed " + this.getClass().getName() + " to JSON: " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorDetails)) {
            return false;
        }
        ErrorDetails that = (ErrorDetails)o;
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.sliverUrn != null ? !this.sliverUrn.equals(that.sliverUrn) : that.sliverUrn != null) {
            return false;
        }
        if (this.componentUrn != null ? !this.componentUrn.equals(that.componentUrn) : that.componentUrn != null) {
            return false;
        }
        return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
    }

    public int hashCode() {
        int result = this.error != null ? this.error.hashCode() : 0;
        result = 31 * result + (this.sliverUrn != null ? this.sliverUrn.hashCode() : 0);
        result = 31 * result + (this.componentUrn != null ? this.componentUrn.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }
}

