/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Serializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
public class LogLine {
    private static final Logger LOG = LoggerFactory.getLogger(LogLine.class);
    private Instant time;
    private String className;
    private String level;
    private String message;
    private String exception;
    private String threadName;

    @JsonCreator
    public LogLine(@JsonProperty(value="time") Instant time, @JsonProperty(value="className") String className, @JsonProperty(value="level") String level, @JsonProperty(value="message") String message, @JsonProperty(value="exception") String exception, @JsonProperty(value="threadName") String threadName) {
        this.time = time;
        this.className = className;
        this.level = level;
        this.message = message;
        this.exception = exception;
        this.threadName = threadName;
    }

    @JsonProperty
    @JsonSerialize(using=JsonInstantRFC3339Serializer.class)
    @JsonDeserialize(using=JsonInstantRFC3339Deserializer.class)
    public Instant getTime() {
        return this.time;
    }

    @JsonProperty
    public String getClassName() {
        return this.className;
    }

    @JsonProperty
    public String getLevel() {
        return this.level;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    public String getException() {
        return this.exception;
    }

    @JsonProperty
    public String getThreadName() {
        return this.threadName;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getName() + " to JSON", e);
            return "Exception converting Testbed " + this.getClass().getName() + " to JSON: " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogLine)) {
            return false;
        }
        LogLine logLine = (LogLine)o;
        if (this.time != null ? !this.time.equals(logLine.time) : logLine.time != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(logLine.className) : logLine.className != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals(logLine.level) : logLine.level != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(logLine.message) : logLine.message != null) {
            return false;
        }
        if (this.exception != null ? !this.exception.equals(logLine.exception) : logLine.exception != null) {
            return false;
        }
        return this.threadName != null ? this.threadName.equals(logLine.threadName) : logLine.threadName == null;
    }

    public int hashCode() {
        int result = this.time != null ? this.time.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 31 * result + (this.threadName != null ? this.threadName.hashCode() : 0);
        return result;
    }
}

