/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.call_log_output;

import be.iminds.ilabt.jfed.json.util.JsonDateRFC3339ErrorIgnoringDeserializer;
import be.iminds.ilabt.jfed.json.util.JsonDateRFC3339Serializer;
import be.iminds.ilabt.jfed.log.ApiCallIdGenerator;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.library.JSonHelper;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
@XmlRootElement(name="call")
public class SerializableApiCallDetails {
    private static final Logger LOG = LoggerFactory.getLogger(SerializableApiCallDetails.class);
    private final int id;
    @XmlElement(name="autority_name")
    private final String authorityName;
    @XmlElement(name="authority_urn")
    private final String authorityUrn;
    private final String baseServerUrl;
    @XmlElement(name="server_url")
    private final String callServerUrl;
    @XmlElement(name="proxy_info")
    private final JFedConnection.ProxyInfo proxyInfo;
    @XmlElement(name="connection_sslauth_user_urn")
    private final String connectionSslAuthUserUrn;
    @XmlElement(name="connection_sslauth_user_certs")
    private final String connectionSslAuthUserCertificates;
    @XmlElement(name="connection_basicauth_username")
    private final String connectionBasicHttpAuthUsername;
    @XmlElement(name="connection_auth")
    private final String connectionAuthenticationMethod;
    @XmlElement(name="connection_proto")
    private final String connectionProtocol;
    @XmlElement(name="connection_type")
    private final String connectionType;
    @XmlElement(name="connection_id")
    private final String connectionId;
    @XmlElement(name="http_request_line")
    private final String httpRequestStatusLine;
    @XmlElement(name="http_request_headers")
    private final String httpRequestHeaders;
    @XmlElement(name="http_request")
    private final String httpRequest;
    @XmlElement(name="http_status_line")
    private final String httpResponseStatusLine;
    @XmlElement(name="http_response_headers")
    private final String httpResponseHeaders;
    @XmlElement(name="http_reply")
    private final String httpResponse;
    @XmlElement(name="api_name")
    private final String apiName;
    @XmlElement(name="java_method_name")
    private final String javaMethodName;
    @XmlElement(name="geni_method_name")
    private final String geniMethodName;
    @XmlElement(name="xmlrpc_request")
    private final String xmlRpcRequestJsonString;
    @XmlElement(name="xmlrpc_reply")
    private final String xmlRpcResponseJsonString;
    @XmlElement(name="geni_value")
    private final String xmlRpcGeniResponseValue;
    @XmlElement(name="geni_output")
    private final String xmlRpcGeniResponseOutput;
    @XmlElement(name="geni_code")
    private final String xmlRpcGeniResponseCode;
    @XmlElement(name="geni_response_code")
    private final Integer geniResponseCode;
    @XmlElement(name="geni_response_code_description")
    private final String geniResponseCodeDescription;
    @XmlElement(name="geni_code_is_success")
    private final Boolean geniResponseCodeIsSuccess;
    @XmlElement(name="geni_response_output")
    private final String geniResponseOutput;
    @XmlElement(name="start_time")
    private final Date startTime;
    @XmlElement(name="stop_time")
    private final Date stopTime;
    @XmlElement(name="protogeni_spew_log_url")
    private final String protogeniSpewLogUrl;
    @XmlElement(name="exception")
    private final String exceptionString;

    private SerializableApiCallDetails() {
        throw new RuntimeException("Not supported. For XML unmarshalling, use StaX instead of JAXB.");
    }

    @JsonCreator
    public SerializableApiCallDetails(@JsonProperty(value="id") int id, @JsonProperty(value="authorityName") String authorityName, @JsonProperty(value="authorityUrn") String authorityUrn, @JsonProperty(value="baseServerUrl") String baseServerUrl, @JsonProperty(value="callServerUrl") String callServerUrl, @JsonProperty(value="proxyInfo") JFedConnection.ProxyInfo proxyInfo, @JsonProperty(value="connectionSslAuthUserUrn") String connectionSslAuthUserUrn, @JsonProperty(value="connectionBasicHttpAuthUsername") String connectionBasicHttpAuthUsername, @JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="connectionSslAuthUserCertificates") String connectionSslAuthUserCertificates, @JsonProperty(value="connectionAuthenticationMethod") String connectionAuthenticationMethod, @JsonProperty(value="connectionProtocol") String connectionProtocol, @JsonProperty(value="connectionType") String connectionType, @JsonProperty(value="httpRequestStatusLine") String httpRequestStatusLine, @JsonProperty(value="httpRequestHeaders") String httpRequestHeaders, @JsonProperty(value="httpRequest") String httpRequest, @JsonProperty(value="httpResponseStatusLine") String httpResponseStatusLine, @JsonProperty(value="httpResponseHeaders") String httpResponseHeaders, @JsonProperty(value="httpResponse") String httpResponse, @JsonProperty(value="apiName") String apiName, @JsonProperty(value="javaMethodName") String javaMethodName, @JsonProperty(value="geniMethodName") String geniMethodName, @JsonProperty(value="xmlRpcRequestJsonString") String xmlRpcRequestJsonString, @JsonProperty(value="xmlRpcResponseJsonString") String xmlRpcResponseJsonString, @JsonProperty(value="xmlRpcGeniResponseValue") String xmlRpcGeniResponseValue, @JsonProperty(value="xmlRpcGeniResponseOutput") String xmlRpcGeniResponseOutput, @JsonProperty(value="xmlRpcGeniResponseCode") String xmlRpcGeniResponseCode, @JsonProperty(value="geniResponseCode") Integer geniResponseCode, @JsonProperty(value="geniResponseCodeDescription") String geniResponseCodeDescription, @JsonProperty(value="geniResponseCodeIsSuccess") Boolean geniResponseCodeIsSuccess, @JsonProperty(value="geniResponseOutput") String geniResponseOutput, @JsonProperty(value="startTime") Date startTime, @JsonProperty(value="stopTime") Date stopTime, @JsonProperty(value="protogeniSpewLogUrl") String protogeniSpewLogUrl, @JsonProperty(value="exceptionString") String exceptionString) {
        this.id = id;
        this.authorityName = authorityName;
        this.authorityUrn = authorityUrn;
        this.baseServerUrl = baseServerUrl;
        this.callServerUrl = callServerUrl;
        this.proxyInfo = proxyInfo;
        this.connectionSslAuthUserUrn = connectionSslAuthUserUrn;
        this.connectionBasicHttpAuthUsername = connectionBasicHttpAuthUsername;
        this.connectionAuthenticationMethod = connectionAuthenticationMethod;
        this.connectionProtocol = connectionProtocol;
        this.connectionType = connectionType;
        this.connectionId = connectionId;
        this.connectionSslAuthUserCertificates = connectionSslAuthUserCertificates;
        this.httpRequestStatusLine = httpRequestStatusLine;
        this.httpRequestHeaders = httpRequestHeaders;
        this.httpRequest = httpRequest;
        this.httpResponseStatusLine = httpResponseStatusLine;
        this.httpResponseHeaders = httpResponseHeaders;
        this.httpResponse = httpResponse;
        this.apiName = apiName;
        this.javaMethodName = javaMethodName;
        this.geniMethodName = geniMethodName;
        this.xmlRpcRequestJsonString = xmlRpcRequestJsonString;
        this.xmlRpcResponseJsonString = xmlRpcResponseJsonString;
        this.xmlRpcGeniResponseValue = xmlRpcGeniResponseValue;
        this.xmlRpcGeniResponseOutput = xmlRpcGeniResponseOutput;
        this.xmlRpcGeniResponseCode = xmlRpcGeniResponseCode;
        this.geniResponseCodeIsSuccess = geniResponseCodeIsSuccess;
        this.geniResponseCode = geniResponseCode;
        this.geniResponseOutput = geniResponseOutput;
        this.geniResponseCodeDescription = geniResponseCodeDescription;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.protogeniSpewLogUrl = protogeniSpewLogUrl;
        this.exceptionString = exceptionString;
    }

    public SerializableApiCallDetails(SerializableApiCallDetails sacd) {
        this.id = ApiCallIdGenerator.getNextId();
        this.authorityName = sacd.authorityName;
        this.authorityUrn = sacd.authorityUrn;
        this.baseServerUrl = sacd.baseServerUrl;
        this.callServerUrl = sacd.callServerUrl;
        this.proxyInfo = sacd.proxyInfo;
        this.connectionSslAuthUserUrn = sacd.connectionSslAuthUserUrn;
        this.connectionBasicHttpAuthUsername = sacd.connectionBasicHttpAuthUsername;
        this.connectionAuthenticationMethod = sacd.connectionAuthenticationMethod;
        this.connectionProtocol = sacd.connectionProtocol;
        this.connectionType = sacd.connectionType;
        this.connectionId = sacd.connectionId;
        this.connectionSslAuthUserCertificates = sacd.connectionSslAuthUserCertificates;
        this.httpRequestStatusLine = sacd.httpRequestStatusLine;
        this.httpRequestHeaders = sacd.httpRequestHeaders;
        this.httpRequest = sacd.httpRequest;
        this.httpResponseStatusLine = sacd.httpResponseStatusLine;
        this.httpResponseHeaders = sacd.httpResponseHeaders;
        this.httpResponse = sacd.httpResponse;
        this.apiName = sacd.apiName;
        this.javaMethodName = sacd.javaMethodName;
        this.geniMethodName = sacd.geniMethodName;
        this.xmlRpcRequestJsonString = sacd.xmlRpcRequestJsonString;
        this.xmlRpcResponseJsonString = sacd.xmlRpcResponseJsonString;
        this.xmlRpcGeniResponseValue = sacd.xmlRpcGeniResponseValue;
        this.xmlRpcGeniResponseOutput = sacd.xmlRpcGeniResponseOutput;
        this.xmlRpcGeniResponseCode = sacd.xmlRpcGeniResponseCode;
        this.geniResponseCodeIsSuccess = sacd.geniResponseCodeIsSuccess;
        this.geniResponseCode = sacd.geniResponseCode;
        this.geniResponseOutput = sacd.geniResponseOutput;
        this.geniResponseCodeDescription = sacd.geniResponseCodeDescription;
        this.startTime = sacd.startTime;
        this.stopTime = sacd.stopTime;
        this.protogeniSpewLogUrl = sacd.protogeniSpewLogUrl;
        this.exceptionString = sacd.exceptionString;
    }

    public int getId() {
        return this.id;
    }

    public String getAuthorityName() {
        return this.authorityName;
    }

    public String getAuthorityUrn() {
        return this.authorityUrn;
    }

    public String getBaseServerUrl() {
        return this.baseServerUrl;
    }

    public String getCallServerUrl() {
        return this.callServerUrl;
    }

    @JsonSerialize(as=JFedConnection.SshProxyInfo.class)
    @JsonDeserialize(as=JFedConnection.SshProxyInfo.class)
    public JFedConnection.ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public String getConnectionSslAuthUserUrn() {
        return this.connectionSslAuthUserUrn;
    }

    public String getConnectionBasicHttpAuthUsername() {
        return this.connectionBasicHttpAuthUsername;
    }

    public String getConnectionAuthenticationMethod() {
        return this.connectionAuthenticationMethod;
    }

    public String getConnectionProtocol() {
        return this.connectionProtocol;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getConnectionSslAuthUserCertificates() {
        return this.connectionSslAuthUserCertificates;
    }

    public String getHttpRequestStatusLine() {
        return this.httpRequestStatusLine;
    }

    public String getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    public String getHttpRequest() {
        return this.httpRequest;
    }

    public String getHttpResponseStatusLine() {
        return this.httpResponseStatusLine;
    }

    public String getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    public String getHttpResponse() {
        return this.httpResponse;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    public String getGeniMethodName() {
        return this.geniMethodName;
    }

    public String getXmlRpcRequestJsonString() {
        return this.xmlRpcRequestJsonString;
    }

    public String getXmlRpcResponseJsonString() {
        return this.xmlRpcResponseJsonString;
    }

    @JsonIgnore
    public Object getXmlRpcRequestJsonObject() {
        try {
            return JSonHelper.jsonStringToXmlRpcLikeObject(this.getXmlRpcRequestJsonString());
        }
        catch (Exception e) {
            LOG.warn("Exception while parsing JSON or JSON like XML-RPC request. Will return null.", e);
            return null;
        }
    }

    @JsonIgnore
    public Object getXmlRpcResponseJsonObject() {
        try {
            String jsonString = this.getXmlRpcResponseJsonString();
            if (jsonString == null) {
                return null;
            }
            return JSonHelper.jsonStringToXmlRpcLikeObject(jsonString);
        }
        catch (Exception e) {
            LOG.warn("Exception while parsing JSON or JSON like XML-RPC response. Will return null.", e);
            return null;
        }
    }

    @JsonIgnore
    public String getXmlRpcRequestHumanReadableString() {
        if (this.xmlRpcRequestJsonString == null) {
            return null;
        }
        return this.xmlRpcRequestJsonString.replaceAll("\\\\n", "\n");
    }

    @JsonIgnore
    public String getXmlRpcResponseHumanReadableString() {
        if (this.xmlRpcResponseJsonString == null) {
            return null;
        }
        return this.xmlRpcResponseJsonString.replaceAll("\\\\n", "\n");
    }

    public String getXmlRpcGeniResponseValue() {
        return this.xmlRpcGeniResponseValue;
    }

    public String getXmlRpcGeniResponseOutput() {
        return this.xmlRpcGeniResponseOutput;
    }

    public String getXmlRpcGeniResponseCode() {
        return this.xmlRpcGeniResponseCode;
    }

    public Integer getGeniResponseCode() {
        return this.geniResponseCode;
    }

    public String getGeniResponseCodeDescription() {
        return this.geniResponseCodeDescription;
    }

    public Boolean getGeniResponseCodeIsSuccess() {
        return this.geniResponseCodeIsSuccess;
    }

    public String getGeniResponseOutput() {
        return this.geniResponseOutput;
    }

    @JsonSerialize(using=JsonDateRFC3339Serializer.class)
    @JsonDeserialize(using=JsonDateRFC3339ErrorIgnoringDeserializer.class)
    public Date getStartTime() {
        return this.startTime;
    }

    @JsonSerialize(using=JsonDateRFC3339Serializer.class)
    @JsonDeserialize(using=JsonDateRFC3339ErrorIgnoringDeserializer.class)
    public Date getStopTime() {
        return this.stopTime;
    }

    public String getProtogeniSpewLogUrl() {
        return this.protogeniSpewLogUrl;
    }

    public String getExceptionString() {
        return this.exceptionString;
    }

    @JsonIgnore
    public String getAsJsonString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writer().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON", e);
            throw new RuntimeException("Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON", e);
        }
    }
}

