/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.call_log_output;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SerializableApiCallDetailsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SerializableApiCallDetailsFactory.class);

    public List<SerializableApiCallDetails> createFromApiCallDetails(Collection<ApiCallDetails> all) {
        ArrayList<ApiCallDetails> orig = new ArrayList<ApiCallDetails>(all);
        ArrayList<SerializableApiCallDetails> res = new ArrayList<SerializableApiCallDetails>();
        for (ApiCallDetails a : orig) {
            res.add(this.createFromApiCallDetails(a));
        }
        return res;
    }

    public SerializableApiCallDetails createFromApiCallDetails(ApiCallDetails acd) {
        String geniResponseOutput;
        Boolean geniResponseCodeIsSuccess;
        String geniResponseCodeDescription;
        Integer geniResponseCode;
        String xmlRpcGeniResponseCode;
        String xmlRpcGeniResponseOutput;
        Object xmlRpcGeniResponseValue;
        String connectionSslAuthUserCertificates;
        String connectionSslAuthUserUrn;
        int id = acd.getId();
        String authorityName = acd.getServerName();
        String authorityUrn = acd.getServerUrnString();
        String baseServerUrl = acd.getConnectionConfig().getServerUrlString();
        String callServerUrl = acd.getServerUrl();
        JFedConnection.ProxyInfo proxyInfo = acd.getConnectionConfig().getProxyInfo();
        if (acd.getConnectionConfig().getDebugInfo() != null && acd.getConnectionConfig().getDebugInfo().getGeniUserUrnString() != null) {
            connectionSslAuthUserUrn = acd.getConnectionConfig().getDebugInfo().getGeniUserUrnString();
            connectionSslAuthUserCertificates = acd.getConnectionConfig().getDebugInfo().getGeniUserCertificateChainPem();
        } else {
            connectionSslAuthUserUrn = null;
            connectionSslAuthUserCertificates = null;
        }
        String connectionBasicHttpAuthUsername = acd.getConnectionConfig().getLogin() == null ? null : acd.getConnectionConfig().getLogin().getUsername();
        String connectionAuthenticationMethod = "" + acd.getConnectionConfig().getAuthentication();
        String connectionProtocol = "" + acd.getConnectionConfig().getProtocol();
        String connectionType = "" + acd.getConnectionConfig().getType();
        String connectionId = acd.getConnectionId();
        String apiName = acd.getApiName();
        String javaMethodName = acd.getJavaMethodName();
        String geniMethodName = acd.getGeniMethodName();
        String httpRequestStatusLine = acd.getHttpRequestStatusLine();
        String httpRequestHeaders = acd.getHttpRequestHeaders();
        String httpRequest = acd.getHttpRequest();
        String httpResponseStatusLine = acd.getHttpResponseStatusLine();
        String httpResponseHeaders = acd.getHttpResponseHeaders();
        String httpResponse = acd.getHttpResponse();
        String xmlRpcRequestJsonString = XmlRpcPrintUtil.xmlRpcObjectToString(acd.getXmlRpcRequest());
        String xmlRpcResponseJsonString = XmlRpcPrintUtil.xmlRpcObjectToString(acd.getXmlRpcResponse());
        if (acd.getXmlRpcResponse() != null && acd.getXmlRpcResponse() instanceof Map) {
            Map ht = (Map)acd.getXmlRpcResponse();
            Object valueVal = ht.get("value");
            Object outputVal = ht.get("output");
            Object codeVal = ht.get("code");
            xmlRpcGeniResponseValue = valueVal != null ? XmlRpcPrintUtil.xmlRpcObjectToString(valueVal) : null;
            xmlRpcGeniResponseOutput = outputVal != null ? XmlRpcPrintUtil.xmlRpcObjectToString(outputVal) : null;
            String string = xmlRpcGeniResponseCode = codeVal != null ? XmlRpcPrintUtil.xmlRpcObjectToString(codeVal) : null;
            if (valueVal instanceof String) {
                xmlRpcGeniResponseValue = (String)valueVal;
            }
            if (valueVal instanceof Number || valueVal instanceof Boolean) {
                xmlRpcGeniResponseValue = "" + valueVal;
            }
        } else {
            xmlRpcGeniResponseValue = null;
            xmlRpcGeniResponseOutput = null;
            xmlRpcGeniResponseCode = null;
        }
        if (acd.getReply() != null && acd.getReply().getGeniResponseCode() != null) {
            geniResponseCode = acd.getReply().getGeniResponseCode().getCode();
            geniResponseCodeDescription = acd.getReply().getGeniResponseCode().getDescription();
            geniResponseCodeIsSuccess = acd.getReply().getGeniResponseCode().isSuccess();
            geniResponseOutput = acd.getReply().getOutput();
        } else {
            geniResponseCode = null;
            geniResponseCodeDescription = null;
            geniResponseCodeIsSuccess = null;
            geniResponseOutput = null;
        }
        Date startTime = acd.getStartTime();
        Date stopTime = acd.getStopTime();
        String protogeniSpewLogUrl = SerializableApiCallDetailsFactory.getProtogeniSpewLogUrl(acd.getReply());
        String exceptionString = acd.getException() != null ? TextUtil.exceptionToString(acd.getException()) : null;
        return new SerializableApiCallDetails(id, authorityName, authorityUrn, baseServerUrl, callServerUrl, proxyInfo, connectionSslAuthUserUrn, connectionBasicHttpAuthUsername, connectionId, connectionSslAuthUserCertificates, connectionAuthenticationMethod, connectionProtocol, connectionType, httpRequestStatusLine, httpRequestHeaders, httpRequest, httpResponseStatusLine, httpResponseHeaders, httpResponse, apiName, javaMethodName, geniMethodName, xmlRpcRequestJsonString, xmlRpcResponseJsonString, (String)xmlRpcGeniResponseValue, xmlRpcGeniResponseOutput, xmlRpcGeniResponseCode, geniResponseCode, geniResponseCodeDescription, geniResponseCodeIsSuccess, geniResponseOutput, startTime, stopTime, protogeniSpewLogUrl, exceptionString);
    }

    @Nullable
    public static String extractXmlRpcGeniResponseValue(@Nonnull ApiCallDetails acd) {
        if (acd.getXmlRpcResponse() != null && acd.getXmlRpcResponse() instanceof Map) {
            Map ht = (Map)acd.getXmlRpcResponse();
            Object valueVal = ht.get("value");
            return valueVal != null ? XmlRpcPrintUtil.xmlRpcObjectToString(valueVal) : null;
        }
        return null;
    }

    private static String getProtogeniSpewLogUrl(ApiCallReply reply) {
        Object rawResult;
        if (reply != null && (rawResult = reply.getRawResult()) != null && rawResult instanceof Map) {
            Map codeMap;
            Map rawMap = (Map)rawResult;
            Object urlObject = rawMap.get("protogeni_error_url");
            if (urlObject != null && urlObject instanceof String) {
                return (String)urlObject;
            }
            Object rawCode = rawMap.get("code");
            if (rawCode != null && rawCode instanceof Map && (urlObject = (codeMap = (Map)rawCode).get("protogeni_error_url")) != null && urlObject instanceof String) {
                return (String)urlObject;
            }
        }
        return null;
    }
}

