/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.impl;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateStatusDowntimeRrd
extends TestInstanceRrd {
    public static final String DOWNTIME_DS_NAME = "downtime";
    private static final Logger LOG = LoggerFactory.getLogger(AggregateStatusDowntimeRrd.class);

    public AggregateStatusDowntimeRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, DOWNTIME_DS_NAME);
    }

    public AggregateStatusDowntimeRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig, File altFile) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, DOWNTIME_DS_NAME, altFile);
    }

    @Override
    protected String getDsLine() {
        return this.getStringParam("rrd_downtime_ds");
    }

    @Override
    protected String getStepLine() {
        return this.getStringParam("rrd_downtime_step");
    }

    @Override
    protected String getRraLine() {
        return this.getStringParam("rrd_downtime_rra");
    }

    @Override
    public List<TestInstanceRrd.Val> getValues(@Nonnull Result result) {
        boolean debugHack;
        if (this.wasTestInPlannedMaintenance(result)) {
            return Collections.emptyList();
        }
        boolean bl = debugHack = this.testInstance != null && this.testInstance.getId() != null && (Integer)this.testInstance.getId() == 135;
        if (result.getSummaryStatus().equals((Object)Result.ResultStatus.FAILURE)) {
            Object failTimeMsObj = result.getSubResult("thisFailTimeMs");
            if (failTimeMsObj == null) {
                if (debugHack) {
                    LOG.info("getValues() debugHack fall back to using summary and frequency");
                }
                if (result.getSummaryStatus().equals((Object)Result.ResultStatus.SUCCESS)) {
                    if (debugHack) {
                        LOG.info("getValues() debugHack 0");
                    }
                    return Collections.singletonList(new TestInstanceRrd.Val(0.0));
                }
                if (this.testInstanceFrequency == null) {
                    return Collections.singletonList(new TestInstanceRrd.Val(Double.NaN));
                }
                if (this.testInstanceFrequency.getCron() == null) {
                    return Collections.singletonList(new TestInstanceRrd.Val(Double.NaN));
                }
                if (debugHack) {
                    LOG.info("getValues() debugHack nonnan");
                }
                String cron = this.testInstanceFrequency.getCron();
                for (int i = 2; i <= 30; ++i) {
                    if (!cron.equals("*/" + i + " * * * *")) continue;
                    return Collections.singletonList(new TestInstanceRrd.Val((double)(i * 60) * 1000.0));
                }
                if (debugHack) {
                    LOG.info("getValues() debugHack nan");
                }
                return Collections.singletonList(new TestInstanceRrd.Val(Double.NaN));
            }
            if (debugHack) {
                LOG.info("getValues() debugHack not null -> no fallback");
            }
            if (failTimeMsObj instanceof Number) {
                Number n = (Number)failTimeMsObj;
                if (debugHack) {
                    LOG.info("getValues() debugHack Number " + failTimeMsObj.getClass().getName() + " " + failTimeMsObj);
                }
                return Collections.singletonList(new TestInstanceRrd.Val(n.doubleValue()));
            }
            if (failTimeMsObj instanceof String) {
                if (debugHack) {
                    LOG.info("getValues() debugHack String " + failTimeMsObj);
                }
                return Collections.singletonList(new TestInstanceRrd.Val(Double.valueOf(Long.parseLong((String)failTimeMsObj))));
            }
            LOG.error("Result contains unsupported type for \"thisFailTimeMs\": " + failTimeMsObj.getClass().getName());
            return Collections.emptyList();
        }
        if (debugHack) {
            LOG.info("getValues() debugHack nofail");
        }
        return Collections.singletonList(new TestInstanceRrd.Val(0.0));
    }

    @Override
    public TestInstanceStatistics.RrdStatistics getTestStatistics() {
        if (!this.isEnabled() || !this.exists()) {
            return null;
        }
        long now = System.currentTimeMillis() / 1000L;
        long startMonth = now - RrdManager.rrdTimeToS("1M");
        long startWeek = now - RrdManager.rrdTimeToS("1w");
        long startDay = now - RrdManager.rrdTimeToS("1d");
        try {
            double totalDownTimeMonth = this.summarizeRawData(ConsolFun.TOTAL, startMonth, startWeek, TestInstanceRrd.SummaryOp.TOTAL, DOWNTIME_DS_NAME) / 1000.0;
            double totalDownTimeWeek = this.summarizeRawData(ConsolFun.TOTAL, startWeek, startDay, TestInstanceRrd.SummaryOp.TOTAL, DOWNTIME_DS_NAME) / 1000.0;
            double totalDownTimeDay = this.summarizeRawData(ConsolFun.TOTAL, startDay, now, TestInstanceRrd.SummaryOp.TOTAL, DOWNTIME_DS_NAME) / 1000.0;
            return new TestInstanceStatisticsBuilder.RrdStatisticsBuilder().setMetricName(DOWNTIME_DS_NAME).setUnit("s").setDayTotal(totalDownTimeDay).setWeekTotal(totalDownTimeWeek).setMonthTotal(totalDownTimeMonth).create();
        }
        catch (Exception e) {
            LOG.error("Failed to fetch statistics data from RRD", e);
            return null;
        }
    }

    public TestInstanceStatistics.SummationDetail calcAggregateDetail(RrdDb downTimeRrdDb, long period, long startPeriod, long endPeriod) throws IOException {
        double totalDownTime = this.summarizeRawData(ConsolFun.TOTAL, startPeriod, endPeriod, TestInstanceRrd.SummaryOp.TOTAL, DOWNTIME_DS_NAME) / 1000.0;
        double totalUptime = (double)period - totalDownTime;
        if (totalUptime < 0.0) {
            totalUptime = 0.0;
        }
        return new TestInstanceStatistics.SummationDetail(totalUptime, 0.0, totalDownTime, period);
    }

    @Override
    public TestInstanceStatistics.Summation getSummation() {
        long now = System.currentTimeMillis() / 1000L;
        long startYear = now - RrdManager.rrdTimeToS("1y");
        long startMonth = now - RrdManager.rrdTimeToS("1M");
        long startWeek = now - RrdManager.rrdTimeToS("1w");
        long startDay = now - RrdManager.rrdTimeToS("1d");
        try {
            RrdDb rrdDb = new RrdDb(this.rrdFile.getAbsolutePath(), true);
            return new TestInstanceStatisticsBuilder.SummationBuilder().setUnit("seconds").setYear(this.calcAggregateDetail(rrdDb, RrdManager.rrdTimeToS("1y"), startYear, now)).setMonth(this.calcAggregateDetail(rrdDb, RrdManager.rrdTimeToS("1M"), startMonth, now)).setWeek(this.calcAggregateDetail(rrdDb, RrdManager.rrdTimeToS("1w"), startWeek, now)).setDay(this.calcAggregateDetail(rrdDb, RrdManager.rrdTimeToS("1d"), startDay, now)).create();
        }
        catch (Exception e) {
            LOG.error("Failed to fetch statistics data from RRD", e);
            return null;
        }
    }

    @Override
    public List<TestInstanceRrd.GraphInfo> getGraphInfo() {
        long now = System.currentTimeMillis() / 1000L;
        ArrayList<TestInstanceRrd.GraphInfo> res = new ArrayList<TestInstanceRrd.GraphInfo>();
        LOG.debug("stored graph start=" + this.rrdDef.getStartTime());
        for (DsDef dsDef : this.rrdDef.getDsDefs()) {
            for (ArcDef arcDef : this.rrdDef.getArcDefs()) {
                long periodS = (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
                long graphStart = now - (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
                LOG.debug("graph start=" + graphStart + " stop=" + now + " diff=" + (now - graphStart));
                res.add(new TestInstanceRrd.GraphInfo(this.name, null, periodS, "Time with failure", this.testInstance, this.testDefinition, graphStart, now, this.rrdDef, dsDef, arcDef));
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public List<TestInstanceRrd.RawDataInfo> getRawDataInfo(String baseUri) {
        ArrayList<TestInstanceRrd.RawDataInfo> res = new ArrayList<TestInstanceRrd.RawDataInfo>();
        for (ArcDef arcDef : this.rrdDef.getArcDefs()) {
            TestInstanceRrd.RawDataInfo rdi = new TestInstanceRrd.RawDataInfo(this, this.testInstance, this.testDefinition, this.rrdDef, Arrays.asList(this.rrdDef.getDsDefs()), arcDef, baseUri);
            res.add(rdi);
        }
        return res;
    }

    @Override
    public File makeGraph(TestInstanceRrd.GraphInfo graphInfo) throws IOException {
        File tmpFile = File.createTempFile(graphInfo.getId(), ".png");
        RrdGraphDef gDef1 = new RrdGraphDef();
        gDef1.setWidth(500);
        gDef1.setHeight(300);
        gDef1.setFilename(tmpFile.getAbsolutePath());
        gDef1.setStartTime(graphInfo.getGraphStartTimeInSecondsSinceEpoch());
        gDef1.setEndTime(graphInfo.getGraphEndTimeInSecondsSinceEpoch());
        gDef1.setUnitsExponent(0);
        gDef1.setAltAutoscale(true);
        gDef1.setVerticalLabel("hours");
        long stepS = (long)graphInfo.getArcDef().getSteps() * graphInfo.getRrdDef().getStep();
        gDef1.setStep(stepS);
        String dsNickName = "downtime_ms";
        gDef1.datasource(dsNickName, this.rrdFile.getAbsolutePath(), graphInfo.getDsDef().getDsName(), graphInfo.getArcDef().getConsolFun());
        gDef1.datasource("downtime_hours", dsNickName + ",3600000.0,/");
        gDef1.area("downtime_hours", (Paint)AggregateStatusDowntimeRrd.colorByNr(0), graphInfo.getDsDef().getDsName());
        gDef1.setImageInfo("<img src='%s' width='%d' height='%d'>");
        gDef1.setImageFormat("png");
        LOG.debug("Rendering graph \"" + graphInfo.getId() + "\" to temp file \"" + tmpFile + "\"");
        RrdGraph graph1 = new RrdGraph(gDef1);
        return tmpFile;
    }
}

