/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FederationMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;

@RegisterMapper(value={FederationMapper.class})
public interface FederationDao {
    public static final String federationBaseNonIdColumns = "f.long_name, f.description, f.notes, array_to_string(f.urls, ',') AS urls_csv, f.parent_federation_id";
    public static final String allNonIdColumns = "f.long_name, f.description, f.notes, array_to_string(f.urls, ',') AS urls_csv, f.parent_federation_id, array_to_string(array_agg(m.testbed_id), ',') AS federation$testbed_ids";
    public static final String federationColumns = "f.id, f.long_name, f.description, f.notes, array_to_string(f.urls, ',') AS urls_csv, f.parent_federation_id, array_to_string(array_agg(m.testbed_id), ',') AS federation$testbed_ids";

    @SqlQuery(value="SELECT f.id, f.long_name, f.description, f.notes, array_to_string(f.urls, ',') AS urls_csv, f.parent_federation_id, array_to_string(array_agg(m.testbed_id), ',') AS federation$testbed_ids\n FROM federation f \n LEFT JOIN testbed_federation_mapping m ON m.federation_id = f.id \n WHERE id=:id GROUP BY f.id\n")
    public FederationBuilder findById(@NotNull @Bind(value="id") String var1);

    @SqlQuery(value="SELECT f.id, f.long_name, f.description, f.notes, array_to_string(f.urls, ',') AS urls_csv, f.parent_federation_id\n FROM federation f \n INNER JOIN testbed_federation_mapping m ON m.federation_id = f.id \n WHERE m.testbed_id=:testbedId")
    public List<FederationBuilder> findByTestbedId(@NotNull @Bind(value="serverId") String var1);

    @SqlQuery(value="SELECT f.id, f.long_name, f.description, f.notes, array_to_string(f.urls, ',') AS urls_csv, f.parent_federation_id, array_to_string(array_agg(m.testbed_id), ',') AS federation$testbed_ids\n FROM federation f  LEFT JOIN testbed_federation_mapping m ON m.federation_id = f.id \n GROUP BY f.id\n")
    public List<FederationBuilder> findAll();

    @SqlQuery(value="INSERT INTO federation (id,long_name, description, notes, urls, parent_federation_id) VALUES (:id,:longName,:description,:notes,CAST(string_to_array(:urlsAsCsv, ',') AS text[]),:federatedWithId)RETURNING id")
    public String insert(@BindBean Federation var1);

    @SqlUpdate(value="UPDATE federation \nSET long_name=:longName,\n    description=:description,\n    notes=:notes,\n    urls=CAST(string_to_array(:urlsAsCsv, ',') AS text[]),\n    parent_federation_id=:federatedWithId\nWHERE id=:id")
    public void update(@BindBean Federation var1);

    @SqlUpdate(value="DELETE FROM federation WHERE id=:id")
    public void delete(@Bind(value="id") String var1);
}

