/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GtsConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSet;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSetBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class GuiConfigSetMapper
implements ResultSetMapper<GuiConfigSet> {
    private static final ObjectMapper mapper = Jackson.newObjectMapper();

    @Override
    public GuiConfigSet map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        String loginSitesJsonStr;
        String triggeredMessagesJsonStr;
        String gtsJsonStr;
        GuiConfigSetBuilder builder = new GuiConfigSetBuilder();
        builder.setId(r.getString("id"));
        builder.setBindableServers(DaoCommon.idsToServer(r.getString("bindable_servers_id_csv")));
        builder.setHideServers(DaoCommon.idsToServer(r.getString("hide_servers_id_csv")));
        builder.setDescription(r.getString("description"));
        String flagsJsonStr = r.getString("flags_jsonstr");
        if (flagsJsonStr != null) {
            try {
                Map flags = mapper.readValue(flagsJsonStr, Map.class);
                builder.setFlags(flags);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert JSON for \"flags\" in DB to Map<String, Object>", e);
            }
        }
        if ((gtsJsonStr = r.getString("gts_jsonstr")) != null) {
            try {
                GtsConfig gtsConfig = mapper.readValue(gtsJsonStr, GtsConfig.class);
                builder.setGtsConfig(gtsConfig);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert JSON for \"gts\" in DB to GtsConfig", e);
            }
        }
        if ((triggeredMessagesJsonStr = r.getString("triggered_messages_jsonstr")) != null) {
            try {
                List messages = (List)mapper.readValue(triggeredMessagesJsonStr, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, TriggeredMessage.class));
                builder.setTriggeredMessages(messages);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert JSON for \"triggered_messages\" in DB to List<TriggeredMessage>", e);
            }
        }
        if ((loginSitesJsonStr = r.getString("login_sites_jsonstr")) != null) {
            try {
                List messages = (List)mapper.readValue(loginSitesJsonStr, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, LoginSite.class));
                builder.setLoginSites(messages);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert JSON for \"login_sites\" in DB to List<LoginSite>", e);
            }
        }
        return builder.create();
    }
}

