/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceClassMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GtsConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSet;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSetBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.HashPrefixStatementRewriter;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JFedExperimenterGuiConfigDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(JFedExperimenterGuiConfigDao.class);
    private final ResourceMapper resourceMapper = new ResourceMapper();
    private final ResourceClassMapper resourceClassMapper = new ResourceClassMapper();

    public List<ResourceClassBuilder> findResourceClassByUserConfigSet(Collection<String> guiConfigSetIds) {
        String resourceClassColumns = "rc.id AS resourceclass$id, rc.image_url, rc.image_id, rc.hrn, \nrc.visible_in_toolbox, rc.draggable_from_toolbox, rc.parent_id, rc.instantiate_as_id, \narray_to_string(rc.default_resource_id, ',') AS default_resource_id_csv, rc.weight";
        String resourceColumns = "r.id AS resource$id, r.server_id, r.rspec_element_name, r.layer3, \nr.require_fixed_node_assignment, r.require_disk_image, r.require_hardware_type, \nr.allow_fixed_node_assignment, r.allow_disk_image, r.allow_hardware_type, \nr.exclusive, r.allow_modify_exclusive, \nr.sliver_type, r.hardware_type, r.disk_image, r.component_urn, array_to_string(r.allowed_sliver_types, ',') AS allowed_sliver_types,r.allow_links, r.allow_stitched_links, r.default_link_type, array_to_string(r.allowed_link_types, ',') AS allowed_link_types, r.auto_filter_fixed_nodes_by_hardware_type, r.auto_filter_fixed_nodes_by_sliver_type, array_to_string(r.filter_fixed_nodes_by_hardware_type, ',') AS filter_fixed_nodes_by_hardware_type_csv, array_to_string(r.filter_fixed_nodes_by_sliver_type, ',') AS filter_fixed_nodes_by_sliver_type_csv, CAST(r.link_info AS TEXT) AS link_info_jsontext, overwrite_server_name, allow_site_selection ";
        String queryString = "SELECT " + resourceClassColumns + ",\n         " + resourceColumns + "\n FROM resourceclass rc\n LEFT JOIN resourceclass_resource_map map ON rc.id = map.resourceclass_id \n LEFT JOIN resource r ON r.id = map.resource_id \n WHERE rc.configset_id && string_to_array(#guiConfigSetsCsv, ',')::text[]    AND map.configset_id = ANY(string_to_array(#guiConfigSetsCsv, ',')::text[]) ";
        LOG.debug("Using query: " + queryString);
        Handle h2 = this.getHandle();
        Query query = h2.createQuery(queryString);
        query.setStatementRewriter(new HashPrefixStatementRewriter());
        String guiConfigSetsCsv = guiConfigSetIds.stream().collect(Collectors.joining(","));
        query = (Query)query.bind("guiConfigSetsCsv", guiConfigSetsCsv);
        TreeMap<String, ResourceClassBuilder> resourceClassBuilderById = new TreeMap<String, ResourceClassBuilder>();
        for (Map row : query) {
            String resourceClassId = DaoCommon.rowString(row, "resourceclass$id");
            Integer resourceId = DaoCommon.rowInteger(row, "resource$id");
            assert (resourceClassId != null);
            ResourceClassBuilder resourceClass = (ResourceClassBuilder)resourceClassBuilderById.get(resourceClassId);
            if (resourceClass == null) {
                try {
                    this.resourceClassMapper.setIncludeConfigSetIds(false);
                    this.resourceClassMapper.setIncludeDefaultResources(false);
                    this.resourceClassMapper.setIdColumnName("resourceclass$id");
                    resourceClass = this.resourceClassMapper.map(row);
                }
                catch (SQLException e) {
                    throw new RuntimeException("Exception mapping ResourceClass from " + row, e);
                }
                resourceClassBuilderById.put(resourceClassId, resourceClass);
            }
            List<Integer> defaultResourceIds = DaoCommon.rowIntegerArray(row, "default_resource_id_csv");
            if (resourceId == null) continue;
            ResourceBuilder resource = null;
            try {
                this.resourceMapper.setIdColumnName("resource$id");
                resource = this.resourceMapper.map(row);
            }
            catch (SQLException e) {
                throw new RuntimeException("Exception mapping Resource from " + row, e);
            }
            resourceClass.addResourceBuilder(resource);
            if (defaultResourceIds == null || !defaultResourceIds.contains(resourceId)) continue;
            resourceClass.addDefaultResourceBuilder(resource);
        }
        return new ArrayList<ResourceClassBuilder>(resourceClassBuilderById.values());
    }

    public List<GuiConfigSet> getUserConfigSets(Collection<String> guiConfigSetIds) {
        String queryString = "SELECT id,\n         array_to_string(bindable_servers_id, ',') AS bindable_servers_csv,\n         array_to_string(hide_servers_id, ',') AS hide_servers_csv, \n         flags::text AS flags_text, \n         gts::text AS gts_json_text, \n         triggered_messages::text AS triggered_messages_json_text, \n         login_sites::text AS login_sites_json_text \n FROM configset\n WHERE id = ANY(string_to_array(#guiConfigSetsCsv, ','))";
        LOG.debug("Using query: " + queryString);
        Handle h2 = this.getHandle();
        Query query = h2.createQuery(queryString);
        query.setStatementRewriter(new HashPrefixStatementRewriter());
        String guiConfigSetsCsv = guiConfigSetIds.stream().collect(Collectors.joining(","));
        query = (Query)query.bind("guiConfigSetsCsv", guiConfigSetsCsv);
        ArrayList<GuiConfigSet> res = new ArrayList<GuiConfigSet>();
        for (Map row : query) {
            GuiConfigSetBuilder guiConfigSetBuilder;
            block16: {
                String loginSitesJsonStr;
                block15: {
                    String triggeredMessagesJsonStr;
                    block14: {
                        String gtsJsonStr;
                        block13: {
                            String id = DaoCommon.rowString(row, "id");
                            List<Server> bindableServers = JFedExperimenterGuiConfigDao.idToServer(DaoCommon.rowIntegerArray(row, "bindable_servers_csv"));
                            List<Server> hideServers = JFedExperimenterGuiConfigDao.idToServer(DaoCommon.rowIntegerArray(row, "hide_servers_csv"));
                            String flagsStr = DaoCommon.rowString(row, "flags_text");
                            gtsJsonStr = DaoCommon.rowString(row, "gts_json_text");
                            triggeredMessagesJsonStr = DaoCommon.rowString(row, "triggered_messages_json_text");
                            loginSitesJsonStr = DaoCommon.rowString(row, "login_sites_json_text");
                            guiConfigSetBuilder = new GuiConfigSetBuilder();
                            guiConfigSetBuilder.setId(id);
                            guiConfigSetBuilder.setBindableServers(bindableServers);
                            guiConfigSetBuilder.setHideServers(hideServers);
                            if (flagsStr != null) {
                                try {
                                    Map flagsJson = new ObjectMapper().readValue(flagsStr, Map.class);
                                    guiConfigSetBuilder.setFlags(flagsJson);
                                }
                                catch (IOException e) {
                                    LOG.error("Error parsing flag JSON in DB. \"" + flagsStr + "\"");
                                    if ($assertionsDisabled) break block13;
                                    throw new AssertionError();
                                }
                            }
                        }
                        if (gtsJsonStr != null) {
                            try {
                                GtsConfig gtsConfig = new ObjectMapper().readValue(gtsJsonStr, GtsConfig.class);
                                guiConfigSetBuilder.setGtsConfig(gtsConfig);
                            }
                            catch (IOException e) {
                                LOG.error("Error parsing gts JSON in DB. \"" + gtsJsonStr + "\"", e);
                                if ($assertionsDisabled) break block14;
                                throw new AssertionError();
                            }
                        }
                    }
                    if (triggeredMessagesJsonStr != null) {
                        try {
                            List triggeredMessages = (List)new ObjectMapper().readValue(triggeredMessagesJsonStr, (TypeReference)new TypeReference<List<TriggeredMessage>>(){});
                            guiConfigSetBuilder.setTriggeredMessages(triggeredMessages);
                        }
                        catch (IOException e) {
                            LOG.error("Error parsing gts JSON in DB. \"" + triggeredMessagesJsonStr + "\"", e);
                            if ($assertionsDisabled) break block15;
                            throw new AssertionError();
                        }
                    }
                }
                if (loginSitesJsonStr != null) {
                    try {
                        List loginSites = (List)new ObjectMapper().readValue(loginSitesJsonStr, (TypeReference)new TypeReference<List<LoginSite>>(){});
                        guiConfigSetBuilder.setLoginSites(loginSites);
                    }
                    catch (IOException e) {
                        LOG.error("Error parsing gts JSON in DB. \"" + loginSitesJsonStr + "\"", e);
                        if ($assertionsDisabled) break block16;
                        throw new AssertionError();
                    }
                }
            }
            res.add(guiConfigSetBuilder.create());
        }
        return res;
    }

    @Transaction
    public JFedExperimenterGuiConfigBuilder getConfig(Collection<String> guiConfigSetIds) {
        List<ResourceClassBuilder> resourceClasses = this.findResourceClassByUserConfigSet(guiConfigSetIds);
        List<GuiConfigSet> guiConfigSets = this.getUserConfigSets(guiConfigSetIds);
        HashSet<Server> bindableServers = new HashSet<Server>();
        HashSet<Server> hideServers = new HashSet<Server>();
        TreeMap<String, Object> mergedFlags = new TreeMap<String, Object>();
        GtsConfig gtsConfig = null;
        HashSet<TriggeredMessage> triggeredMessages = new HashSet<TriggeredMessage>();
        HashSet<LoginSite> loginSites = new HashSet<LoginSite>();
        for (GuiConfigSet guiConfigSet : guiConfigSets) {
            assert (guiConfigSet != null);
            if (guiConfigSet.getBindableServers() != null) {
                bindableServers.addAll(guiConfigSet.getBindableServers());
            }
            if (guiConfigSet.getHideServers() != null) {
                hideServers.addAll(guiConfigSet.getHideServers());
            }
            if (guiConfigSet.getFlags() != null) {
                mergedFlags.putAll(guiConfigSet.getFlags());
            }
            if (guiConfigSet.getGtsConfig() != null) {
                assert (gtsConfig == null);
                gtsConfig = guiConfigSet.getGtsConfig();
            }
            if (guiConfigSet.getTriggeredMessages() != null) {
                triggeredMessages.addAll(guiConfigSet.getTriggeredMessages());
            }
            if (guiConfigSet.getLoginSites() == null) continue;
            loginSites.addAll(guiConfigSet.getLoginSites());
        }
        JFedExperimenterGuiConfigBuilder resBuilder = new JFedExperimenterGuiConfigBuilder();
        if (!bindableServers.isEmpty()) {
            resBuilder.setBindableServers(new ArrayList<Server>(bindableServers));
        }
        if (!hideServers.isEmpty()) {
            resBuilder.setHideServers(new ArrayList<Server>(hideServers));
        }
        if (!mergedFlags.isEmpty()) {
            resBuilder.setFlags(mergedFlags);
        }
        if (gtsConfig != null) {
            resBuilder.setGtsConfig(gtsConfig);
        }
        if (!triggeredMessages.isEmpty()) {
            resBuilder.setTriggeredMessages(triggeredMessages);
        }
        if (!loginSites.isEmpty()) {
            resBuilder.setLoginSites(loginSites);
        }
        resBuilder.setResourceClassBuilders(resourceClasses);
        return resBuilder;
    }

    private static List<Resource> idToResource(List<Integer> resourceIds) {
        if (resourceIds == null) {
            return null;
        }
        return resourceIds.stream().map(i -> JFedExperimenterGuiConfigDao.idToResource(i)).collect(Collectors.toList());
    }

    private static Resource idToResource(Integer resourceId) {
        if (resourceId == null) {
            return null;
        }
        return ((ResourceBuilder)new ResourceBuilder().setId(resourceId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    private static List<Server> idToServer(List<Integer> serverIds) {
        if (serverIds == null) {
            return null;
        }
        return serverIds.stream().map(i -> JFedExperimenterGuiConfigDao.idToServer(i)).collect(Collectors.toList());
    }

    private static Server idToServer(Integer serverId) {
        if (serverId == null) {
            return null;
        }
        return ((ServerBuilder)new ServerBuilder().setId(serverId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    private static List<ResourceClass> idToResourceClass(List<String> resourceClassIds) {
        if (resourceClassIds == null) {
            return null;
        }
        return resourceClassIds.stream().map(i -> JFedExperimenterGuiConfigDao.idToResourceClass(i)).collect(Collectors.toList());
    }

    private static ResourceClass idToResourceClass(String resourceClassId) {
        if (resourceClassId == null) {
            return null;
        }
        return ((ResourceClassBuilder)new ResourceClassBuilder().setId(resourceClassId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }
}

