/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganisationMapper
implements ResultSetMapper<OrganisationMappingHelper> {
    private static final Logger LOG = LoggerFactory.getLogger(OrganisationMapper.class);
    private final Map<String, OrganisationBuilder> organisationsById = new HashMap<String, OrganisationBuilder>();
    private final Map<String, List<Testbed>> testbedsByOrganisationName = new HashMap<String, List<Testbed>>();
    private final List<OrganisationBuilder> result = new ArrayList<OrganisationBuilder>();
    public OrganisationMappingHelper helper = new OrganisationMappingHelper(this.result);

    @Override
    public OrganisationMappingHelper map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        String id = r.getString("id");
        OrganisationBuilder organisationBuilder = this.organisationsById.get(id);
        List<Testbed> currentTestbeds = this.testbedsByOrganisationName.get(id);
        if (organisationBuilder == null) {
            organisationBuilder = ((OrganisationBuilder)new OrganisationBuilder().setId(id)).setName(r.getString("name")).setLocation(Location.decodeFromString(r.getString("coordinates"))).setLogoUrl(r.getString("logo_url")).setSiteUrl(r.getString("site_url")).setTestbeds(Collections.emptyList());
            organisationBuilder.setTechnicalContactEmails(DaoCommon.rowStringArray(r, "organisation$technical_contact_emails_csv"));
            currentTestbeds = new ArrayList<Testbed>();
            this.organisationsById.put(id, organisationBuilder);
            this.testbedsByOrganisationName.put(id, currentTestbeds);
            this.result.add(organisationBuilder);
        }
        if (r.getString("testbed$id") != null) {
            Testbed p = null;
            p = ((TestbedBuilder)new TestbedBuilder().setId(r.getString("testbed$id"))).setDefaultComponentManagerUrn(r.getString("testbed$urn")).setGeniId(r.getString("testbed$geni_id")).create();
            currentTestbeds.add(p);
        }
        organisationBuilder.setTestbeds(currentTestbeds);
        return this.helper;
    }

    public static class OrganisationMappingHelper {
        private final List<OrganisationBuilder> result;

        public OrganisationMappingHelper(List<OrganisationBuilder> result) {
            this.result = result;
        }

        public List<OrganisationBuilder> getResultBuilder() {
            return this.result;
        }

        public List<Organisation> getResult() {
            ArrayList<Organisation> res = new ArrayList<Organisation>();
            for (OrganisationBuilder b : this.result) {
                res.add(b.create());
            }
            return res;
        }

        public String toString() {
            return "OrganisationMappingHelper{result=" + this.result + "}";
        }
    }
}

