/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={ServerMapper.class})
public abstract class ServerDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(ServerDao.class);

    @SqlQuery(value="INSERT INTO server (id, testbed_id, name, allowed_certificate_alias, certificate_chain, base_url, coordinates, server_type, urn_tld, flags, scs, user_auth, default_scs, default_user_auth, default_urn, default_am) VALUES (DEFAULT,:testbedId, :name, :allowedCertificateAlias, :certificateChain, :baseUrl, :locationEncodedAsString,        :serverType, :urnTld, string_to_array(:flagsAsString, ','),         CAST(string_to_array(:scsIdsCsv, ',') AS integer[]),         CAST(string_to_array(:userAuthIdsCsv, ',') AS integer[]),         :defaultScsId, :defaultUserAuthId, :defaultComponentManagerUrn, :defaultAMService) RETURNING id")
    public abstract Integer insert(@BindBean Server var1);

    @SqlQuery(value="INSERT INTO server (id, testbed_id, name, allowed_certificate_alias, certificate_chain, base_url, coordinates, server_type, urn_tld, flags, scs, user_auth, default_scs, default_user_auth, default_urn, default_am) VALUES (:id,:testbedId, :name, :allowedCertificateAlias, :certificateChain, :baseUrl, :locationEncodedAsString,        :serverType, :urnTld, string_to_array(:flagsAsString, ','),         CAST(string_to_array(:scsIdsCsv, ',') AS integer[]),         CAST(string_to_array(:userAuthIdsCsv, ',') AS integer[]),         :defaultScsId, :defaultUserAuthId, :defaultComponentManagerUrn, :defaultAMService) RETURNING id")
    public abstract Integer insertWithForcedId(@BindBean Server var1);

    @SqlQuery(value="SELECT serve.id AS server$id,\n       serve.testbed_id AS server$testbed_id,\n       serve.name AS server$name,\n       serve.allowed_certificate_alias AS server$allowed_certificate_alias,\n       serve.certificate_chain AS server$certificate_chain,\n       serve.coordinates AS server$coordinates,\n       serve.server_type AS server$server_type,\n       serve.urn_tld AS server$urn_tld,\n       serve.base_url AS server$base_url,\n       array_to_string(serve.flags, ',') AS server$flags,\n       array_to_string(serve.scs, ',') AS server$scs,\n       array_to_string(serve.user_auth, ',') AS server$user_auth,\n       serve.default_scs AS server$default_scs,\n       serve.default_user_auth AS server$default_user_auth,\n       default_urn AS server$default_urn,\n       default_am AS server$default_am\n FROM server serve\n WHERE serve.id = :id")
    public abstract Server findById(@Bind(value="id") Integer var1);

    @SqlQuery(value="SELECT serve.id AS server$id,\n       serve.testbed_id AS server$testbed_id,\n       serve.name AS server$name,\n       serve.allowed_certificate_alias AS server$allowed_certificate_alias,\n       serve.certificate_chain AS server$certificate_chain,\n       serve.coordinates AS server$coordinates,\n       serve.server_type AS server$server_type,\n       serve.urn_tld AS server$urn_tld,\n       serve.base_url AS server$base_url,\n       array_to_string(serve.flags, ',') AS server$flags,\n       array_to_string(serve.scs, ',') AS server$scs,\n       array_to_string(serve.user_auth, ',') AS server$user_auth,\n       serve.default_scs AS server$default_scs,\n       serve.default_user_auth AS server$default_user_auth,\n       array_to_string(array_agg(servi.id), ',') AS server$service_ids,\n       default_urn AS server$default_urn,\n       default_am AS server$default_am\n FROM server serve\n LEFT OUTER JOIN service servi ON servi.server_id = serve.id\n WHERE serve.id = :id\n GROUP BY serve.id\n")
    public abstract Server findWithServicesById(@Bind(value="id") Integer var1);

    @SqlUpdate(value="UPDATE server \nSET testbed_id=:testbedId,\n    name=:name,\n    allowed_certificate_alias=:allowedCertificateAlias,\n    certificate_chain=:certificateChain,\n    coordinates=:locationEncodedAsString,\n    server_type=:serverType,\n    urn_tld=:urnTld,\n    base_url=:baseUrl,\n    flags=string_to_array(:flagsAsString, ','),\n    scs=CAST(string_to_array(:scsIdsCsv, ',') AS integer[]),\n    user_auth=CAST(string_to_array(:userAuthIdsCsv, ',') AS integer[]),\n    default_scs=:defaultScsId,\n    default_user_auth=:defaultUserAuthId,\n    default_urn=:defaultComponentManagerUrn,\n    default_am=:defaultAMServiceId\nWHERE id=:id")
    public abstract void update(@BindBean Server var1);
}

