/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMapper
implements ResultSetMapper<Server> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerMapper.class);

    @Override
    public Server map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        ServerBuilder builder = new ServerBuilder();
        builder.setId((Object)r.getInt("server$id"));
        builder.setBaseUrl(r.getString("server$base_url"));
        builder.setName(r.getString("server$name"));
        builder.setAllowedCertificateAlias(r.getString("server$allowed_certificate_alias"));
        builder.setCertificateChain(r.getString("server$certificate_chain"));
        builder.setServerType(r.getString("server$server_type"));
        builder.setUrnTld(r.getString("server$urn_tld"));
        builder.setScs(DaoCommon.idsToService(r.getString("server$scs")));
        builder.setUserAuth(DaoCommon.idsToService(r.getString("server$user_auth")));
        builder.setDefaultScs(DaoCommon.rowService(r, "server$default_scs"));
        builder.setDefaultUserAuth(DaoCommon.rowService(r, "server$default_user_auth"));
        builder.setDefaultAMService(DaoCommon.rowService(r, "server$default_am"));
        builder.setFlags(DaoCommon.csvToStringArray(r.getString("server$flags")));
        builder.setLocation(DaoCommon.toLocation(r.getString("server$coordinates")));
        builder.setDefaultComponentManagerUrn(r.getString("server$default_urn"));
        String testbedId = r.getString("server$testbed_id");
        if (testbedId != null) {
            builder.setTestbed(((TestbedBuilder)new TestbedBuilder().setId(testbedId)).create());
        }
        if (ServerMapper.hasColumn(r, "server$service_ids")) {
            List<Service> services = DaoCommon.idsToService(r.getString("server$service_ids"));
            if (services == null || services.isEmpty()) {
                builder.setServices(null);
            } else {
                builder.setServices(services);
            }
        }
        return builder.create();
    }

    public static boolean hasColumn(ResultSet rs, String columnName) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columns = rsmd.getColumnCount();
        for (int x = 1; x <= columns; ++x) {
            if (!columnName.equals(rsmd.getColumnName(x))) continue;
            return true;
        }
        return false;
    }
}

