/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionParameter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestDefinitionMapper
implements ResultSetMapper<TestDefinition> {
    private static final ObjectMapper mapper = Jackson.newObjectMapper();

    @Override
    public TestDefinition map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        ArrayList<TestDefinitionParameter> parameters;
        String tdName = r.getString("id");
        TestDefinitionBuilder td = ((TestDefinitionBuilder)new TestDefinitionBuilder().setId(tdName)).setType(r.getString("test_type")).setMaxTestDurationMs(r.getObject("max_test_duration_ms") == null ? null : Long.valueOf(r.getLong("max_test_duration_ms")));
        td.setGeniDatastoreMetric(r.getString("geni_datastore_metric"));
        td.setGeniDatastoreDescription(r.getString("geni_datastore_description"));
        td.setGeniDatastoreUnits(r.getString("geni_datastore_units"));
        String parameterDefinitionJsonText = r.getString("parameter_definition_json_text");
        if (parameterDefinitionJsonText != null) {
            try {
                parameters = new ArrayList((Collection)mapper.readValue(parameterDefinitionJsonText, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, TestDefinitionParameter.class)));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert JSON in DB to Map<String, String>", e);
            }
        } else {
            parameters = new ArrayList<TestDefinitionParameter>();
        }
        if (DaoCommon.rowBoolean(r, "has_server_parameter", false)) {
            parameters.add(TestDefinition.getServerTestDefinitionParameter());
        }
        if (DaoCommon.rowBoolean(r, "has_user_parameter", false)) {
            parameters.add(TestDefinition.getUserTestDefinitionParameter());
        }
        if (parameters.isEmpty()) {
            td.setParameters(Collections.emptyList());
        } else {
            td.setParameters(parameters);
        }
        return td.create();
    }
}

