/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.HashPrefixStatementRewriter;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={TestInstanceMapper.class})
public abstract class TestInstanceDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(TestInstanceDao.class);

    @SqlQuery(value="SELECT ti.id,name,testdefinition_id,enabled,selftest_immune,frequency_id,test_version_name,parameter_values,user_parameter_value,server_parameter_value,f.description AS frequency$description,f.cron AS frequency$cron  FROM testinstance ti  LEFT JOIN frequency f ON f.id=ti.frequency_id  WHERE ti.id = :id")
    protected abstract List<TestInstance> findByIdHelper(@NotNull @Bind(value="id") int var1);

    @SqlQuery(value="SELECT ti.id,name,testdefinition_id,enabled,selftest_immune,frequency_id,test_version_name,parameter_values,user_parameter_value,server_parameter_value,f.description AS frequency$description,f.cron AS frequency$cron  FROM testinstance ti  LEFT JOIN frequency f ON f.id=ti.frequency_id")
    public abstract List<TestInstance> findAll();

    @SqlQuery(value="INSERT INTO testinstance      (id, name, testdefinition_id, enabled, selftest_immune, frequency_id, test_version_name, user_parameter_value, server_parameter_value, parameter_values) \n VALUES (DEFAULT, :name, :testDefinitionId, :enabled, :selfTestImmune, :frequencyId, :testVersion, :userIdParameter, :serverIdParameter, CAST(:parametersExceptServerAndUserAsJsonString AS jsonb)) \n RETURNING id")
    public abstract Integer insert(@BindBean TestInstance var1);

    @SqlUpdate(value="UPDATE testinstance  SET name=:name,enabled=:enabled,selftest_immune=:selfTestImmune,testdefinition_id=:testDefinitionId,frequency_id=:frequencyId,test_version_name=:testVersion,user_parameter_value=:userIdParameter,server_parameter_value=:serverIdParameter,parameter_values=CAST(:parametersExceptServerAndUserAsJsonString AS jsonb)  WHERE id=:id")
    public abstract void update(@Nonnull @BindBean TestInstance var1);

    @SqlUpdate(value="UPDATE testinstance  SET name=:name WHERE id=:id")
    public abstract void updateNextRun(@Nonnull Integer var1, @Nonnull Timestamp var2);

    @SqlUpdate(value="DELETE FROM testinstance WHERE id = :testInstanceId")
    public abstract void deleteById(@Bind(value="testInstanceId") Integer var1);

    public TestInstance findById(int id) {
        List<TestInstance> h2 = this.findByIdHelper(id);
        if (h2 == null || h2.isEmpty()) {
            return null;
        }
        if (h2.size() > 1) {
            throw new RuntimeException("Implementation error: this query should have returned only a single TestInstance, but it returned " + h2.size() + " instead");
        }
        return h2.get(0);
    }

    public List<TestInstance> search(List<String> versionNameFilter, List<String> testInstanceNameFilter, List<String> testDefinitionNameFilter, List<Integer> testInstanceIdFilter, List<String> testbedCategoryFilter, List<String> testbedGeniNameFilter, List<String> testbedNameFilter, List<String> testbedUrnFilter, boolean nextRun, Boolean disabled, Boolean activeTask, List<String> usernameIdFilter, List<Integer> serverIdFilter) {
        List<TestInstance> list;
        boolean hasTestbedFilter = false;
        ArrayList<Object> whereParts = new ArrayList<Object>();
        if (versionNameFilter != null && !versionNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.test_version_name", "ver", versionNameFilter.size()));
        }
        if (testInstanceNameFilter != null && !testInstanceNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.name", "name", testInstanceNameFilter.size()));
        }
        if (testDefinitionNameFilter != null && !testDefinitionNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testdefinition_id", "td", testDefinitionNameFilter.size()));
        }
        if (testInstanceIdFilter != null && !testInstanceIdFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.id", "id", testInstanceIdFilter.size()));
        }
        if (testbedCategoryFilter != null && !testbedCategoryFilter.isEmpty()) {
            whereParts.add("ARRAY[" + DaoCommon.makeWherePartList("tbcat", testbedCategoryFilter.size()) + "]::varchar[] && ti.testbed_categories");
            hasTestbedFilter = true;
        }
        if (testbedGeniNameFilter != null && !testbedGeniNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testbed_geni_id", "tbgeni", testbedGeniNameFilter.size()));
            hasTestbedFilter = true;
        }
        if (testbedUrnFilter != null && !testbedUrnFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testbed_default_urn", "tburn", testbedUrnFilter.size()));
            hasTestbedFilter = true;
        }
        if (testbedNameFilter != null && !testbedNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testbed_id", "tb", testbedNameFilter.size()));
            hasTestbedFilter = true;
        }
        if (usernameIdFilter != null && !usernameIdFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.user_parameter_value", "usr", usernameIdFilter.size()));
        }
        if (serverIdFilter != null && !serverIdFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.server_parameter_value", "sid", serverIdFilter.size()));
        }
        if (nextRun) {
            whereParts.add("ti.next_run IS NULL OR ti.next_run <= NOW()");
        }
        if (disabled != null) {
            if (disabled.booleanValue()) {
                whereParts.add("ti.enabled = FALSE");
            } else {
                whereParts.add("ti.enabled = TRUE");
            }
        }
        if (activeTask != null) {
            if (activeTask.booleanValue()) {
                whereParts.add("task.id IS NOT NULL");
            } else {
                whereParts.add("task.id IS NULL");
            }
        }
        String queryString = "SELECT ti.id,name,testdefinition_id,enabled,selftest_immune,frequency_id,test_version_name,parameter_values,user_parameter_value,server_parameter_value,f.description AS frequency$description,f.cron AS frequency$cron " + (hasTestbedFilter ? " FROM testinstance_with_testbed ti " : " FROM testinstance ti ") + " LEFT JOIN frequency f ON f.id=ti.frequency_id " + (activeTask != null ? " LEFT JOIN task task ON task.testinstance_id=ti.id AND (task.state = 'RUNNING' OR task.state = 'CREATED' OR task.state = 'CANCELLING') " : "") + " ";
        if (!whereParts.isEmpty()) {
            queryString = queryString + " WHERE ";
            boolean first = true;
            for (String string : whereParts) {
                if (!first) {
                    queryString = queryString + " AND ";
                }
                queryString = queryString + "(" + string + ")";
                first = false;
            }
            queryString = queryString + " ";
        }
        LOG.debug("search() queryString=\"" + queryString + "\"");
        Handle h2 = this.getHandle();
        h2.registerMapper(new TestInstanceMapper());
        Query<Map<String, Object>> query = h2.createQuery(queryString);
        query.setStatementRewriter(new HashPrefixStatementRewriter());
        if (versionNameFilter != null && !versionNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "ver", versionNameFilter);
        }
        if (testInstanceNameFilter != null && !testInstanceNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "name", testInstanceNameFilter);
        }
        if (testDefinitionNameFilter != null && !testDefinitionNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "td", testDefinitionNameFilter);
        }
        if (testInstanceIdFilter != null && !testInstanceIdFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "id", testInstanceIdFilter);
        }
        if (testbedCategoryFilter != null && !testbedCategoryFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tbcat", testbedCategoryFilter);
        }
        if (testbedGeniNameFilter != null && !testbedGeniNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tbgeni", testbedGeniNameFilter);
        }
        if (testbedUrnFilter != null && !testbedUrnFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tburn", testbedUrnFilter);
        }
        if (testbedNameFilter != null && !testbedNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tb", testbedNameFilter);
        }
        if (usernameIdFilter != null && !usernameIdFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "usr", usernameIdFilter);
        }
        if (serverIdFilter != null && !serverIdFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "sid", serverIdFilter);
        }
        if ((list = query.mapTo(TestInstance.class).list()).isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }
}

