/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FrequencyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestInstanceMapper
implements ResultSetMapper<TestInstance> {
    private static final ObjectMapper mapper = Jackson.newObjectMapper();
    private static final TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};

    @Override
    public TestInstance map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        Integer serverParameterValue;
        String userParameterValue;
        int tiId = r.getInt("id");
        Integer frequencyId = r.getObject("frequency_id") == null ? null : Integer.valueOf(r.getInt("frequency_id"));
        TestInstanceBuilder ti = ((TestInstanceBuilder)new TestInstanceBuilder().setId((Object)tiId)).setName(r.getString("name")).setTestDefinition(r.getString("testdefinition_id")).setTestVersion(r.getString("test_version_name")).setEnabled(r.getBoolean("enabled")).setSelfTestImmune(r.getBoolean("selftest_immune")).setFrequency(frequencyId != null ? ((FrequencyBuilder)new FrequencyBuilder().setId(frequencyId)).setDescription(r.getString("frequency$description")).setCron(r.getString("frequency$cron")).create() : null);
        String parameterValuesJsonString = r.getString("parameter_values");
        if (parameterValuesJsonString != null) {
            try {
                HashMap parameters = (HashMap)mapper.readValue(parameterValuesJsonString, typeRef);
                ti.setParametersExceptServerAndUser(parameters);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert JSON in DB to Map<String, String>", e);
            }
        }
        if ((userParameterValue = r.getString("user_parameter_value")) != null) {
            ti.setUserParameter(userParameterValue, userParameterValue, null);
        }
        if ((serverParameterValue = DaoCommon.rowInteger(r, "server_parameter_value")) != null) {
            ti.setServerParameter(serverParameterValue, null);
        }
        return ti.create();
    }
}

