/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResultMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedCategoryMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.HashPrefixStatementRewriter;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={TestbedCategoryMapper.class})
public abstract class TestbedCategoryDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedCategoryDao.class);

    @SqlQuery(value="SELECT id,name,gui_filter,m.testbed_id AS testbed FROM testbed_category c FULL JOIN testbed_category_mapping m ON c.id=m.category_id WHERE id=:id")
    public abstract List<TestbedCategoryMapper.TestbedCategoryMappingHelper> findByIdHelper(@NotNull @Bind(value="id") int var1);

    @SqlQuery(value="SELECT id,name,gui_filter,m.testbed_id AS testbed FROM testbed_category c FULL JOIN testbed_category_mapping m ON c.id=m.category_id")
    public abstract List<TestbedCategoryMapper.TestbedCategoryMappingHelper> findAllHelper();

    @SqlQuery(value="SELECT id FROM testbed_category c WHERE name=:name")
    public abstract Integer findIdByName(@NotNull @Bind(value="name") String var1);

    @SqlQuery(value="INSERT INTO testbed_category (id,name,gui_filter) VALUES (DEFAULT,:name,:guiFilter) RETURNING id")
    public abstract Integer insertCategory(@Nonnull @Bind(value="name") String var1, @Bind(value="guiFilter") boolean var2);

    @SqlQuery(value="INSERT INTO testbed_category (id,name,gui_filter) VALUES (DEFAULT,:name,:guiFilter) ON CONFLICT (name) DO UPDATE SET name=EXCLUDED.name,gui_filter=EXCLUDED.gui_filter RETURNING id")
    public abstract Integer insertCategoryIfMissing(@Nonnull @Bind(value="name") String var1, @Bind(value="guiFilter") boolean var2);

    @SqlUpdate(value="INSERT INTO testbed_category_mapping (testbed_id,category_id) VALUES (:testbedId,:categoryId) ")
    public abstract void addTestbedToCategory(@Nonnull @Bind(value="testbedId") String var1, @Nonnull @Bind(value="categoryId") Integer var2);

    public List<TestbedCategory> findAll() {
        List<TestbedCategoryMapper.TestbedCategoryMappingHelper> h2 = this.findAllHelper();
        if (h2.isEmpty()) {
            return Collections.emptyList();
        }
        return h2.get(0).getResult();
    }

    public TestbedCategory findById(@NotNull int id) {
        List<TestbedCategoryMapper.TestbedCategoryMappingHelper> h2 = this.findByIdHelper(id);
        if (h2.isEmpty() || h2.get(0).getResult() == null || h2.get(0).getResult().isEmpty()) {
            return null;
        }
        if (h2.get(0).getResult().size() > 1) {
            throw new RuntimeException("Implementation error: this query should have returned only a single TestbedCategory, but it returned " + h2.get(0).getResult().size() + " instead");
        }
        return h2.get(0).getResult().get(0);
    }

    @Transaction
    public void addTestbedToCategory(@Nonnull String testbedId, @Nonnull String categoryName, boolean addCategoryIfNotExisting) {
        Integer categoryId = addCategoryIfNotExisting ? this.insertCategoryIfMissing(categoryName, false) : this.findIdByName(categoryName);
        assert (categoryId != null);
        this.addTestbedToCategory(testbedId, categoryId);
    }

    @SqlUpdate(value="DELETE FROM testbed_category_mapping WHERE testbed_id = :testbedId")
    public abstract void deleteAllTestbedCategoryMappingForTestbed(@Nonnull @Bind(value="testbedId") String var1);

    public void deleteTestbedCategoryMapping(@Nonnull String testbedId, @Nonnull List<Integer> categoryIds) {
        if (categoryIds.isEmpty()) {
            return;
        }
        Object queryString = "DELETE FROM testbed_category_mapping WHERE testbed_id = #testbedId AND category_id NOT IN (";
        boolean first = true;
        for (Integer categoryId : categoryIds) {
            if (!first) {
                queryString = (String)queryString + ", ";
            }
            queryString = (String)queryString + "#categoryId" + categoryId;
            first = false;
        }
        queryString = (String)queryString + ")";
        Handle h2 = this.getHandle();
        h2.registerMapper(new ResultMapper());
        Update query = h2.createStatement((String)queryString);
        query.setStatementRewriter(new HashPrefixStatementRewriter());
        query = (Update)query.bind("testbedId", testbedId);
        for (Integer categoryId : categoryIds) {
            query = (Update)query.bind("categoryId" + categoryId, categoryId);
        }
        int rows = query.execute();
        LOG.debug("Removed " + rows + " rows while deleting category mapping for " + testbedId + " not in " + categoryIds);
    }

    public void addTestbedCategoryMapping(@Nonnull @Bind(value="testbedId") String testbedId, @Nonnull @Bind(value="categoryId") List<Integer> categoryIds) {
        if (categoryIds.isEmpty()) {
            return;
        }
        Object queryString = "INSERT INTO testbed_category_mapping (testbed_id,category_id) VALUES ";
        boolean first = true;
        for (Integer categoryId : categoryIds) {
            if (!first) {
                queryString = (String)queryString + ", ";
            }
            queryString = (String)queryString + "(#testbedId, #categoryId" + categoryId + ")";
            first = false;
        }
        Handle h2 = this.getHandle();
        h2.registerMapper(new ResultMapper());
        Update query = h2.createStatement((String)queryString);
        query.setStatementRewriter(new HashPrefixStatementRewriter());
        query = (Update)query.bind("testbedId", testbedId);
        for (Integer categoryId : categoryIds) {
            query = (Update)query.bind("categoryId" + categoryId, categoryId);
        }
        int rows = query.execute();
        LOG.debug("Added " + rows + " rows while adding category mapping for " + testbedId + " not in " + categoryIds);
        assert (categoryIds.size() == rows);
    }

    @Transaction
    public void setCategoryNamesForTestbed(@Nonnull String testbedId, @Nonnull List<String> categoryNames) {
        ArrayList<Integer> categoryIds = new ArrayList<Integer>(categoryNames.size());
        for (String categoryName : categoryNames) {
            Integer categoryId = this.findIdByName(categoryName);
            if (categoryId != null) continue;
            throw new RuntimeException("No category \"" + categoryName + "\" found");
        }
        assert (categoryIds.size() == categoryNames.size());
        this.setCategoryIdsForTestbed(testbedId, categoryIds);
    }

    @Transaction
    public void setCategoryIdsForTestbed(@Nonnull String testbedId, @Nonnull List<Integer> categoryIds) {
        this.deleteAllTestbedCategoryMappingForTestbed(testbedId);
        this.addTestbedCategoryMapping(testbedId, categoryIds);
    }
}

