/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategoryBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedCategoryMapper
implements ResultSetMapper<TestbedCategoryMappingHelper> {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedCategoryMapper.class);
    private final Map<Integer, TestbedCategoryBuilder> catById = new HashMap<Integer, TestbedCategoryBuilder>();
    private final Map<Integer, List<String>> testbedsByCatId = new HashMap<Integer, List<String>>();
    private final List<TestbedCategoryBuilder> result = new ArrayList<TestbedCategoryBuilder>();
    public TestbedCategoryMappingHelper helper = new TestbedCategoryMappingHelper(this.result);

    @Override
    public TestbedCategoryMappingHelper map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        int id = r.getInt("id");
        String name = r.getString("name");
        boolean guiFilter = r.getBoolean("gui_filter");
        String testbed = r.getString("testbed");
        TestbedCategoryBuilder cat = this.catById.get(id);
        List<String> currentTestbeds = this.testbedsByCatId.get(id);
        if (cat == null) {
            cat = ((TestbedCategoryBuilder)new TestbedCategoryBuilder().setId((Object)id)).setName(name).setGuiFilter(guiFilter).setTestbedIds(Collections.emptyList());
            currentTestbeds = new ArrayList<String>();
            this.catById.put(id, cat);
            this.testbedsByCatId.put(id, currentTestbeds);
            this.result.add(cat);
        }
        if (testbed != null) {
            currentTestbeds.add(testbed);
        }
        cat.setTestbedIds(currentTestbeds);
        return this.helper;
    }

    public static class TestbedCategoryMappingHelper {
        private final List<TestbedCategoryBuilder> result;

        public TestbedCategoryMappingHelper(List<TestbedCategoryBuilder> result) {
            this.result = result;
        }

        public List<TestbedCategoryBuilder> getResultBuilder() {
            return this.result;
        }

        public List<TestbedCategory> getResult() {
            ArrayList<TestbedCategory> res = new ArrayList<TestbedCategory>();
            for (TestbedCategoryBuilder b : this.result) {
                res.add(b.create());
            }
            return res;
        }
    }
}

