/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ProxyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedMapper
implements ResultSetMapper<Testbed> {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedMapper.class);

    @Override
    public Testbed map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        String organisationId;
        URI geniUrl;
        String geniHrefString;
        List categoryIds;
        List<Object> categoryNames;
        String categoriesString = r.getString("categories");
        if (categoriesString != null && !categoriesString.trim().isEmpty()) {
            String[] cats = categoriesString.split(",");
            categoryNames = Arrays.asList(cats);
        } else {
            categoryNames = Collections.emptyList();
        }
        String categoryIdsString = r.getString("category_ids");
        if (categoryIdsString != null && !categoryIdsString.trim().isEmpty()) {
            String[] catIds = categoryIdsString.split(",");
            categoryIds = new ArrayList();
            for (String catIdStr : catIds) {
                categoryIds.add(Integer.parseInt(catIdStr));
            }
        } else {
            categoryIds = Collections.emptyList();
        }
        if ((geniHrefString = r.getString("geni_href")) != null && !geniHrefString.trim().isEmpty()) {
            try {
                geniUrl = new URI(geniHrefString);
            }
            catch (URISyntaxException e) {
                LOG.error("geni_href for testbed \"" + r.getString("id") + "\" is \"" + geniHrefString + "\", which does not parse as a URI");
                geniUrl = null;
            }
        } else {
            geniUrl = null;
        }
        TestbedBuilder builder = new TestbedBuilder();
        builder = ((TestbedBuilder)builder.setId(r.getString("id"))).setLongName(r.getString("long_name")).setInterfaceUrl(r.getString("iface_url")).setPingHost(r.getString("ping_host")).setInfoUrl(r.getString("info_url")).setHelpUrl(r.getString("help_url")).setDefaultComponentManagerUrn(r.getString("urn")).setOtrsName(r.getString("otrs_name")).setDescription(r.getString("description")).setGeniId(r.getString("geni_id")).setAllowLinks(r.getBoolean("allow_links")).setColor(r.getString("color")).setNodesLocationVisualisationCoordinatesUrl(r.getString("nodes_location_visualisation_coordinates_url")).setNodesLocationVisualisationImageUrl(r.getString("nodes_location_visualisation_image_url")).setGeniHref(geniUrl);
        Object proxIdObj = r.getObject("proxy$id");
        if (proxIdObj != null) {
            ProxyBuilder proxyBuilder = new ProxyBuilder();
            proxyBuilder.setId((Object)r.getInt("proxy$id"));
            proxyBuilder.setName(r.getString("proxy$name"));
            proxyBuilder.setType(r.getString("proxy$type"));
            proxyBuilder.setHostname(r.getString("proxy$hostname"));
            proxyBuilder.setPortRange(r.getString("proxy$port_range"));
            proxyBuilder.setHostKey(r.getString("proxy$host_key"));
            proxyBuilder.setUsernamePattern(r.getString("proxy$username_pattern"));
            builder.setProxyBuilders(Arrays.asList(proxyBuilder));
        }
        if ((organisationId = r.getString("organisation$id")) != null) {
            builder.setOrganisation(((OrganisationBuilder)new OrganisationBuilder().setId(organisationId)).create());
        }
        assert (categoryIds.size() == categoryNames.size());
        for (int i = 0; i < categoryNames.size(); ++i) {
            Integer id = (Integer)categoryIds.get(i);
            String name = (String)categoryNames.get(i);
            builder = builder.addCategory(id, name);
        }
        return builder.create();
    }
}

