/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="federation", builderClass=FederationBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Federation
extends PrimaryIdObject<String>
implements Comparable {
    private static final Logger LOG = LoggerFactory.getLogger(Federation.class);
    private final String longName;
    private final List<URI> urls;
    private final String description;
    private final String notes;
    private final List<Testbed> testbeds;
    private final Federation federatedWith;
    private static final Comparator<String> ID_COMP = Comparator.naturalOrder();

    @JsonCreator
    Federation(@JsonProperty(value="id") String id, @JsonProperty(value="longName") String longName, @JsonProperty(value="urls") List<URI> urls, @JsonProperty(value="description") String description, @JsonProperty(value="notes") String notes, @JsonProperty(value="testbeds") Collection<Testbed> testbeds, @JsonProperty(value="federatedWith") Federation federatedWith, @JsonProperty(value="@id") URI uri) {
        this(id, longName, urls, description, notes, testbeds, federatedWith, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Federation(String id, String longName, List<URI> urls, String description, String notes, Collection<Testbed> testbeds, Federation federatedWith, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.longName = longName;
        this.urls = urls == null ? null : Collections.unmodifiableList(new ArrayList<URI>(urls));
        this.description = description;
        this.notes = notes;
        this.testbeds = testbeds == null ? null : Collections.unmodifiableList(new ArrayList<Testbed>(testbeds));
        this.federatedWith = federatedWith;
    }

    @JsonProperty
    public String getLongName() {
        return this.longName;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.FederationDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    public Federation getFederatedWith() {
        return this.federatedWith;
    }

    @JsonIgnore
    public String getFederatedWithId() {
        return this.federatedWith == null ? null : (String)this.federatedWith.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestbedListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Testbed> getTestbeds() {
        return this.testbeds;
    }

    @JsonProperty
    public List<URI> getUrls() {
        return this.urls;
    }

    @JsonIgnore
    public String getUrlsAsCsv() {
        if (this.urls == null) {
            return null;
        }
        return this.urls.stream().map(URI::toASCIIString).collect(Collectors.joining(","));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Federation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Federation that = (Federation)o;
        return Objects.equals(this.longName, that.longName) && Objects.equals(this.urls, that.urls) && Objects.equals(this.description, that.description) && Objects.equals(this.notes, that.notes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.longName, this.urls, this.description, this.notes);
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(FederationBuilder.minimize(JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, this));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Federation " + (String)this.getId() + " to JSON", e);
            return "Exception converting Federation " + (String)this.getId() + " to JSON: " + e.getMessage();
        }
    }

    public int compareTo(@Nonnull Object o) {
        assert (o instanceof Federation);
        return ID_COMP.compare((String)this.getId(), (String)((Federation)o).getId());
    }
}

