/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GDPRInfo {
    private static final Logger LOG = LoggerFactory.getLogger(GDPRInfo.class);
    @Nullable
    private final String grpdUrl;
    @Nullable
    private final Integer acceptPeriodInDays;
    @Nullable
    private final AcceptSubject acceptSubject;
    @Nullable
    private final String version;

    @JsonCreator
    public GDPRInfo(@Nullable @JsonProperty(value="grpdUrl") String grpdUrl, @Nullable @JsonProperty(value="acceptPeriodInDays") Integer acceptPeriodInDays, @Nullable @JsonProperty(value="acceptSubject") AcceptSubject acceptSubject, @Nullable @JsonProperty(value="version") String version) {
        this.grpdUrl = grpdUrl;
        this.acceptPeriodInDays = acceptPeriodInDays;
        this.acceptSubject = acceptSubject;
        this.version = version;
    }

    @Nullable
    @JsonProperty
    public String getGrpdUrl() {
        return this.grpdUrl;
    }

    @Nullable
    @JsonProperty
    public Integer getAcceptPeriodInDays() {
        return this.acceptPeriodInDays;
    }

    @Nullable
    @JsonProperty
    public AcceptSubject getAcceptSubject() {
        return this.acceptSubject;
    }

    @Nullable
    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="@type")
    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    @JsonProperty(value="@type")
    private void setClassName(String className) {
        if (!this.getClass().getSimpleName().equals(className)) {
            throw new IllegalArgumentException("@type must be " + this.getClass().getSimpleName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GDPRInfo gdprInfo = (GDPRInfo)o;
        return Objects.equals(this.grpdUrl, gdprInfo.grpdUrl) && Objects.equals(this.acceptPeriodInDays, gdprInfo.acceptPeriodInDays) && this.acceptSubject == gdprInfo.acceptSubject && Objects.equals(this.version, gdprInfo.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.grpdUrl, this.acceptPeriodInDays, this.acceptSubject, this.version});
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " to JSON", e);
            return "Exception converting " + this.getClass().getSimpleName() + " to JSON: " + e.getMessage();
        }
    }

    public static enum AcceptSubject {
        USER,
        PROJECT,
        SLICE;

    }
}

