/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Graph.class)
public class GraphBuilder
extends PrimaryIdObjectBuilder<String, Graph, GraphBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBuilder.class);
    private String graphDefinitionId;
    private String subType;
    private String periodString;
    private String description;
    private Long periodInSeconds;
    private TestInstance testInstance;
    private TestDefinition testDefinition;
    private Timestamp graphStartTime;
    private Timestamp graphEndTime;
    private Timestamp expire;
    private URI imageUri;

    public GraphBuilder() {
    }

    public GraphBuilder(Graph orig) {
        super(orig);
        this.graphDefinitionId = orig.getGraphDefinitionId();
        this.subType = orig.getSubType();
        this.periodString = orig.getPeriodString();
        this.description = orig.getDescription();
        this.periodInSeconds = orig.getPeriodInSeconds();
        this.testInstance = orig.getTestInstance();
        this.testDefinition = orig.getTestDefinition();
        this.graphStartTime = orig.getGraphStartTime();
        this.graphEndTime = orig.getGraphEndTime();
        this.expire = orig.getExpire();
        this.imageUri = orig.getImageUri();
    }

    @Override
    public GraphBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public GraphBuilder setGraphDefinitionId(String graphDefinitionId) {
        this.graphDefinitionId = graphDefinitionId;
        return this;
    }

    public GraphBuilder setSubType(String subType) {
        this.subType = subType;
        return this;
    }

    public GraphBuilder setPeriodString(String periodString) {
        this.periodString = periodString;
        return this;
    }

    public GraphBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public GraphBuilder setPeriodInSeconds(Long periodInSeconds) {
        this.periodInSeconds = periodInSeconds;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=TestInstance.class)
    public GraphBuilder setTestInstance(TestInstance testInstance) {
        this.testInstance = testInstance;
        return this;
    }

    public GraphBuilder setTestInstanceId(Integer testInstanceId) {
        this.testInstance = testInstanceId == null ? null : ((TestInstanceBuilder)new TestInstanceBuilder().setId(testInstanceId)).create();
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=TestDefinition.class)
    public GraphBuilder setTestDefinition(TestDefinition testDefinition) {
        this.testDefinition = testDefinition;
        return this;
    }

    public GraphBuilder setTestDefinitionId(String testDefinitionId) {
        this.testDefinition = testDefinitionId == null ? null : ((TestDefinitionBuilder)new TestDefinitionBuilder().setId(testDefinitionId)).create();
        return this;
    }

    public GraphBuilder setGraphStartTime(Date graphStartTime) {
        this.graphStartTime = graphStartTime == null ? null : new Timestamp(graphStartTime.getTime());
        return this;
    }

    public GraphBuilder setGraphEndTime(Date graphEndTime) {
        this.graphEndTime = graphEndTime == null ? null : new Timestamp(graphEndTime.getTime());
        return this;
    }

    public GraphBuilder setExpire(Date expire) {
        this.expire = expire == null ? null : new Timestamp(expire.getTime());
        return this;
    }

    public GraphBuilder setGraphStartTime(Timestamp graphStartTime) {
        this.graphStartTime = graphStartTime;
        return this;
    }

    public GraphBuilder setGraphEndTime(Timestamp graphEndTime) {
        this.graphEndTime = graphEndTime;
        return this;
    }

    public GraphBuilder setExpire(Timestamp expire) {
        this.expire = expire;
        return this;
    }

    public GraphBuilder setImageUri(URI imageUri) {
        this.imageUri = imageUri;
        return this;
    }

    @Override
    public GraphBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Graph create() {
        return new Graph((String)this.id, this.graphDefinitionId, this.subType, this.periodString, this.description, this.periodInSeconds, this.testInstance, this.testDefinition, this.graphStartTime, this.graphEndTime, this.expire, this.imageUri, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    @Override
    public Graph createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new Graph(minimization.includeId() ? (String)this.id : null, minimization.includeOtherProperties() ? this.graphDefinitionId : null, minimization.includeOtherProperties() ? this.subType : null, minimization.includeOtherProperties() ? this.periodString : null, minimization.includeOtherProperties() ? this.description : null, minimization.includeOtherProperties() ? this.periodInSeconds : null, minimization.includeOtherProperties() || minimization.includeParent() ? (this.testInstance == null ? null : new TestInstanceBuilder(this.testInstance).createMinimized(minimization.includeParent() ? minimization.getParentMinimization() : JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)) : null, minimization.includeOtherProperties() || minimization.includeParent() ? (this.testDefinition == null ? null : new TestDefinitionBuilder(this.testDefinition).createMinimized(minimization.includeParent() ? minimization.getParentMinimization() : JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)) : null, minimization.includeOtherProperties() ? this.graphStartTime : null, minimization.includeOtherProperties() ? this.graphEndTime : null, minimization.includeOtherProperties() ? this.expire : null, minimization.includeOtherProperties() ? this.imageUri : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<Graph> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<Graph> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Graph> res = new ArrayList<Graph>();
        for (Graph g2 : in) {
            res.add(new GraphBuilder(g2).createMinimized(minimization));
        }
        return res;
    }

    public static Graph minimize(JsonLdObjectsMetaData.Minimization minimization, Graph in) {
        if (in == null) {
            return null;
        }
        return new GraphBuilder(in).createMinimized(minimization);
    }

    public String getGraphDefinitionId() {
        return this.graphDefinitionId;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getPeriodString() {
        return this.periodString;
    }

    public String getDescription() {
        return this.description;
    }

    public long getPeriodInSeconds() {
        return this.periodInSeconds;
    }

    public Date getGraphStartTime() {
        return this.graphStartTime;
    }

    public Date getGraphEndTime() {
        return this.graphEndTime;
    }

    public Date getExpire() {
        return this.expire;
    }

    public URI getImageUri() {
        return this.imageUri;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=TestInstance.class)
    public TestInstance getTestInstance() {
        return this.testInstance;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=TestDefinition.class)
    public TestDefinition getTestDefinition() {
        return this.testDefinition;
    }
}

