/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GtsConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="guiconfig", builderClass=JFedExperimenterGuiConfigBuilder.class, uriType=JsonLdObjectsMetaData.UriType.NONE, idType=JsonLdObjectsMetaData.IdType.NONE)
public class JFedExperimenterGuiConfig
extends BasicLdObject {
    private static final Logger LOG = LoggerFactory.getLogger(JFedExperimenterGuiConfig.class);
    private final UserInfo user;
    private final Map<String, Object> flags;
    private final GtsConfig gtsConfig;
    private final List<ResourceClass> resourceClasses;
    private final List<Server> bindableServers;
    private final List<Server> hideServers;
    private final List<TriggeredMessage> triggeredMessages;
    private final List<LoginSite> loginSites;

    @JsonCreator
    JFedExperimenterGuiConfig(@JsonProperty(value="user") UserInfo user, @JsonProperty(value="flags") Map<String, Object> flags, @JsonProperty(value="gtsConfig") GtsConfig gtsConfig, @JsonProperty(value="resourceClasses") Collection<ResourceClass> resourceClasses, @JsonProperty(value="bindableServers") Collection<Server> bindableServers, @JsonProperty(value="hideServers") Collection<Server> hideServers, @JsonProperty(value="triggeredMessages") List<TriggeredMessage> triggeredMessages, @JsonProperty(value="loginSites") List<LoginSite> loginSites) {
        this.user = user;
        this.flags = flags;
        this.gtsConfig = gtsConfig;
        this.resourceClasses = resourceClasses == null ? null : Collections.unmodifiableList(new ArrayList<ResourceClass>(resourceClasses));
        this.bindableServers = bindableServers == null ? null : Collections.unmodifiableList(new ArrayList<Server>(bindableServers));
        this.hideServers = hideServers == null ? null : Collections.unmodifiableList(new ArrayList<Server>(hideServers));
        this.triggeredMessages = triggeredMessages == null ? null : Collections.unmodifiableList(new ArrayList<TriggeredMessage>(triggeredMessages));
        this.loginSites = loginSites == null ? null : Collections.unmodifiableList(new ArrayList<LoginSite>(loginSites));
    }

    @JsonProperty
    public UserInfo getUser() {
        return this.user;
    }

    @JsonProperty
    public Map<String, Object> getFlags() {
        return this.flags;
    }

    @JsonProperty
    public GtsConfig getGtsConfig() {
        return this.gtsConfig;
    }

    @JsonProperty
    public List<ResourceClass> getResourceClasses() {
        return this.resourceClasses;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Server> getBindableServers() {
        return this.bindableServers;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Server> getHideServers() {
        return this.hideServers;
    }

    @JsonProperty
    public List<TriggeredMessage> getTriggeredMessages() {
        return this.triggeredMessages;
    }

    @JsonProperty
    public List<LoginSite> getLoginSites() {
        return this.loginSites;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting JFedExperimenterGuiConfig to JSON", e);
            return "Exception converting JFedExperimenterGuiConfig to JSON: " + e.getMessage();
        }
    }
}

