/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
public class Location {
    private static final Logger LOG = LoggerFactory.getLogger(Location.class);
    private final String countryCode;
    private final Double longitude;
    private final Double latitude;
    private final String address;

    @JsonCreator
    public Location(@JsonProperty(value="countryCode") String countryCode, @JsonProperty(value="longitude") Double longitude, @JsonProperty(value="latitude") Double latitude, @JsonProperty(value="address") String address) {
        this.countryCode = countryCode;
        this.longitude = longitude;
        this.latitude = latitude;
        this.address = address;
    }

    @JsonProperty
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty
    public Double getLongitude() {
        return this.longitude;
    }

    @JsonProperty
    public Double getLatitude() {
        return this.latitude;
    }

    @JsonProperty
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="@type")
    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    @JsonProperty(value="@type")
    private void setClassName(String className) {
        if (!this.getClass().getSimpleName().equals(className)) {
            throw new IllegalArgumentException("@type must be " + this.getClass().getSimpleName());
        }
    }

    @JsonIgnore
    public String encodeAsString() {
        String one = this.countryCode == null ? "" : this.countryCode;
        String two = this.longitude == null ? "" : "" + this.longitude;
        String three = this.latitude == null ? "" : "" + this.latitude;
        String four = this.address == null ? "" : this.address;
        return one + ";" + two + ";" + three + ";" + four;
    }

    public static Location decodeFromString(String s2) {
        if (s2 == null) {
            return null;
        }
        String[] parts = s2.split(";", 4);
        if (parts.length != 4) {
            try {
                throw new Exception("Invalid location: \"" + s2 + "\"");
            }
            catch (Exception e) {
                LOG.warn("Invalid location: \"" + s2 + "\"", e);
                return null;
            }
        }
        String one = parts[0].isEmpty() ? null : parts[0];
        String two = parts[1].isEmpty() ? null : parts[1];
        String three = parts[2].isEmpty() ? null : parts[2];
        String four = parts[3].isEmpty() ? null : parts[3];
        Double a = two == null ? null : Double.valueOf(Double.parseDouble(two));
        Double b = three == null ? null : Double.valueOf(Double.parseDouble(three));
        return new Location(one, a, b, four);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (this.address != null ? !this.address.equals(location.address) : location.address != null) {
            return false;
        }
        if (this.countryCode != null ? !this.countryCode.equals(location.countryCode) : location.countryCode != null) {
            return false;
        }
        if (this.latitude != null ? !this.latitude.equals(location.latitude) : location.latitude != null) {
            return false;
        }
        return !(this.longitude != null ? !this.longitude.equals(location.longitude) : location.longitude != null);
    }

    public int hashCode() {
        int result = this.countryCode != null ? this.countryCode.hashCode() : 0;
        result = 31 * result + (this.longitude != null ? this.longitude.hashCode() : 0);
        result = 31 * result + (this.latitude != null ? this.latitude.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Location to JSON", e);
            return "Exception converting Location to JSON: " + e.getMessage();
        }
    }
}

