/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="organisation", builderClass=OrganisationBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Organisation
extends PrimaryIdObject<String>
implements Comparable<Organisation> {
    private static final Logger LOG = LoggerFactory.getLogger(Organisation.class);
    private final String name;
    private final String logoUrl;
    private final String siteUrl;
    private final Location location;
    private final List<Testbed> testbeds;
    private final List<String> technicalContactEmails;
    private static final Comparator<String> ID_COMP = Comparator.naturalOrder();

    @JsonCreator
    Organisation(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="logoUrl") String logoUrl, @JsonProperty(value="siteUrl") String siteUrl, @JsonProperty(value="location") Location location, @JsonProperty(value="testbeds") List<Testbed> testbeds, @JsonProperty(value="technicalContactEmails") List<String> technicalContactEmails, @JsonProperty(value="@id") URI uri) {
        this(id, name, logoUrl, siteUrl, location, testbeds, technicalContactEmails, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Organisation(String id, String name, String logoUrl, String siteUrl, Location location, List<Testbed> testbeds, List<String> technicalContactEmails, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.logoUrl = logoUrl;
        this.siteUrl = siteUrl;
        this.location = location;
        this.testbeds = testbeds == null ? null : Collections.unmodifiableList(new ArrayList<Testbed>(testbeds));
        this.technicalContactEmails = technicalContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(technicalContactEmails));
    }

    Organisation(List<TestbedBuilder> testbedBuilders, String id, String name, String logoUrl, String siteUrl, Location location, List<String> technicalContactEmails, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.logoUrl = logoUrl;
        this.siteUrl = siteUrl;
        this.location = location;
        ArrayList<Testbed> newTestbeds = new ArrayList<Testbed>();
        for (TestbedBuilder tb : testbedBuilders) {
            tb.setOrganisation(this);
            newTestbeds.add(tb.create());
        }
        this.testbeds = Collections.unmodifiableList(newTestbeds);
        this.technicalContactEmails = technicalContactEmails == null ? null : Collections.unmodifiableList(new ArrayList<String>(technicalContactEmails));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty
    public String getSiteUrl() {
        return this.siteUrl;
    }

    @JsonProperty
    public Location getLocation() {
        return this.location;
    }

    @JsonIgnore
    public String getLocationEncodedAsString() {
        return this.location == null ? null : this.location.encodeAsString();
    }

    @JsonProperty
    public List<String> getTechnicalContactEmails() {
        return this.technicalContactEmails;
    }

    @JsonIgnore
    public String getTechnicalContactEmailsAsCsv() {
        return this.technicalContactEmails == null ? null : String.join((CharSequence)",", this.technicalContactEmails);
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestbedListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildrenLinkListSerializer.class)
    public List<Testbed> getTestbeds() {
        return this.testbeds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organisation that = (Organisation)o;
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.id != null ? !((String)this.id).equals(that.id) : that.id != null) {
            return false;
        }
        if (this.logoUrl != null ? !this.logoUrl.equals(that.logoUrl) : that.logoUrl != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.siteUrl != null ? !this.siteUrl.equals(that.siteUrl) : that.siteUrl != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(that.uri) : that.uri != null);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? ((String)this.id).hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.logoUrl != null ? this.logoUrl.hashCode() : 0);
        result = 31 * result + (this.siteUrl != null ? this.siteUrl.hashCode() : 0);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(OrganisationBuilder.minimize(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, this));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " " + (String)this.id + " to JSON", e);
            return "Exception converting " + this.getClass().getSimpleName() + " " + (String)this.id + " to JSON: " + e.getMessage();
        }
    }

    @Override
    public int compareTo(Organisation o) {
        return ID_COMP.compare((String)this.getId(), (String)o.getId());
    }
}

