/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Resource.class)
public class ResourceBuilder
extends PrimaryIdObjectBuilder<Integer, Resource, ResourceBuilder> {
    private Server server;
    private ServerBuilder serverBuilder;
    private ResourceClass resourceClass;
    private ResourceClassBuilder resourceClassBuilder;
    private String rspecElementName;
    private Boolean layer3;
    private Boolean requireFixedNodeAssignment;
    private Boolean requireDiskImage;
    private Boolean requireHardwareType;
    private Boolean allowFixedNodeAssignment;
    private Boolean allowDiskImage;
    private Boolean allowHardwareType;
    private Boolean defaultExclusive;
    private Boolean allowModifyExclusive;
    private String sliverType;
    private String hardwareType;
    private String diskImage;
    private String componentUrn;
    private List<String> allowedSliverTypes;
    @Deprecated
    private Boolean allowLinks;
    @Deprecated
    private Boolean allowStitchedLinks;
    @Deprecated
    private List<String> allowedLinkTypes;
    @Deprecated
    private String defaultLinkType;
    private Boolean autoFilterFixedNodesByHardwareType;
    private Boolean autoFilterFixedNodesBySliverType;
    private List<String> filterFixedNodesByHardwareType;
    private List<String> filterFixedNodesBySliverType;
    private List<Resource.LinkInfo> linkInfo;
    private String overwriteServerName;
    private Boolean allowSiteSelection;

    public ResourceBuilder() {
    }

    public ResourceBuilder(@Nonnull Resource orig) {
        super(orig);
        this.server = orig.getServer();
        this.resourceClass = orig.getResourceClass();
        this.rspecElementName = orig.getRspecElementName();
        this.layer3 = orig.getLayer3();
        this.requireFixedNodeAssignment = orig.getRequireFixedNodeAssignment();
        this.requireDiskImage = orig.getRequireDiskImage();
        this.requireHardwareType = orig.getRequireHardwareType();
        this.allowFixedNodeAssignment = orig.getAllowFixedNodeAssignment();
        this.allowDiskImage = orig.getAllowDiskImage();
        this.allowHardwareType = orig.getAllowHardwareType();
        this.defaultExclusive = orig.getDefaultExclusive();
        this.allowModifyExclusive = orig.getAllowModifyExclusive();
        this.sliverType = orig.getSliverType();
        this.hardwareType = orig.getHardwareType();
        this.diskImage = orig.getDiskImage();
        this.componentUrn = orig.getComponentUrn();
        this.allowedSliverTypes = ResourceBuilder.listCopyHelper(orig.getAllowedSliverTypes());
        this.allowLinks = orig.getAllowLinks();
        this.allowStitchedLinks = orig.getAllowStitchedLinks();
        this.allowedLinkTypes = orig.getAllowedLinkTypes();
        this.defaultLinkType = orig.getDefaultLinkType();
        this.autoFilterFixedNodesByHardwareType = orig.getAutoFilterFixedNodesByHardwareType();
        this.autoFilterFixedNodesBySliverType = orig.getAutoFilterFixedNodesBySliverType();
        this.filterFixedNodesByHardwareType = ResourceBuilder.listCopyHelper(orig.getFilterFixedNodesByHardwareType());
        this.filterFixedNodesBySliverType = ResourceBuilder.listCopyHelper(orig.getFilterFixedNodesBySliverType());
        this.linkInfo = ResourceBuilder.listCopyHelper(orig.getLinkInfo());
        this.overwriteServerName = orig.getOverwriteServerName();
        this.allowSiteSelection = orig.getAllowSiteSelection();
    }

    @Nullable
    private static <T> List<T> listCopyHelper(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<T>(list);
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class)
    public ResourceBuilder setServer(Server server) {
        this.server = server;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, builderReference=true)
    public ResourceBuilder setServerBuilder(ServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=ResourceClass.class)
    public ResourceBuilder setResourceClass(ResourceClass resourceClass) {
        this.resourceClass = resourceClass;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=ResourceClass.class, builderReference=true)
    public ResourceBuilder setResourceClassBuilder(ResourceClassBuilder resourceClassBuilder) {
        this.resourceClassBuilder = resourceClassBuilder;
        return this;
    }

    public ResourceBuilder setRspecElementName(String rspecElementName) {
        this.rspecElementName = rspecElementName;
        return this;
    }

    public ResourceBuilder setLayer3(Boolean layer3) {
        this.layer3 = layer3;
        return this;
    }

    public ResourceBuilder setRequireFixedNodeAssignment(Boolean requireFixedNodeAssignment) {
        this.requireFixedNodeAssignment = requireFixedNodeAssignment;
        return this;
    }

    public ResourceBuilder setRequireDiskImage(Boolean requireDiskImage) {
        this.requireDiskImage = requireDiskImage;
        return this;
    }

    public ResourceBuilder setRequireHardwareType(Boolean requireHardwareType) {
        this.requireHardwareType = requireHardwareType;
        return this;
    }

    public ResourceBuilder setAllowFixedNodeAssignment(Boolean allowFixedNodeAssignment) {
        this.allowFixedNodeAssignment = allowFixedNodeAssignment;
        return this;
    }

    public ResourceBuilder setAllowDiskImage(Boolean allowDiskImage) {
        this.allowDiskImage = allowDiskImage;
        return this;
    }

    public ResourceBuilder setAllowHardwareType(Boolean allowHardwareType) {
        this.allowHardwareType = allowHardwareType;
        return this;
    }

    public ResourceBuilder setDefaultExclusive(Boolean defaultExclusive) {
        this.defaultExclusive = defaultExclusive;
        return this;
    }

    public ResourceBuilder setAllowModifyExclusive(Boolean allowModifyExclusive) {
        this.allowModifyExclusive = allowModifyExclusive;
        return this;
    }

    public ResourceBuilder setSliverType(String sliverType) {
        this.sliverType = sliverType;
        return this;
    }

    public ResourceBuilder setHardwareType(String hardwareType) {
        this.hardwareType = hardwareType;
        return this;
    }

    public ResourceBuilder setDiskImage(String diskImage) {
        this.diskImage = diskImage;
        return this;
    }

    public ResourceBuilder setComponentUrn(String componentUrn) {
        this.componentUrn = componentUrn;
        return this;
    }

    public ResourceBuilder setAllowedSliverTypes(List<String> allowedSliverTypes) {
        this.allowedSliverTypes = new ArrayList<String>(allowedSliverTypes);
        return this;
    }

    public ResourceBuilder addAllowedSliverType(String allowedSliverType) {
        if (this.allowedSliverTypes == null) {
            this.allowedSliverTypes = new ArrayList<String>();
        }
        this.allowedSliverTypes.add(allowedSliverType);
        return this;
    }

    @Deprecated
    public ResourceBuilder setAllowLinks(Boolean allowLinks) {
        this.allowLinks = allowLinks;
        return this;
    }

    @Deprecated
    public ResourceBuilder setAllowStitchedLinks(Boolean allowStitchedLinks) {
        this.allowStitchedLinks = allowStitchedLinks;
        return this;
    }

    @Deprecated
    public ResourceBuilder setAllowedLinkTypes(@Nullable List<String> allowedLinkTypes) {
        this.allowedLinkTypes = ResourceBuilder.listCopyHelper(allowedLinkTypes);
        return this;
    }

    @Deprecated
    public ResourceBuilder addAllowedLinkType(@Nonnull String allowedLinkType) {
        if (this.allowedLinkTypes == null) {
            this.allowedLinkTypes = new ArrayList<String>();
        }
        this.allowedLinkTypes.add(allowedLinkType);
        return this;
    }

    @Deprecated
    public ResourceBuilder setDefaultLinkType(String defaultLinkType) {
        this.defaultLinkType = defaultLinkType;
        return this;
    }

    public ResourceBuilder setAutoFilterFixedNodesByHardwareType(Boolean autoFilterFixedNodesByHardwareType) {
        this.autoFilterFixedNodesByHardwareType = autoFilterFixedNodesByHardwareType;
        return this;
    }

    public ResourceBuilder setAutoFilterFixedNodesBySliverType(Boolean autoFilterFixedNodesBySliverType) {
        this.autoFilterFixedNodesBySliverType = autoFilterFixedNodesBySliverType;
        return this;
    }

    public ResourceBuilder setFilterFixedNodesByHardwareType(@Nullable List<String> filterFixedNodesByHardwareType) {
        this.filterFixedNodesByHardwareType = ResourceBuilder.listCopyHelper(filterFixedNodesByHardwareType);
        return this;
    }

    public ResourceBuilder addFilterFixedNodesByHardwareType(@Nonnull String hardwareType) {
        if (this.filterFixedNodesByHardwareType == null) {
            this.filterFixedNodesByHardwareType = new ArrayList<String>();
        }
        this.filterFixedNodesByHardwareType.add(hardwareType);
        return this;
    }

    public ResourceBuilder setFilterFixedNodesBySliverType(@Nullable List<String> filterFixedNodesBySliverType) {
        this.filterFixedNodesBySliverType = ResourceBuilder.listCopyHelper(filterFixedNodesBySliverType);
        return this;
    }

    public ResourceBuilder addFilterFixedNodesBySliverType(@Nonnull String sliverType) {
        if (this.filterFixedNodesBySliverType == null) {
            this.filterFixedNodesBySliverType = new ArrayList<String>();
        }
        this.filterFixedNodesBySliverType.add(sliverType);
        return this;
    }

    public ResourceBuilder setLinkInfo(@Nullable List<Resource.LinkInfo> linkInfo) {
        this.linkInfo = ResourceBuilder.listCopyHelper(linkInfo);
        return this;
    }

    public ResourceBuilder addLinkInfo(@Nonnull Resource.LinkInfo linkInfo) {
        if (this.linkInfo == null) {
            this.linkInfo = new ArrayList<Resource.LinkInfo>();
        }
        this.linkInfo.add(linkInfo);
        return this;
    }

    public ResourceBuilder setOverwriteServerName(@Nullable String overwriteServerName) {
        this.overwriteServerName = overwriteServerName;
        return this;
    }

    public ResourceBuilder setAllowSiteSelection(Boolean allowSiteSelection) {
        this.allowSiteSelection = allowSiteSelection;
        return this;
    }

    @Override
    public Resource create() {
        if (this.resourceClassBuilder != null && this.resourceClass != null) {
            throw new IllegalStateException("Either none, only resourceClass or only resourceClassBuilder must be set, not both.");
        }
        ResourceClass usedResourceClass = null;
        if (this.resourceClass != null) {
            usedResourceClass = this.resourceClass;
        }
        if (this.resourceClassBuilder != null) {
            usedResourceClass = this.resourceClassBuilder.create();
        }
        if (this.serverBuilder != null && this.server != null) {
            throw new IllegalStateException("Either none, only server or only serverBuilder must be set, not both.");
        }
        Server usedServer = null;
        if (this.server != null) {
            usedServer = this.server;
        }
        if (this.serverBuilder != null) {
            usedServer = this.serverBuilder.create();
        }
        return new Resource((Integer)this.id, usedServer, usedResourceClass, this.rspecElementName, this.layer3, this.requireFixedNodeAssignment, this.requireDiskImage, this.requireHardwareType, this.allowFixedNodeAssignment, this.allowDiskImage, this.allowHardwareType, this.defaultExclusive, this.allowModifyExclusive, this.sliverType, this.hardwareType, this.diskImage, this.componentUrn, this.allowedSliverTypes, this.allowLinks, this.allowStitchedLinks, this.allowedLinkTypes, this.defaultLinkType, this.autoFilterFixedNodesByHardwareType, this.autoFilterFixedNodesBySliverType, this.filterFixedNodesByHardwareType, this.filterFixedNodesBySliverType, this.linkInfo, this.overwriteServerName, this.allowSiteSelection, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    @Override
    public Resource createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        if (this.resourceClassBuilder != null && this.resourceClass != null) {
            throw new IllegalStateException("Either none, only resourceClass or only resourceClassBuilder must be set, not both.");
        }
        ResourceClass usedResourceClass = null;
        if (this.resourceClass != null) {
            usedResourceClass = this.resourceClass;
        }
        if (this.resourceClassBuilder != null) {
            usedResourceClass = this.resourceClassBuilder.create();
        }
        if (this.serverBuilder != null && this.server != null) {
            throw new IllegalStateException("Either none, only server or only serverBuilder must be set, not both.");
        }
        Server usedServer = null;
        if (this.server != null) {
            usedServer = this.server;
        }
        if (this.serverBuilder != null) {
            usedServer = this.serverBuilder.create();
        }
        return new Resource(minimization.includeId() ? (Integer)this.id : null, usedServer == null || !minimization.includeOtherProperties() ? null : ServerBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, usedServer), usedResourceClass == null || !minimization.includeParent() ? null : ResourceClassBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, usedResourceClass), minimization.includeOtherProperties() ? this.rspecElementName : null, minimization.includeOtherProperties() ? this.layer3 : null, minimization.includeOtherProperties() ? this.requireFixedNodeAssignment : null, minimization.includeOtherProperties() ? this.requireDiskImage : null, minimization.includeOtherProperties() ? this.requireHardwareType : null, minimization.includeOtherProperties() ? this.allowFixedNodeAssignment : null, minimization.includeOtherProperties() ? this.allowDiskImage : null, minimization.includeOtherProperties() ? this.allowHardwareType : null, minimization.includeOtherProperties() ? this.defaultExclusive : null, minimization.includeOtherProperties() ? this.allowModifyExclusive : null, minimization.includeOtherProperties() ? this.sliverType : null, minimization.includeOtherProperties() ? this.hardwareType : null, minimization.includeOtherProperties() ? this.diskImage : null, minimization.includeOtherProperties() ? this.componentUrn : null, minimization.includeOtherProperties() ? this.allowedSliverTypes : null, minimization.includeOtherProperties() ? this.allowLinks : null, minimization.includeOtherProperties() ? this.allowStitchedLinks : null, minimization.includeOtherProperties() ? this.allowedLinkTypes : null, minimization.includeOtherProperties() ? this.defaultLinkType : null, minimization.includeOtherProperties() ? this.autoFilterFixedNodesByHardwareType : null, minimization.includeOtherProperties() ? this.autoFilterFixedNodesBySliverType : null, minimization.includeOtherProperties() ? this.filterFixedNodesByHardwareType : null, minimization.includeOtherProperties() ? this.filterFixedNodesBySliverType : null, minimization.includeOtherProperties() ? this.linkInfo : null, minimization.includeOtherProperties() ? this.overwriteServerName : null, minimization.includeOtherProperties() ? this.allowSiteSelection : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<Resource> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<Resource> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (Resource r : in) {
            res.add(new ResourceBuilder(r).createMinimized(minimization));
        }
        return res;
    }

    public static Resource minimize(JsonLdObjectsMetaData.Minimization minimization, Resource in) {
        if (in == null) {
            return null;
        }
        return new ResourceBuilder(in).createMinimized(minimization);
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class)
    public Server getServer() {
        return this.server;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=ResourceClass.class)
    public ResourceClass getResourceClass() {
        return this.resourceClass;
    }

    public String getRspecElementName() {
        return this.rspecElementName;
    }

    public Boolean getLayer3() {
        return this.layer3;
    }

    public Boolean getRequireFixedNodeAssignment() {
        return this.requireFixedNodeAssignment;
    }

    public Boolean getRequireDiskImage() {
        return this.requireDiskImage;
    }

    public Boolean getRequireHardwareType() {
        return this.requireHardwareType;
    }

    public Boolean getAllowFixedNodeAssignment() {
        return this.allowFixedNodeAssignment;
    }

    public Boolean getAllowDiskImage() {
        return this.allowDiskImage;
    }

    public Boolean getAllowHardwareType() {
        return this.allowHardwareType;
    }

    public Boolean getDefaultExclusive() {
        return this.defaultExclusive;
    }

    public Boolean getAllowModifyExclusive() {
        return this.allowModifyExclusive;
    }

    public String getSliverType() {
        return this.sliverType;
    }

    public String getHardwareType() {
        return this.hardwareType;
    }

    public String getDiskImage() {
        return this.diskImage;
    }

    public String getComponentUrn() {
        return this.componentUrn;
    }

    public List<String> getAllowedSliverTypes() {
        return this.allowedSliverTypes;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, builderReference=true)
    public ServerBuilder getServerBuilder() {
        return this.serverBuilder;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=ResourceClass.class, builderReference=true)
    public ResourceClassBuilder getResourceClassBuilder() {
        return this.resourceClassBuilder;
    }

    @Deprecated
    public Boolean getAllowLinks() {
        return this.allowLinks;
    }

    @Deprecated
    public Boolean getAllowStitchedLinks() {
        return this.allowStitchedLinks;
    }

    @Deprecated
    public List<String> getAllowedLinkTypes() {
        return this.allowedLinkTypes;
    }

    @Deprecated
    public String getDefaultLinkType() {
        return this.defaultLinkType;
    }

    public Boolean getAutoFilterFixedNodesByHardwareType() {
        return this.autoFilterFixedNodesByHardwareType;
    }

    public Boolean getAutoFilterFixedNodesBySliverType() {
        return this.autoFilterFixedNodesBySliverType;
    }

    public List<String> getFilterFixedNodesByHardwareType() {
        return this.filterFixedNodesByHardwareType;
    }

    public List<String> getFilterFixedNodesBySliverType() {
        return this.filterFixedNodesBySliverType;
    }

    public List<Resource.LinkInfo> getLinkInfo() {
        return this.linkInfo;
    }

    @Nullable
    public String getOverwriteServerName() {
        return this.overwriteServerName;
    }

    public Boolean getAllowSiteSelection() {
        return this.allowSiteSelection;
    }
}

