/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="server", builderClass=ServerBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Server
extends PrimaryIdObject<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private final String name;
    private final String certificateChain;
    private final String allowedCertificateAlias;
    private final String serverType;
    private final String urnTld;
    private final String baseUrl;
    private final Location location;
    private final List<Service> scs;
    private final Service defaultScs;
    private final List<Service> userAuth;
    private final Service defaultUserAuth;
    private final TreeSet<String> flags;
    private final Testbed testbed;
    private final List<Service> services;
    private final Service defaultAMService;
    private final String defaultComponentManagerUrn;

    @JsonCreator
    Server(@JsonProperty(value="id") Integer id, @JsonProperty(value="name") String name, @JsonProperty(value="certificateChain") String certificateChain, @JsonProperty(value="allowedCertificateAlias") String allowedCertificateAlias, @JsonProperty(value="serverType") String serverType, @JsonProperty(value="urnTld") String urnTld, @JsonProperty(value="baseUrl") String baseUrl, @JsonProperty(value="location") Location location, @JsonProperty(value="scs") List<Service> scs, @JsonProperty(value="defaultScs") Service defaultScs, @JsonProperty(value="userAuth") List<Service> userAuth, @JsonProperty(value="defaultUserAuth") Service defaultUserAuth, @JsonProperty(value="flags") Collection<String> flags, @JsonProperty(value="testbed") Testbed testbed, @JsonProperty(value="services") List<Service> services, @JsonProperty(value="defaultAMService") Service defaultAMService, @JsonProperty(value="defaultComponentManagerUrn") String defaultComponentManagerUrn, @JsonProperty(value="@id") URI uri) {
        this(id, name, certificateChain, allowedCertificateAlias, serverType, urnTld, baseUrl, location, scs, defaultScs, userAuth, defaultUserAuth, flags, testbed, services, defaultAMService, defaultComponentManagerUrn, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Server(Integer id, String name, String certificateChain, String allowedCertificateAlias, String serverType, String urnTld, String baseUrl, Location location, List<Service> scs, Service defaultScs, List<Service> userAuth, Service defaultUserAuth, Collection<String> flags, Testbed testbed, List<Service> services, Service defaultAMService, String defaultComponentManagerUrn, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.certificateChain = certificateChain;
        this.allowedCertificateAlias = allowedCertificateAlias;
        this.serverType = serverType;
        this.urnTld = urnTld;
        this.baseUrl = baseUrl;
        this.location = location;
        this.scs = scs;
        this.defaultScs = defaultScs;
        this.userAuth = userAuth;
        this.defaultUserAuth = defaultUserAuth;
        this.flags = flags == null ? null : new TreeSet<String>(flags);
        this.testbed = testbed;
        this.services = services;
        this.defaultAMService = defaultAMService;
        this.defaultComponentManagerUrn = defaultComponentManagerUrn;
    }

    Server(JsonLdObjectsMetaData.Minimization childrenMinimization, Integer id, String name, String certificateChain, String allowedCertificateAlias, String serverType, String urnTld, String baseUrl, Location location, List<Service> scs, Service defaultScs, List<Service> userAuth, Service defaultUserAuth, Collection<String> flags, Testbed testbed, List<ServiceBuilder> serviceBuilders, ServiceBuilder defaultAMServiceBuilder, String defaultComponentManagerUrn, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.certificateChain = certificateChain;
        this.allowedCertificateAlias = allowedCertificateAlias;
        this.serverType = serverType;
        this.urnTld = urnTld;
        this.baseUrl = baseUrl;
        this.location = location;
        this.scs = scs;
        this.defaultScs = defaultScs;
        this.userAuth = userAuth;
        this.defaultUserAuth = defaultUserAuth;
        this.flags = flags == null ? null : new TreeSet<String>(flags);
        this.testbed = testbed;
        Service newDefaultAMService = null;
        ArrayList<Service> newServices = new ArrayList<Service>();
        if (serviceBuilders != null) {
            for (ServiceBuilder sb : serviceBuilders) {
                Service service;
                sb.setServer(this);
                Service service2 = service = childrenMinimization == null ? sb.create() : sb.createMinimized(childrenMinimization);
                if (defaultAMServiceBuilder != null && defaultAMServiceBuilder.getId() != null && service.getId() != null && ((Integer)defaultAMServiceBuilder.getId()).equals(service.getId())) {
                    assert (newDefaultAMService == null) : "multiple services are defaultAMService";
                    newDefaultAMService = service;
                }
                newServices.add(service);
            }
        }
        if (defaultAMServiceBuilder != null && newDefaultAMService == null && (serviceBuilders == null || serviceBuilders.isEmpty())) {
            defaultAMServiceBuilder.setServer(this);
            newDefaultAMService = childrenMinimization == null ? defaultAMServiceBuilder.create() : defaultAMServiceBuilder.createMinimized(childrenMinimization);
        }
        this.services = Collections.unmodifiableList(newServices);
        if (newDefaultAMService == null && defaultAMServiceBuilder != null) {
            throw new IllegalArgumentException("Default server " + defaultAMServiceBuilder.getId() + " is not in list of servers.");
        }
        this.defaultAMService = newDefaultAMService;
        this.defaultComponentManagerUrn = defaultComponentManagerUrn;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getCertificateChain() {
        return this.certificateChain;
    }

    @JsonIgnore
    public boolean hasCertificateChain() {
        return this.certificateChain != null && !this.certificateChain.trim().isEmpty();
    }

    @JsonProperty
    public String getAllowedCertificateAlias() {
        return this.allowedCertificateAlias;
    }

    @JsonIgnore
    public boolean hasAllowedCertificateAlias() {
        return this.allowedCertificateAlias != null && !this.allowedCertificateAlias.trim().isEmpty();
    }

    @JsonProperty
    public String getServerType() {
        return this.serverType;
    }

    @JsonIgnore
    public boolean isEdgeVlan() {
        return this.serverType != null && this.serverType.equals("fake");
    }

    @JsonIgnore
    public boolean isServerType(String serverType) {
        return serverType != null && this.serverType != null && this.serverType.equalsIgnoreCase(serverType);
    }

    @JsonProperty
    public String getUrnTld() {
        return this.urnTld;
    }

    @JsonProperty
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @JsonProperty
    public Location getLocation() {
        return this.location;
    }

    @JsonIgnore
    public String getLocationEncodedAsString() {
        return this.location == null ? null : this.location.encodeAsString();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServiceListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Service> getScs() {
        return this.scs;
    }

    @JsonIgnore
    public String getScsIdsCsv() {
        return this.scs == null ? null : this.scs.stream().map(service -> "" + service.getId()).collect(Collectors.joining(","));
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServiceDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    public Service getDefaultScs() {
        return this.defaultScs;
    }

    @JsonIgnore
    public Integer getDefaultScsId() {
        return this.defaultScs == null ? null : (Integer)this.defaultScs.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServiceListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Service> getUserAuth() {
        return this.userAuth;
    }

    @JsonIgnore
    public String getUserAuthIdsCsv() {
        return this.userAuth == null ? null : this.userAuth.stream().map(service -> "" + service.getId()).collect(Collectors.joining(","));
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServiceDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    public Service getDefaultUserAuth() {
        return this.defaultUserAuth;
    }

    @JsonIgnore
    public Integer getDefaultUserAuthId() {
        return this.defaultUserAuth == null ? null : (Integer)this.defaultUserAuth.getId();
    }

    @JsonProperty
    public Set<String> getFlags() {
        return this.flags;
    }

    @JsonIgnore
    public String getFlagsAsString() {
        return this.flags == null ? null : String.join((CharSequence)",", this.flags);
    }

    public static String specialCaseIdToFlag(String specialCaseId) {
        Flag flag = Flag.findBySpecialCaseId(specialCaseId);
        if (flag == null) {
            return null;
        }
        return flag.getJsonText();
    }

    public static String flagToSpecialCaseId(String flagJsonText) {
        Flag flag = Flag.findByJsonText(flagJsonText);
        if (flag == null) {
            return null;
        }
        return flag.getSpecialCaseId();
    }

    @JsonIgnore
    public boolean hasFlag(String flag) {
        return this.flags == null ? false : this.flags.contains(flag);
    }

    @JsonIgnore
    public boolean hasFlag(Flag flag) {
        return this.flags == null ? false : this.flags.contains(flag.getJsonText());
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestbedDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    public Testbed getTestbed() {
        return this.testbed;
    }

    @JsonIgnore
    public String getTestbedId() {
        return this.testbed == null ? null : (String)this.testbed.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServiceListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildrenLinkListSerializer.class)
    public List<Service> getServices() {
        return this.services;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServiceDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    public Service getDefaultAMService() {
        return this.defaultAMService;
    }

    @JsonIgnore
    public Integer getDefaultAMServiceId() {
        return this.defaultAMService == null ? null : (Integer)this.defaultAMService.getId();
    }

    @JsonProperty
    public String getDefaultComponentManagerUrn() {
        return this.defaultComponentManagerUrn;
    }

    @JsonIgnore
    public GeniUrn getDefaultComponentManagerAsGeniUrn() {
        if (this.defaultComponentManagerUrn == null) {
            return null;
        }
        try {
            return new GeniUrn(this.defaultComponentManagerUrn);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new RuntimeException("Server has invalid defaultComponentManagerUrn\"" + this.defaultComponentManagerUrn + "\"");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        if (this.allowedCertificateAlias != null ? !this.allowedCertificateAlias.equals(server.allowedCertificateAlias) : server.allowedCertificateAlias != null) {
            return false;
        }
        if (this.baseUrl != null ? !this.baseUrl.equals(server.baseUrl) : server.baseUrl != null) {
            return false;
        }
        if (this.certificateChain != null ? !this.certificateChain.equals(server.certificateChain) : server.certificateChain != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(server.location) : server.location != null) {
            return false;
        }
        if (this.defaultScs != null ? !this.defaultScs.equals(server.defaultScs) : server.defaultScs != null) {
            return false;
        }
        if (this.defaultUserAuth != null ? !this.defaultUserAuth.equals(server.defaultUserAuth) : server.defaultUserAuth != null) {
            return false;
        }
        if (this.id != null ? !((Integer)this.id).equals(server.id) : server.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(server.name) : server.name != null) {
            return false;
        }
        if (this.scs != null ? !this.scs.equals(server.scs) : server.scs != null) {
            return false;
        }
        if (this.flags != null ? !this.flags.equals(server.flags) : server.flags != null) {
            return false;
        }
        if (this.serverType != null ? !this.serverType.equals(server.serverType) : server.serverType != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(server.uri) : server.uri != null) {
            return false;
        }
        if (this.urnTld != null ? !this.urnTld.equals(server.urnTld) : server.urnTld != null) {
            return false;
        }
        return !(this.userAuth != null ? !this.userAuth.equals(server.userAuth) : server.userAuth != null);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? ((Integer)this.id).hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.certificateChain != null ? this.certificateChain.hashCode() : 0);
        result = 31 * result + (this.allowedCertificateAlias != null ? this.allowedCertificateAlias.hashCode() : 0);
        result = 31 * result + (this.serverType != null ? this.serverType.hashCode() : 0);
        result = 31 * result + (this.urnTld != null ? this.urnTld.hashCode() : 0);
        result = 31 * result + (this.baseUrl != null ? this.baseUrl.hashCode() : 0);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.scs != null ? this.scs.hashCode() : 0);
        result = 31 * result + (this.flags != null ? this.flags.hashCode() : 0);
        result = 31 * result + (this.defaultScs != null ? this.defaultScs.hashCode() : 0);
        result = 31 * result + (this.userAuth != null ? this.userAuth.hashCode() : 0);
        result = 31 * result + (this.defaultUserAuth != null ? this.defaultUserAuth.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(ServerBuilder.minimize(JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, this));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON", e);
            return "Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON: " + e.getMessage();
        }
    }

    public String toStringWithoutMinimize() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON", e);
            return "Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON: " + e.getMessage();
        }
    }

    public static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag preferToplevelOverSubauthority = new Flag("preferToplevelOverSubauthority", "prefer_toplevel_over_subauthority");
        public static final /* enum */ Flag fedmonHasNodeAvailabilityDetails = new Flag("fedmonHasNodeAvailabilityDetails", "fedmon_has_node_availability_details");
        public static final /* enum */ Flag centralBrokerArchitectureBrokerauth = new Flag("centralBrokerArchitectureBrokerauth", "central_broker_architecture_brokerauth");
        public static final /* enum */ Flag centralBrokerArchitectureSubauth = new Flag("centralBrokerArchitectureSubauth", "central_broker_architecture_subauth");
        public static final /* enum */ Flag excludeInConnectivityTest = new Flag("excludeInConnectivityTest", "exclude_in_connectivity_test");
        public static final /* enum */ Flag includeInConnectivityTest = new Flag("includeInConnectivityTest", "include_in_connectivity_test");
        public static final /* enum */ Flag workaroundMustReconnectEachCall = new Flag("workaroundMustReconnectEachCall", "must_reconnect_each_call");
        public static final /* enum */ Flag workaroundForceAmv2Describe = new Flag("workaroundForceAmv2Describe", "force_amv2_describe");
        public static final /* enum */ Flag workaroundForceAmv2Status = new Flag("workaroundForceAmv2Status", "force_amv2_status");
        public static final /* enum */ Flag workaroundForceAmv2Delete = new Flag("workaroundForceAmv2Delete", "force_amv2_delete");
        public static final /* enum */ Flag workaroundForceAmv2All = new Flag("workaroundForceAmv2All", "force_amv2_all");
        public static final /* enum */ Flag workaroundForceAmv3All = new Flag("workaroundForceAmv3All", "force_amv3_all");
        public static final /* enum */ Flag workaroundRemoveAbacCredential = new Flag("workaroundRemoveAbacCredential", "remove_abac_credential");
        public static final /* enum */ Flag workaroundRemoveSfaCredential = new Flag("workaroundRemoveSfaCredential", "remove_sfa_credential");
        public static final /* enum */ Flag workaroundForceRenewAfterCreateSliver = new Flag("workaroundForceRenewAfterCreateSliver", "force_renew_after_createsliver");
        public static final /* enum */ Flag workaroundIgnoreProvisionOperationalStatus = new Flag("workaroundIgnoreProvisionOperationalStatus", "ignore_provision_operational_status");
        public static final /* enum */ Flag workaroundAddExpiresAttributeToRequestRspec = new Flag("workaroundAddExpiresAttributeToRequestRspec", "add_expires_attribute_to_request_rspec");
        public static final /* enum */ Flag workaroundFedMaMatchProjectExpired = new Flag("workaroundFedMaMatchProjectExpired", "match_project_expired");
        public static final /* enum */ Flag workaroundFedSaLookupSliceExpiredMatchBoolean = new Flag("workaroundFedSaLookupSliceExpiredMatchBoolean", "bug_workaround_lookup_slice_expired_match_boolean");
        public static final /* enum */ Flag workaroundRequestAvailableAdvertisement = new Flag("workaroundRequestAvailableAdvertisement", null);
        @Deprecated
        public static final /* enum */ Flag featureStitching = new Flag("featureStitching", "supports_stitching");
        public static final /* enum */ Flag featureStitchingAdvertisementRspecUptodate = new Flag("featureStitchingAdvertisementRspecUptodate", "stitching_advertisement_rspec_uptodate");
        public static final /* enum */ Flag featureStitchingAny = new Flag("featureStitchingAny", "stitching_supports_any");
        public static final /* enum */ Flag featurePoaUpdateSshKeys = new Flag("featurePoaUpdateSshKeys", "supports_poa_update_ssh_keys");
        public static final /* enum */ Flag featurePoaShareLan = new Flag("featurePoaShareLan", "supports_poa_share_lan");
        public static final /* enum */ Flag featurePoaNodeRestart = new Flag("featurePoaNodeRestart", "supports_poa_node_restart");
        public static final /* enum */ Flag featurePoaReloadOs = new Flag("featurePoaReloadOs", "supports_poa_reload_os");
        public static final /* enum */ Flag featurePoaOpenConsole = new Flag("featurePoaOpenConsole", "supports_poa_open_console");
        public static final /* enum */ Flag featureReservationsNitos = new Flag("featureReservationsNitos", "supports_reservations_nitos");
        public static final /* enum */ Flag featureReservationsGeni = new Flag("featureReservationsGeni", "supports_reservations_geni");
        public static final /* enum */ Flag featureFedSaLookupSliceForMemberMatchExpired = new Flag("featureFedSaLookupSliceForMemberMatchExpired", "feature_lookup_slice_for_member_match_expired");
        public static final /* enum */ Flag featureFedMaRequestMemberSshKey = new Flag("featureFedMaRequestMemberSshKey", "feature_request_member_ssh_keys");
        public static final /* enum */ Flag featureFedMaRequestProjectMembers = new Flag("featureFedMaRequestProjectMembers", "feature_request_project_members");
        public static final /* enum */ Flag featurePoaExtDiskImageOps = new Flag("featurePoaExtDiskImageOps", "supports_poa_ext_diskimage_ops");
        public static final /* enum */ Flag featureListDiskImages = new Flag("featureListDiskImages", null);
        public static final /* enum */ Flag featureWirelessChannelReservation = new Flag("featureWirelessChannelReservation", null);
        public static final /* enum */ Flag featureExecuteAndInstallService = new Flag("featureExecuteAndInstallService", null);
        public static final /* enum */ Flag featureIPv4AddressPool = new Flag("featureIPv4AddressPool", null);
        public static final /* enum */ Flag featureSASliceRSpec = new Flag("featureSASliceRSpec", null);
        public static final /* enum */ Flag featureHandlesAllSubAuthorities = new Flag("featureHandlesAllSubAuthorities", null);
        public static final /* enum */ Flag featureSiteEnableChoice = new Flag("featureSiteEnableChoice", null);
        public static final /* enum */ Flag featureSiteIncludeToplevelSite = new Flag("featureSiteIncludeToplevelSite", null);
        public static final /* enum */ Flag featureSiteFilterNodesBySite = new Flag("featureSiteFilterNodesBySite", null);
        public static final /* enum */ Flag workaroundNoSliceSharingAllowedOnAM = new Flag("workaroundNoSliceSharingAllowedOnAM", null);
        public static final /* enum */ Flag workaroundProvisionSingleSSHAccount = new Flag("workaroundProvisionSingleSSHAccount", null);
        public static final /* enum */ Flag workaroundProvisionSingleSSHKey = new Flag("workaroundProvisionSingleSSHKey", null);
        public static final /* enum */ Flag workaroundProvisionIgnoreSSHKey = new Flag("workaroundProvisionIgnoreSSHKey", null);
        public static final /* enum */ Flag workaroundInsanelyLongProvisionTime = new Flag("workaroundInsanelyLongProvisionTime", null);
        public static final /* enum */ Flag workaroundLongConnectTimeout = new Flag("workaroundLongConnectTimeout", null);
        public static final /* enum */ Flag workaroundInsanelyLongConnectTimeout = new Flag("workaroundInsanelyLongConnectTimeout", null);
        public static final /* enum */ Flag workaroundLongReadTimeout = new Flag("workaroundLongReadTimeout", null);
        public static final /* enum */ Flag workaroundInsanelyLongReadTimeout = new Flag("workaroundInsanelyLongReadTimeout", null);
        public static final /* enum */ Flag workaroundNoRenew = new Flag("workaroundNoRenew", null);
        private final String jsonText;
        private final String specialCaseId;
        private static final /* synthetic */ Flag[] $VALUES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String name) {
            return Enum.valueOf(Flag.class, name);
        }

        private Flag(String jsonText, String specialCaseId) {
            assert (jsonText != null);
            this.jsonText = jsonText;
            this.specialCaseId = specialCaseId;
        }

        public String getJsonText() {
            return this.jsonText;
        }

        public String getSpecialCaseId() {
            return this.specialCaseId;
        }

        static Flag findByJsonText(String jsonText) {
            for (Flag f : Flag.values()) {
                if (!f.getJsonText().equalsIgnoreCase(jsonText)) continue;
                return f;
            }
            throw new IllegalArgumentException("No flag found for \"" + jsonText + "\"");
        }

        static Flag findBySpecialCaseId(String specialCaseId) {
            for (Flag f : Flag.values()) {
                if (f.getSpecialCaseId() == null || !f.getSpecialCaseId().equalsIgnoreCase(specialCaseId)) continue;
                return f;
            }
            throw new IllegalArgumentException("No flag found with specialCaseId \"" + specialCaseId + "\"");
        }

        private static /* synthetic */ Flag[] $values() {
            return new Flag[]{preferToplevelOverSubauthority, fedmonHasNodeAvailabilityDetails, centralBrokerArchitectureBrokerauth, centralBrokerArchitectureSubauth, excludeInConnectivityTest, includeInConnectivityTest, workaroundMustReconnectEachCall, workaroundForceAmv2Describe, workaroundForceAmv2Status, workaroundForceAmv2Delete, workaroundForceAmv2All, workaroundForceAmv3All, workaroundRemoveAbacCredential, workaroundRemoveSfaCredential, workaroundForceRenewAfterCreateSliver, workaroundIgnoreProvisionOperationalStatus, workaroundAddExpiresAttributeToRequestRspec, workaroundFedMaMatchProjectExpired, workaroundFedSaLookupSliceExpiredMatchBoolean, workaroundRequestAvailableAdvertisement, featureStitching, featureStitchingAdvertisementRspecUptodate, featureStitchingAny, featurePoaUpdateSshKeys, featurePoaShareLan, featurePoaNodeRestart, featurePoaReloadOs, featurePoaOpenConsole, featureReservationsNitos, featureReservationsGeni, featureFedSaLookupSliceForMemberMatchExpired, featureFedMaRequestMemberSshKey, featureFedMaRequestProjectMembers, featurePoaExtDiskImageOps, featureListDiskImages, featureWirelessChannelReservation, featureExecuteAndInstallService, featureIPv4AddressPool, featureSASliceRSpec, featureHandlesAllSubAuthorities, featureSiteEnableChoice, featureSiteIncludeToplevelSite, featureSiteFilterNodesBySite, workaroundNoSliceSharingAllowedOnAM, workaroundProvisionSingleSSHAccount, workaroundProvisionSingleSSHKey, workaroundProvisionIgnoreSSHKey, workaroundInsanelyLongProvisionTime, workaroundLongConnectTimeout, workaroundInsanelyLongConnectTimeout, workaroundLongReadTimeout, workaroundInsanelyLongReadTimeout, workaroundNoRenew};
        }

        static {
            $VALUES = Flag.$values();
        }
    }
}

