/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Server.class)
public class ServerBuilder
extends PrimaryIdObjectBuilder<Integer, Server, ServerBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerBuilder.class);
    private String name;
    private String certificateChain;
    private String allowedCertificateAlias;
    private String serverType;
    private String urnTld;
    private String baseUrl;
    private Location location;
    private List<Service> scs;
    private Service defaultScs;
    private List<Service> userAuth;
    private Service defaultUserAuth;
    private Collection<String> flags;
    private Testbed testbed;
    private List<Service> services;
    private List<ServiceBuilder> serviceBuilders;
    private Service defaultAMService;
    private ServiceBuilder defaultAMServiceBuilder;
    private String defaultComponentManagerUrn;

    public ServerBuilder() {
    }

    public ServerBuilder(Server orig) {
        this(orig, false);
    }

    public ServerBuilder(Server orig, boolean recursiveServiceBuilders) {
        super(orig);
        this.name = orig.getName();
        this.certificateChain = orig.getCertificateChain();
        this.allowedCertificateAlias = orig.getAllowedCertificateAlias();
        this.serverType = orig.getServerType();
        this.urnTld = orig.getUrnTld();
        this.baseUrl = orig.getBaseUrl();
        this.location = orig.getLocation();
        this.scs = orig.getScs();
        this.defaultScs = orig.getDefaultScs();
        this.userAuth = orig.getUserAuth();
        this.defaultUserAuth = orig.getDefaultUserAuth();
        this.flags = orig.getFlags();
        this.testbed = orig.getTestbed();
        this.defaultAMService = orig.getDefaultAMService();
        this.defaultComponentManagerUrn = orig.getDefaultComponentManagerUrn();
        if (!recursiveServiceBuilders) {
            this.serviceBuilders = null;
            this.services = orig.getServices();
        } else {
            this.services = null;
            this.defaultAMService = null;
            if (orig.getServices() != null) {
                this.serviceBuilders = new ArrayList<ServiceBuilder>();
                for (Service service : orig.getServices()) {
                    ServiceBuilder serviceBuilder = new ServiceBuilder(service);
                    this.serviceBuilders.add(serviceBuilder);
                    if (orig.getDefaultAMService() == null || service.getId() == null || !((Integer)service.getId()).equals(orig.getDefaultAMService().getId())) continue;
                    this.defaultAMServiceBuilder = serviceBuilder;
                }
                if (this.defaultAMServiceBuilder == null && orig.getDefaultAMService() != null) {
                    LOG.warn("Default AM service for testbed " + this.getId() + " was not in list of services.");
                    this.defaultAMServiceBuilder = new ServiceBuilder(orig.getDefaultAMService());
                }
            } else {
                this.serviceBuilders = null;
                if (orig.getDefaultAMService() != null) {
                    LOG.warn("Default AM service for testbed " + this.getId() + " was specified, but there is no list of services. Will remove default AM.");
                }
                this.defaultAMServiceBuilder = null;
            }
        }
    }

    public ServerBuilder(Map jsonMap) {
        Object type = jsonMap.get("@type");
        if (type == null || !type.equals("Server")) {
            throw new IllegalArgumentException("Illegal type, cannot build Server from this: " + type);
        }
        Object uri = jsonMap.get("@id");
        Object id = jsonMap.get("id");
        Object componentManager = jsonMap.get("defaultComponentManagerUrn");
        if (id != null && id instanceof Integer) {
            this.id = (Integer)id;
        }
        if (uri != null && uri instanceof String) {
            try {
                this.uri = new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.debug("invalid Server URI. will be ignored: \"" + uri + "\"");
            }
        }
        if (componentManager != null && componentManager instanceof String) {
            this.defaultComponentManagerUrn = (String)componentManager;
        }
    }

    public ServerBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ServerBuilder setCertificateChain(String certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public ServerBuilder setAllowedCertificateAlias(String allowedCertificateAlias) {
        this.allowedCertificateAlias = allowedCertificateAlias;
        return this;
    }

    public ServerBuilder setServerType(String serverType) {
        this.serverType = serverType;
        return this;
    }

    public ServerBuilder setUrnTld(String urnTld) {
        this.urnTld = urnTld;
        return this;
    }

    public ServerBuilder setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public ServerBuilder setLocation(Location location) {
        this.location = location;
        return this;
    }

    public ServerBuilder setLocation(String country, Double longitude, Double latitude) {
        this.location = new Location(country, longitude, latitude, null);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Service.class, name="scs")
    public ServerBuilder setScs(List<Service> scs) {
        this.scs = scs;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Service.class, name="defaultScs")
    public ServerBuilder setDefaultScs(Service defaultScs) {
        this.defaultScs = defaultScs;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Service.class, name="userAuth")
    public ServerBuilder setUserAuth(List<Service> userAuth) {
        this.userAuth = userAuth;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Service.class, name="defaultUserAuth")
    public ServerBuilder setDefaultUserAuth(Service defaultUserAuth) {
        this.defaultUserAuth = defaultUserAuth;
        return this;
    }

    public ServerBuilder setFlags(Collection<String> flags) {
        this.flags = flags;
        return this;
    }

    public void addFlag(String flag) {
        if (this.flags == null) {
            this.flags = new TreeSet<String>();
        }
        this.flags.add(flag);
    }

    public void addFlag(Server.Flag flag) {
        if (this.flags == null) {
            this.flags = new TreeSet<String>();
        }
        this.flags.add(flag.getJsonText());
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Testbed.class)
    public ServerBuilder setTestbed(Testbed testbed) {
        this.testbed = testbed;
        return this;
    }

    public ServerBuilder setTestbedId(String testbedId) {
        this.testbed = ((TestbedBuilder)new TestbedBuilder().setId(testbedId)).create();
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Service.class)
    public ServerBuilder setServices(List<Service> services) {
        this.services = services;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Service.class, builderReference=true)
    public ServerBuilder setServiceBuilders(List<ServiceBuilder> serviceBuilders) {
        this.serviceBuilders = serviceBuilders == null ? null : new ArrayList<ServiceBuilder>(serviceBuilders);
        return this;
    }

    public ServerBuilder addService(Service extraService) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(extraService);
        return this;
    }

    public ServerBuilder addServiceBuilder(ServiceBuilder curServiceBuilder) {
        if (this.serviceBuilders == null) {
            this.serviceBuilders = new ArrayList<ServiceBuilder>();
        }
        this.serviceBuilders.add(curServiceBuilder);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Service.class, name="defaultAMService")
    public ServerBuilder setDefaultAMService(Service defaultAMService) {
        this.defaultAMService = defaultAMService;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Service.class, name="defaultAMService", builderReference=true)
    public ServerBuilder setDefaultAMServiceBuilder(ServiceBuilder defaultAMServiceBuilder) {
        this.defaultAMServiceBuilder = defaultAMServiceBuilder;
        return this;
    }

    public ServerBuilder setDefaultComponentManagerUrn(String defaultComponentManagerUrn) {
        this.defaultComponentManagerUrn = defaultComponentManagerUrn;
        return this;
    }

    public boolean usesBuilders() throws IllegalStateException {
        if (this.serviceBuilders != null && this.services != null) {
            throw new IllegalStateException("Either none, only services or only serviceBuilders must be set, not both.");
        }
        if (this.defaultAMServiceBuilder != null && this.defaultAMService != null) {
            throw new IllegalStateException("Either none, only defaultAMServiceBuilder or only defaultAMService must be set, not both.");
        }
        if (this.defaultAMServiceBuilder != null && this.services != null || this.defaultAMService != null && this.serviceBuilders != null) {
            throw new IllegalStateException("defaultAMService(" + (this.defaultAMService != null ? "not" : "") + "Builder) and service(" + (this.services != null ? "not" : "") + "Builders) mismatch.");
        }
        return this.serviceBuilders != null || this.defaultAMServiceBuilder != null;
    }

    @Override
    public Server create() {
        boolean builders = this.usesBuilders();
        if (builders) {
            return new Server(null, (Integer)this.id, this.name, this.certificateChain, this.allowedCertificateAlias, this.serverType, this.urnTld, this.baseUrl, this.location, this.scs, this.defaultScs, this.userAuth, this.defaultUserAuth, this.flags, this.testbed, this.serviceBuilders, this.defaultAMServiceBuilder, this.defaultComponentManagerUrn, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
        }
        return new Server((Integer)this.id, this.name, this.certificateChain, this.allowedCertificateAlias, this.serverType, this.urnTld, this.baseUrl, this.location, this.scs, this.defaultScs, this.userAuth, this.defaultUserAuth, this.flags, this.testbed, this.services, this.defaultAMService, this.defaultComponentManagerUrn, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    @Override
    public Server createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        boolean builders = this.usesBuilders();
        if (minimization == JsonLdObjectsMetaData.Minimization.FULL) {
            return this.create();
        }
        if (builders) {
            return new Server(minimization.getChildrenMinimization(), minimization.includeId() ? (Integer)this.id : null, minimization.includeOtherProperties() ? this.name : null, minimization.includeOtherProperties() ? this.certificateChain : null, minimization.includeOtherProperties() ? this.allowedCertificateAlias : null, minimization.includeOtherProperties() ? this.serverType : null, minimization.includeOtherProperties() ? this.urnTld : null, minimization.includeOtherProperties() ? this.baseUrl : null, minimization.includeOtherProperties() ? this.location : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.scs) : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.defaultScs) : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.userAuth) : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.defaultUserAuth) : null, minimization.includeOtherProperties() ? this.flags : null, this.testbed == null || !minimization.includeParent() ? null : TestbedBuilder.minimize(minimization.getParentMinimization(), this.testbed), !minimization.includeChildren() ? null : this.serviceBuilders, !minimization.includeChildren() ? null : this.defaultAMServiceBuilder, minimization.includeOtherProperties() ? this.defaultComponentManagerUrn : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
        }
        return new Server(minimization.includeId() ? (Integer)this.id : null, minimization.includeOtherProperties() ? this.name : null, minimization.includeOtherProperties() ? this.certificateChain : null, minimization.includeOtherProperties() ? this.allowedCertificateAlias : null, minimization.includeOtherProperties() ? this.serverType : null, minimization.includeOtherProperties() ? this.urnTld : null, minimization.includeOtherProperties() ? this.baseUrl : null, minimization.includeOtherProperties() ? this.location : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.scs) : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.defaultScs) : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.userAuth) : null, minimization.includeOtherProperties() ? ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.defaultUserAuth) : null, minimization.includeOtherProperties() ? this.flags : null, this.testbed == null || !minimization.includeParent() ? null : TestbedBuilder.minimize(minimization.getParentMinimization(), this.testbed), this.services == null || !minimization.includeChildren() ? null : ServiceBuilder.minimize(minimization.getChildrenMinimization(), this.services), this.defaultAMService == null || !minimization.includeChildren() ? null : ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY, this.defaultAMService), minimization.includeOtherProperties() ? this.defaultComponentManagerUrn : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<Server> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<Server> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Server> res = new ArrayList<Server>();
        for (Server tb : in) {
            res.add(new ServerBuilder(tb).createMinimized(minimization));
        }
        return res;
    }

    public static Server minimize(JsonLdObjectsMetaData.Minimization minimization, Server in) {
        if (in == null) {
            return null;
        }
        return new ServerBuilder(in).createMinimized(minimization);
    }

    public String getName() {
        return this.name;
    }

    public String getCertificateChain() {
        return this.certificateChain;
    }

    public String getAllowedCertificateAlias() {
        return this.allowedCertificateAlias;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getUrnTld() {
        return this.urnTld;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Location getLocation() {
        return this.location;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Service.class, name="scs")
    public List<Service> getScs() {
        return this.scs;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Service.class, name="defaultScs")
    public Service getDefaultScs() {
        return this.defaultScs;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Service.class, name="userAuth")
    public List<Service> getUserAuth() {
        return this.userAuth;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Service.class, name="defaultUserAuth")
    public Service getDefaultUserAuth() {
        return this.defaultUserAuth;
    }

    public Collection<String> getFlags() {
        return this.flags;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Testbed.class)
    public Testbed getTestbed() {
        return this.testbed;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Service.class)
    public List<Service> getServices() {
        return this.services;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Service.class, name="defaultAMService")
    public Service getDefaultAMService() {
        return this.defaultAMService;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Service.class, builderReference=true)
    public List<ServiceBuilder> getServiceBuilders() {
        return this.serviceBuilders;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Service.class, name="defaultAMService", builderReference=true)
    public ServiceBuilder getDefaultAMServiceBuilder() {
        return this.defaultAMServiceBuilder;
    }

    public String getDefaultComponentManagerUrn() {
        return this.defaultComponentManagerUrn;
    }
}

