/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse_v1;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.ForeignIdObjectBuilder;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=ServerGlimpse_v1.class)
public class ServerGlimpseBuilder_v1
extends ForeignIdObjectBuilder<ServerGlimpse_v1, ServerGlimpseBuilder_v1> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGlimpseBuilder_v1.class);
    private Server server;
    private ServerBuilder serverBuilder;
    private Timestamp advertisementTimestamp;
    private Result advertisementResult;
    private URI rspec;
    private Set<String> componentManagerIds;
    private Set<String> availableComponentIds;
    private Set<String> unavailableComponentIds;
    private Map<String, MutableDiskImage> diskImagesById;
    private TreeMap<String, Integer> counts;
    private Map<String, MutableSliverTypeInfo> sliverTypeInfoBySliverType;
    private MutableSliverTypeInfo nullSliverTypeInfo;
    private Timestamp healthTimestamp;
    private Result healthResult;
    private Integer health;
    private String healthExplanation;
    private String healthExplanationFull;
    private String healthStatus;

    public ServerGlimpseBuilder_v1() {
    }

    public ServerGlimpseBuilder_v1(ServerGlimpse_v1 orig) {
        this.server = orig.getServer();
        this.serverBuilder = null;
        this.uri = orig.getUri();
        this.setAdvertisementInfo(orig.getAdvertisementInfo());
        this.setHealthInfo(orig.getHealthInfo());
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, name="server")
    public ServerGlimpseBuilder_v1 setServer(Server server) {
        this.server = server;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, name="server", builderReference=true)
    public ServerGlimpseBuilder_v1 setServerBuilder(ServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    @Override
    public ServerGlimpseBuilder_v1 setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ServerGlimpseBuilder_v1 setAdvertisementInfo(ServerGlimpse_v1.AdvertisementInfo advertisementInfo) {
        if (advertisementInfo == null) {
            this.advertisementTimestamp = null;
            this.advertisementResult = null;
            this.rspec = null;
            this.diskImagesById = null;
            this.nullSliverTypeInfo = null;
            this.sliverTypeInfoBySliverType = null;
            this.counts = null;
            this.componentManagerIds = null;
            this.availableComponentIds = null;
            this.unavailableComponentIds = null;
        } else {
            this.advertisementTimestamp = advertisementInfo.getTimestamp();
            this.advertisementResult = advertisementInfo.getResult();
            this.rspec = advertisementInfo.getRspec();
            if (advertisementInfo.getCounts() != null) {
                this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                this.counts.putAll(advertisementInfo.getCounts());
            } else {
                this.counts = null;
            }
            this.componentManagerIds = advertisementInfo.getComponentManagerIds() == null ? null : new TreeSet<String>(advertisementInfo.getComponentManagerIds());
            this.availableComponentIds = advertisementInfo.getAvailableComponentIds() == null ? null : new TreeSet<String>(advertisementInfo.getAvailableComponentIds());
            this.unavailableComponentIds = advertisementInfo.getUnavailableComponentIds() == null ? null : new TreeSet<String>(advertisementInfo.getUnavailableComponentIds());
            this.setDiskImages(advertisementInfo.getDiskImages());
            this.setSliverTypeInfo(advertisementInfo.getSliverTypeInfo());
        }
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealthInfo(ServerGlimpse_v1.HealthInfo healthInfo) {
        if (healthInfo != null) {
            this.healthTimestamp = healthInfo.getTimestamp();
            this.healthResult = healthInfo.getResult();
            this.health = healthInfo.getHealth();
            this.healthExplanation = healthInfo.getHealthExplanation();
            this.healthExplanationFull = healthInfo.getHealthExplanationFull();
            this.healthStatus = healthInfo.getStatus();
        } else {
            this.healthTimestamp = null;
            this.healthResult = null;
            this.health = null;
            this.healthExplanation = null;
            this.healthExplanationFull = null;
            this.healthStatus = null;
        }
        return this;
    }

    public ServerGlimpseBuilder_v1 setAdvertisementTimestamp(Timestamp timestamp) {
        this.advertisementTimestamp = timestamp;
        return this;
    }

    public ServerGlimpseBuilder_v1 setAdvertisementTimestamp(Date timestamp) {
        this.advertisementTimestamp = new Timestamp(timestamp.getTime());
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Result.class, name="advertisementResult")
    public ServerGlimpseBuilder_v1 setAdvertisementResult(Result result) {
        this.advertisementResult = result;
        return this;
    }

    public ServerGlimpseBuilder_v1 setAdvertisementResultId(Long resultId) {
        this.advertisementResult = resultId == null ? null : ((ResultBuilder)new ResultBuilder().setId(resultId)).create();
        return this;
    }

    public ServerGlimpseBuilder_v1 setRspec(URI rspec) {
        this.rspec = rspec;
        return this;
    }

    private void setSliverTypeInfo(List<ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo> sliverTypeInfos) {
        if (sliverTypeInfos == null) {
            this.sliverTypeInfoBySliverType = null;
            this.nullSliverTypeInfo = null;
        } else {
            this.nullSliverTypeInfo = null;
            this.sliverTypeInfoBySliverType = new HashMap<String, MutableSliverTypeInfo>();
            for (ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo sliverTypeInfo : sliverTypeInfos) {
                if (sliverTypeInfo.getSliverType() == null) {
                    assert (this.nullSliverTypeInfo == null);
                    this.nullSliverTypeInfo = new MutableSliverTypeInfo(sliverTypeInfo);
                    continue;
                }
                this.sliverTypeInfoBySliverType.put(sliverTypeInfo.getSliverType(), new MutableSliverTypeInfo(sliverTypeInfo));
            }
        }
    }

    public ServerGlimpseBuilder_v1 addNoSliverHardwareType(String hardwareType) {
        this.mergeSliverTypeInfo(null, Collections.singleton(hardwareType), null);
        return this;
    }

    public ServerGlimpseBuilder_v1 addNoSliverHardwareType(Collection<String> hardwareTypes) {
        this.mergeSliverTypeInfo(null, hardwareTypes, null);
        return this;
    }

    public ServerGlimpseBuilder_v1 mergeSliverTypeInfo(String sliverType, Collection<String> hardwareTypes, String defaultDiskImage) {
        MutableSliverTypeInfo existing;
        if (this.sliverTypeInfoBySliverType == null) {
            this.sliverTypeInfoBySliverType = new HashMap<String, MutableSliverTypeInfo>();
        }
        MutableSliverTypeInfo mutableSliverTypeInfo = existing = sliverType == null ? this.nullSliverTypeInfo : this.sliverTypeInfoBySliverType.get(sliverType);
        if (existing == null) {
            MutableSliverTypeInfo updated = new MutableSliverTypeInfo(sliverType, hardwareTypes, defaultDiskImage);
            if (sliverType == null) {
                this.nullSliverTypeInfo = updated;
            } else {
                this.sliverTypeInfoBySliverType.put(sliverType, updated);
            }
        } else {
            MutableSliverTypeInfo updated = existing;
            if (hardwareTypes != null) {
                updated.addHardwareTypes(hardwareTypes);
            }
            if (defaultDiskImage != null) {
                updated.setDefaultDiskImage(defaultDiskImage);
            }
        }
        return this;
    }

    public ServerGlimpseBuilder_v1 setComponentManagerIds(Collection<String> componentManagerIds) {
        this.componentManagerIds = componentManagerIds == null ? null : new TreeSet<String>(componentManagerIds);
        return this;
    }

    public ServerGlimpseBuilder_v1 setAvailableComponentIds(Collection<String> availableComponentIds) {
        this.availableComponentIds = availableComponentIds == null ? null : new TreeSet<String>(availableComponentIds);
        return this;
    }

    public ServerGlimpseBuilder_v1 setUnavailableComponentIds(Collection<String> unavailableComponentIds) {
        this.unavailableComponentIds = unavailableComponentIds == null ? null : new TreeSet<String>(unavailableComponentIds);
        return this;
    }

    public ServerGlimpseBuilder_v1 addComponentManagerId(String componentManagerId) {
        if (this.componentManagerIds == null) {
            this.componentManagerIds = new TreeSet<String>();
        }
        this.componentManagerIds.add(componentManagerId);
        return this;
    }

    public ServerGlimpseBuilder_v1 addAvailableComponentId(String componentId) {
        if (this.availableComponentIds == null) {
            this.availableComponentIds = new TreeSet<String>();
        }
        this.availableComponentIds.add(componentId);
        return this;
    }

    public ServerGlimpseBuilder_v1 addUnavailableComponentId(String componentId) {
        if (this.unavailableComponentIds == null) {
            this.unavailableComponentIds = new TreeSet<String>();
        }
        this.unavailableComponentIds.add(componentId);
        return this;
    }

    public ServerGlimpseBuilder_v1 setDiskImages(Collection<ServerGlimpse_v1.AdvertisementInfo.DiskImage> diskImages) {
        if (diskImages == null) {
            this.diskImagesById = null;
        } else {
            this.diskImagesById = new HashMap<String, MutableDiskImage>();
            for (ServerGlimpse_v1.AdvertisementInfo.DiskImage diskImage : diskImages) {
                String id;
                String string = id = diskImage.getName() == null ? diskImage.getName() : diskImage.getUrl();
                if (id == null) {
                    LOG.warn("Ignoring DiskImage without name or url");
                    continue;
                }
                this.diskImagesById.put(id, new MutableDiskImage(diskImage));
            }
        }
        return this;
    }

    public ServerGlimpseBuilder_v1 mergeDiskImage(ServerGlimpse_v1.AdvertisementInfo.DiskImage diskImage) {
        this.mergeDiskImage(diskImage.getName(), diskImage.getUrl(), diskImage.getDescription(), diskImage.getVersion(), diskImage.getOs(), diskImage.getSliverTypes());
        return this;
    }

    public ServerGlimpseBuilder_v1 mergeDiskImage(String name, String url, String description, String version, String os, String sliverType) {
        MutableDiskImage existing;
        String id;
        String string = id = name == null ? name : url;
        if (this.diskImagesById == null) {
            this.diskImagesById = new HashMap<String, MutableDiskImage>();
        }
        if ((existing = this.diskImagesById.get(id)) == null) {
            MutableDiskImage newDi = new MutableDiskImage(name, url, description, version, os);
            if (sliverType != null) {
                newDi.addSliverType(sliverType);
            }
            this.diskImagesById.put(id, newDi);
        } else if (sliverType != null) {
            existing.addSliverType(sliverType);
        }
        return this;
    }

    public ServerGlimpseBuilder_v1 mergeDiskImage(String name, String url, String description, String version, String os, Collection<String> sliverTypes) {
        MutableDiskImage existing;
        String id;
        String string = id = name == null ? name : url;
        if (this.diskImagesById == null) {
            this.diskImagesById = new HashMap<String, MutableDiskImage>();
        }
        if ((existing = this.diskImagesById.get(id)) == null) {
            MutableDiskImage newDi = new MutableDiskImage(name, url, description, version, os);
            if (sliverTypes != null) {
                newDi.addSliverTypes(sliverTypes);
            }
            this.diskImagesById.put(id, newDi);
        } else if (sliverTypes != null) {
            existing.addSliverTypes(sliverTypes);
        }
        return this;
    }

    public ServerGlimpseBuilder_v1 setCounts(Map<String, Integer> counts) {
        if (counts == null) {
            this.counts = null;
        } else {
            this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.counts.putAll(counts);
        }
        return this;
    }

    public ServerGlimpseBuilder_v1 setCount(ServerGlimpse_v1.AdvertisementInfo.CountedObject object, Integer all, Integer available) {
        assert (object != null);
        if (this.counts == null) {
            this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        this.counts.put(object.getKeyPrefixName() + ServerGlimpse_v1.AdvertisementInfo.CountScope.ALL.getKeySuffixName(), all);
        this.counts.put(object.getKeyPrefixName() + ServerGlimpse_v1.AdvertisementInfo.CountScope.AVAILABLE.getKeySuffixName(), available);
        return this;
    }

    public ServerGlimpseBuilder_v1 setCount(ServerGlimpse_v1.AdvertisementInfo.CountedObject object, ServerGlimpse_v1.AdvertisementInfo.CountScope scope, Integer value) {
        assert (object != null);
        assert (scope != null);
        if (this.counts == null) {
            this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        this.counts.put(object.getKeyPrefixName() + scope.getKeySuffixName(), value);
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealthTimestamp(Timestamp healthTimestamp) {
        this.healthTimestamp = healthTimestamp;
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealthTimestamp(Date healthTimestamp) {
        this.healthTimestamp = new Timestamp(healthTimestamp.getTime());
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Result.class, name="healthResult")
    public ServerGlimpseBuilder_v1 setHealthResult(Result healthResult) {
        this.healthResult = healthResult;
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealthResultId(Long resultId) {
        this.healthResult = resultId == null ? null : ((ResultBuilder)new ResultBuilder().setId(resultId)).create();
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealth(Integer health) {
        this.health = health;
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealthExplanation(String healthExplanation) {
        this.healthExplanation = healthExplanation;
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealthExplanationFull(String healthExplanationFull) {
        this.healthExplanationFull = healthExplanationFull;
        return this;
    }

    public ServerGlimpseBuilder_v1 setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
        return this;
    }

    @Override
    public ServerGlimpse_v1 create() {
        ServerGlimpse_v1.HealthInfo healthInfo;
        if (this.serverBuilder != null && this.server != null) {
            throw new IllegalStateException("Either none, only server or only serverBuilder must be set, not both.");
        }
        Result usedAdvertisementResult = this.advertisementResult == null ? null : new ResultBuilder(this.advertisementResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasAdvertisement = this.advertisementTimestamp != null || usedAdvertisementResult != null || this.rspec != null || this.sliverTypeInfoBySliverType != null || this.nullSliverTypeInfo != null || this.diskImagesById != null || this.componentManagerIds != null || this.availableComponentIds != null || this.unavailableComponentIds != null || this.counts != null;
        ServerGlimpse_v1.AdvertisementInfo advertisementInfo = hasAdvertisement ? new ServerGlimpse_v1.AdvertisementInfo(this.advertisementTimestamp, usedAdvertisementResult, this.rspec, this.getSliverTypeInfo(), this.getDiskImages(), this.componentManagerIds, this.availableComponentIds, this.unavailableComponentIds, this.counts) : null;
        Result usedHealthResult = this.healthResult == null ? null : new ResultBuilder(this.healthResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasHealth = this.health != null || this.healthExplanation != null || this.healthExplanationFull != null || usedHealthResult != null || this.healthStatus != null || this.healthTimestamp != null;
        ServerGlimpse_v1.HealthInfo healthInfo2 = healthInfo = hasHealth ? new ServerGlimpse_v1.HealthInfo(this.healthTimestamp, usedHealthResult, this.health, this.healthExplanation, this.healthExplanationFull, this.healthStatus) : null;
        Server usedServer = this.server == null && this.serverBuilder != null ? this.serverBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY) : (this.server == null ? null : new ServerBuilder(this.server).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
        return new ServerGlimpse_v1(advertisementInfo, healthInfo, usedServer, this.uri);
    }

    @Override
    public ServerGlimpse_v1 createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        ServerGlimpse_v1.HealthInfo healthInfo;
        if (this.serverBuilder != null && this.server != null) {
            throw new IllegalStateException("Either none, only server or only serverBuilder must be set, not both.");
        }
        Result usedAdvertisementResult = this.advertisementResult == null ? null : new ResultBuilder(this.advertisementResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasAdvertisement = this.advertisementTimestamp != null || usedAdvertisementResult != null || this.rspec != null || this.sliverTypeInfoBySliverType != null || this.nullSliverTypeInfo != null || this.diskImagesById != null || this.componentManagerIds != null || this.availableComponentIds != null || this.unavailableComponentIds != null || this.counts != null;
        ServerGlimpse_v1.AdvertisementInfo advertisementInfo = hasAdvertisement ? new ServerGlimpse_v1.AdvertisementInfo(this.advertisementTimestamp, usedAdvertisementResult, this.rspec, this.getSliverTypeInfo(), this.getDiskImages(), this.componentManagerIds, this.availableComponentIds, this.unavailableComponentIds, this.counts) : null;
        Result usedHealthResult = this.healthResult == null ? null : new ResultBuilder(this.healthResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasHealth = this.health != null || this.healthExplanation != null || this.healthExplanationFull != null || usedHealthResult != null || this.healthStatus != null || this.healthTimestamp != null;
        ServerGlimpse_v1.HealthInfo healthInfo2 = healthInfo = hasHealth ? new ServerGlimpse_v1.HealthInfo(this.healthTimestamp, usedHealthResult, this.health, this.healthExplanation, this.healthExplanationFull, this.healthStatus) : null;
        Server usedServer = this.server == null && this.serverBuilder != null ? this.serverBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY) : (this.server == null ? null : new ServerBuilder(this.server).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
        return new ServerGlimpse_v1(minimization.includeOtherProperties() ? advertisementInfo : null, minimization.includeOtherProperties() ? healthInfo : null, minimization.includeId() ? usedServer : null, minimization.includeId() ? this.uri : null);
    }

    public static List<ServerGlimpse_v1> createAll(Collection<ServerGlimpseBuilder_v1> builders) {
        if (builders == null) {
            return null;
        }
        ArrayList<ServerGlimpse_v1> res = new ArrayList<ServerGlimpse_v1>();
        for (ServerGlimpseBuilder_v1 b : builders) {
            res.add(b.create());
        }
        return res;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, name="server")
    public Server getServer() {
        return this.server;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, name="server", builderReference=true)
    public ServerBuilder getServerBuilder() {
        return this.serverBuilder;
    }

    public Date getTimestamp() {
        return this.advertisementTimestamp;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Result.class, name="advertisementResult")
    public Result getAdvertisementResult() {
        return this.advertisementResult;
    }

    public URI getRspec() {
        return this.rspec;
    }

    public Set<String> getComponentManagerIds() {
        return this.componentManagerIds;
    }

    public Set<String> getAvailableComponentIds() {
        return this.availableComponentIds;
    }

    public Set<String> getUnavailableComponentIds() {
        return this.unavailableComponentIds;
    }

    public Integer getServerId() {
        return this.server == null ? (this.serverBuilder == null ? null : (Integer)this.serverBuilder.getId()) : (Integer)this.server.getId();
    }

    public Map<String, Integer> getCounts() {
        return this.counts;
    }

    public Date getHealthTimestamp() {
        return this.healthTimestamp;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Result.class, name="healthResult")
    public Result getHealthResult() {
        return this.healthResult;
    }

    public Integer getHealth() {
        return this.health;
    }

    public String getHealthExplanation() {
        return this.healthExplanation;
    }

    public String getHealthExplanationFull() {
        return this.healthExplanationFull;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public Integer getCount(ServerGlimpse_v1.AdvertisementInfo.CountedObject object, ServerGlimpse_v1.AdvertisementInfo.CountScope scope) {
        if (this.counts == null) {
            return null;
        }
        return this.counts.get(object.getKeyPrefixName() + scope.getKeySuffixName());
    }

    public List<ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo> getSliverTypeInfo() {
        if (this.nullSliverTypeInfo == null && this.sliverTypeInfoBySliverType == null) {
            return null;
        }
        ArrayList<ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo> res = new ArrayList<ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo>();
        if (this.sliverTypeInfoBySliverType != null) {
            for (MutableSliverTypeInfo msti : this.sliverTypeInfoBySliverType.values()) {
                res.add(msti.toSliverTypeInfo());
            }
        }
        if (this.nullSliverTypeInfo != null) {
            res.add(this.nullSliverTypeInfo.toSliverTypeInfo());
        }
        return res;
    }

    public List<ServerGlimpse_v1.AdvertisementInfo.DiskImage> getDiskImages() {
        if (this.diskImagesById == null) {
            return null;
        }
        ArrayList<ServerGlimpse_v1.AdvertisementInfo.DiskImage> res = new ArrayList<ServerGlimpse_v1.AdvertisementInfo.DiskImage>();
        for (MutableDiskImage diskImage : this.diskImagesById.values()) {
            res.add(diskImage.toDiskImage());
        }
        return res;
    }

    private static class MutableSliverTypeInfo {
        private final String sliverType;
        private Set<String> hardwareTypes;
        private String defaultDiskImage;

        public MutableSliverTypeInfo(String sliverType) {
            this.sliverType = sliverType;
        }

        public MutableSliverTypeInfo(ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo orig) {
            this.sliverType = orig.getSliverType();
            this.defaultDiskImage = orig.getDefaultDiskImage();
            this.hardwareTypes = orig.getHardwareTypes() == null ? null : new TreeSet<String>(orig.getHardwareTypes());
        }

        public MutableSliverTypeInfo(String sliverType, Collection<String> hardwareTypes, String defaultDiskImage) {
            this.sliverType = sliverType;
            this.defaultDiskImage = defaultDiskImage;
            this.hardwareTypes = hardwareTypes == null ? null : new TreeSet<String>(hardwareTypes);
        }

        public void addHardwareType(String hardwareType) {
            if (this.hardwareTypes == null) {
                this.hardwareTypes = new TreeSet<String>();
            }
            this.hardwareTypes.add(hardwareType);
        }

        public void addHardwareTypes(Collection<String> hardwareTypes) {
            if (this.hardwareTypes == null) {
                this.hardwareTypes = new TreeSet<String>();
            }
            this.hardwareTypes.addAll(hardwareTypes);
        }

        public void setDefaultDiskImage(String defaultDiskImage) {
            this.defaultDiskImage = defaultDiskImage;
        }

        public ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo toSliverTypeInfo() {
            return new ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo(this.sliverType, this.hardwareTypes, this.defaultDiskImage);
        }
    }

    private static class MutableDiskImage {
        private final String name;
        private final String url;
        private String description;
        private String os;
        private String version;
        private Set<String> sliverTypes;

        public MutableDiskImage(String name, String url, String description, String version, String os) {
            this.name = name;
            this.url = url;
            this.description = description;
            this.version = version;
            this.os = os;
            this.sliverTypes = new TreeSet<String>();
        }

        public MutableDiskImage(ServerGlimpse_v1.AdvertisementInfo.DiskImage orig) {
            this.name = orig.getName();
            this.url = orig.getUrl();
            this.description = orig.getDescription();
            this.version = orig.getVersion();
            this.os = orig.getOs();
            this.sliverTypes = orig.getSliverTypes() == null ? new TreeSet<String>() : new TreeSet<String>(orig.getSliverTypes());
        }

        public void addSliverType(String sliverType) {
            this.sliverTypes.add(sliverType);
        }

        public void addSliverTypes(Collection<String> sliverTypes) {
            this.sliverTypes.addAll(sliverTypes);
        }

        public ServerGlimpse_v1.AdvertisementInfo.DiskImage toDiskImage() {
            return new ServerGlimpse_v1.AdvertisementInfo.DiskImage(this.description, this.name, this.os, this.url, this.version, this.sliverTypes);
        }
    }
}

