/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Service.class)
public class ServiceBuilder
extends PrimaryIdObjectBuilder<Integer, Service, ServiceBuilder> {
    private Server server;
    private String api;
    private String apiVersion;
    private String url;
    private String urn;

    public ServiceBuilder() {
    }

    public ServiceBuilder(Service orig) {
        super(orig);
        assert (orig != null);
        this.server = orig.getServer();
        this.api = orig.getApi();
        this.apiVersion = orig.getApiVersion();
        this.url = orig.getUrl();
        this.urn = orig.getUrn();
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class)
    public ServiceBuilder setServer(Server server) {
        this.server = server;
        return this;
    }

    public ServiceBuilder setServerId(Integer serverId) {
        this.server = serverId == null ? null : ((ServerBuilder)new ServerBuilder().setId(serverId)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        return this;
    }

    public ServiceBuilder setApi(String api) {
        this.api = api;
        return this;
    }

    public ServiceBuilder setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public ServiceBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public ServiceBuilder setUrn(String urn) {
        this.urn = urn;
        return this;
    }

    @Override
    public Service create() {
        return new Service((Integer)this.id, this.server, this.api, this.apiVersion, this.url, this.urn, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    @Override
    public Service createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        if (minimization == JsonLdObjectsMetaData.Minimization.FULL) {
            return this.create();
        }
        return new Service(minimization.includeId() ? (Integer)this.id : null, this.server == null || !minimization.includeParent() ? null : ServerBuilder.minimize(minimization.getParentMinimization(), this.server), minimization.includeOtherProperties() ? this.api : null, minimization.includeOtherProperties() ? this.apiVersion : null, minimization.includeOtherProperties() ? this.url : null, minimization.includeOtherProperties() ? this.urn : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<Service> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<Service> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Service> res = new ArrayList<Service>();
        for (Service tb : in) {
            res.add(new ServiceBuilder(tb).createMinimized(minimization));
        }
        return res;
    }

    public static Service minimize(JsonLdObjectsMetaData.Minimization minimization, Service in) {
        if (in == null) {
            return null;
        }
        return new ServiceBuilder(in).createMinimized(minimization);
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class)
    public Server getServer() {
        return this.server;
    }

    public String getApi() {
        return this.api;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrn() {
        return this.urn;
    }
}

