/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Task.class)
public class TaskBuilder
extends PrimaryIdObjectBuilder<Long, Task, TaskBuilder> {
    private TestInstance testInstance;
    private Timestamp start;
    private Timestamp deadline;
    private Timestamp stop;
    private String log;
    private Long resultId;
    private URI resultUri;
    private String runInfo;
    private Task.State state;
    private boolean forceImplicitState = false;

    public TaskBuilder() {
    }

    public TaskBuilder(Task orig) {
        super(orig);
        this.testInstance = orig.getTestInstance();
        this.start = orig.getStart();
        this.deadline = orig.getDeadline();
        this.stop = orig.getStop();
        this.log = orig.getLog();
        this.resultId = orig.getResultId();
        this.resultUri = orig.getResult() != null ? orig.getResult().getUri() : null;
        this.runInfo = orig.getRunInfo();
        this.state = orig.getState();
    }

    public TaskBuilder setTestInstanceId(Integer testInstanceId) {
        this.setTestInstance(testInstanceId);
        return this;
    }

    public TaskBuilder setTestInstance(Integer testInstanceId) {
        this.testInstance = testInstanceId == null ? null : ((TestInstanceBuilder)new TestInstanceBuilder().setId(testInstanceId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        return this;
    }

    public TaskBuilder setTestInstance(Integer testInstanceId, URI testInstanceURI) {
        this.testInstance = testInstanceId == null && testInstanceURI == null ? null : ((TestInstanceBuilder)((TestInstanceBuilder)new TestInstanceBuilder().setId(testInstanceId)).setUri(testInstanceURI)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=TestInstance.class)
    public TaskBuilder setTestInstance(TestInstance testInstance) {
        this.testInstance = testInstance;
        return this;
    }

    public TaskBuilder setStart(Timestamp start) {
        this.start = start;
        return this;
    }

    public TaskBuilder setStart(Date start) {
        this.start = new Timestamp(start.getTime());
        return this;
    }

    public TaskBuilder setDeadline(Timestamp deadline) {
        this.deadline = deadline;
        return this;
    }

    public TaskBuilder setDeadline(Date deadline) {
        this.deadline = new Timestamp(deadline.getTime());
        return this;
    }

    public TaskBuilder setStop(Timestamp stop) {
        this.stop = stop;
        return this;
    }

    public TaskBuilder setStop(Date stop) {
        this.stop = new Timestamp(stop.getTime());
        return this;
    }

    public TaskBuilder setLog(String log) {
        this.log = log;
        return this;
    }

    public TaskBuilder setResult(Long resultId, URI resultUri) {
        this.resultId = resultId;
        this.resultUri = resultUri;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Result.class)
    public TaskBuilder setResult(Result result) {
        this.resultId = result == null ? null : (Long)result.getId();
        this.resultUri = result == null ? null : result.getUri();
        return this;
    }

    public TaskBuilder setRunInfo(String runInfo) {
        this.runInfo = runInfo;
        return this;
    }

    public TaskBuilder setState(Task.State state) {
        this.state = state;
        return this;
    }

    public TaskBuilder useImplicitState() {
        this.forceImplicitState = true;
        return this;
    }

    public TaskBuilder useImplicitState(boolean val) {
        this.forceImplicitState = val;
        return this;
    }

    public void processUseImplicitState() {
        if (!this.forceImplicitState) {
            return;
        }
        Result result = this.resultId == null ? null : ((ResultBuilder)((ResultBuilder)new ResultBuilder().setId(this.resultId)).setUri(this.resultUri)).create();
        Task tmp = new Task((Long)this.id, this.testInstance, this.start, this.deadline, this.stop, this.log, result, this.runInfo, this.state, this.uri);
        if (tmp.isExpired()) {
            this.state = Task.State.EXPIRED;
            if (this.stop == null) {
                this.stop = this.deadline;
            }
        }
        if (this.state == Task.State.CANCELLING && this.deadline.before(Clock.nowDate())) {
            this.state = Task.State.CANCELLED;
            if (this.stop == null) {
                this.stop = this.deadline;
            }
        }
    }

    @Override
    public Task create() {
        this.processUseImplicitState();
        Result result = this.resultId == null ? null : ((ResultBuilder)((ResultBuilder)new ResultBuilder().setId(this.resultId)).setUri(this.resultUri)).create();
        Task res = new Task((Long)this.id, this.testInstance, this.start, this.deadline, this.stop, this.log, result, this.runInfo, this.state, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
        return res;
    }

    @Override
    public Task createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        this.processUseImplicitState();
        Result result = this.resultId == null ? null : ((ResultBuilder)((ResultBuilder)new ResultBuilder().setId(this.resultId)).setUri(this.resultUri)).create();
        Task res = new Task(minimization.includeId() ? (Long)this.id : null, minimization.includeOtherProperties() || minimization.includeChildren() ? (this.testInstance == null ? null : new TestInstanceBuilder(this.testInstance).createMinimized(minimization.includeChildren() ? minimization.getChildrenMinimization() : JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)) : null, minimization.includeOtherProperties() ? this.start : null, minimization.includeOtherProperties() ? this.deadline : null, minimization.includeOtherProperties() ? this.stop : null, minimization.includeOtherProperties() ? this.log : null, minimization.includeOtherProperties() || minimization.includeChildren() ? (result == null ? null : new ResultBuilder(result).createMinimized(minimization.includeChildren() ? minimization.getChildrenMinimization() : JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)) : null, minimization.includeOtherProperties() ? this.runInfo : null, minimization.includeOtherProperties() ? this.state : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
        return res;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=TestInstance.class)
    public TestInstance getTestInstance() {
        return this.testInstance;
    }

    public Timestamp getStart() {
        return this.start;
    }

    public Timestamp getDeadline() {
        return this.deadline;
    }

    public Timestamp getStop() {
        return this.stop;
    }

    public String getLog() {
        return this.log;
    }

    public Long getResultId() {
        return this.resultId;
    }

    public URI getResultUri() {
        return this.resultUri;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Result.class)
    public Result getResult() {
        if (this.resultId == null) {
            return null;
        }
        return ((ResultBuilder)((ResultBuilder)new ResultBuilder().setId(this.resultId)).setUri(this.resultUri)).create();
    }

    public String getRunInfo() {
        return this.runInfo;
    }

    public Task.State getState() {
        return this.state;
    }
}

