/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionParameter;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="testdefinition", builderClass=TestDefinitionBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class TestDefinition
extends PrimaryIdObject<String> {
    private static final Logger LOG = LoggerFactory.getLogger(TestDefinition.class);
    private final String type;
    private final Long maxTestDurationMs;
    private final List<TestDefinitionParameter> parameters;
    private final String geniDatastoreMetric;
    private final String geniDatastoreDescription;
    private final String geniDatastoreUnits;
    private final URI testInstancesUri;

    @JsonCreator
    public TestDefinition(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="maxTestDurationMs") Long maxTestDurationMs, @JsonProperty(value="parameters") List<TestDefinitionParameter> parameters, @JsonProperty(value="geniDatastoreMetric") String geniDatastoreMetric, @JsonProperty(value="geniDatastoreDescription") String geniDatastoreDescription, @JsonProperty(value="geniDatastoreUnits") String geniDatastoreUnits, @JsonProperty(value="@id") URI uri, @JsonProperty(value="testInstances") URI testInstancesUri) {
        this(id, type, maxTestDurationMs, parameters, geniDatastoreMetric, geniDatastoreDescription, geniDatastoreUnits, uri, testInstancesUri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    TestDefinition(String id, String type, Long maxTestDurationMs, List<TestDefinitionParameter> parameters, String geniDatastoreMetric, String geniDatastoreDescription, String geniDatastoreUnits, URI uri, URI testInstancesUri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.type = type;
        this.maxTestDurationMs = maxTestDurationMs;
        this.geniDatastoreMetric = geniDatastoreMetric;
        this.geniDatastoreDescription = geniDatastoreDescription;
        this.geniDatastoreUnits = geniDatastoreUnits;
        this.parameters = TestDefinition.transformParameters(parameters == null ? null : Collections.unmodifiableList(parameters));
        this.testInstancesUri = testInstancesUri;
    }

    private static List<TestDefinitionParameter> transformParameters(List<TestDefinitionParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        if (parameters.isEmpty()) {
            return parameters;
        }
        boolean updateList = false;
        ArrayList<TestDefinitionParameter> newParameters = new ArrayList<TestDefinitionParameter>(parameters.size());
        for (TestDefinitionParameter parameter : parameters) {
            if (parameter.getName().equals(TestDefinition.getServerTestDefinitionParameter().getName()) && !parameter.equals(TestDefinition.getServerTestDefinitionParameter())) {
                updateList = true;
                parameter = TestDefinition.getServerTestDefinitionParameter();
                LOG.debug("Replaced server parameter with fixed version");
            }
            if (parameter.getName().equals(TestDefinition.getUserTestDefinitionParameter().getName()) && !parameter.equals(TestDefinition.getUserTestDefinitionParameter())) {
                updateList = true;
                parameter = TestDefinition.getUserTestDefinitionParameter();
                LOG.debug("Replaced user parameter with fixed version");
            }
            newParameters.add(parameter);
        }
        if (updateList) {
            return Collections.unmodifiableList(newParameters);
        }
        return parameters;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public Long getMaxTestDurationMs() {
        return this.maxTestDurationMs;
    }

    @JsonProperty
    public String getGeniDatastoreMetric() {
        return this.geniDatastoreMetric;
    }

    @JsonProperty
    public String getGeniDatastoreDescription() {
        return this.geniDatastoreDescription;
    }

    @JsonProperty
    public String getGeniDatastoreUnits() {
        return this.geniDatastoreUnits;
    }

    @JsonProperty
    public List<TestDefinitionParameter> getParameters() {
        return this.parameters;
    }

    @JsonIgnore
    public String getParametersAsJsonString() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return "[]";
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.parameters);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting TestDefinition parameters for TestDefinition " + (String)this.getId() + " to JSON", e);
            return "Exception converting TestDefinition parameters for TestDefinition " + (String)this.getId() + " to JSON: " + e.getMessage();
        }
    }

    @JsonIgnore
    public String getParametersWithoutUserAndServerAsJsonString() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return "[]";
        }
        HashSet<TestDefinitionParameter> usedParameters = new HashSet<TestDefinitionParameter>(this.parameters);
        usedParameters.remove(TestDefinition.getServerTestDefinitionParameter());
        usedParameters.remove(TestDefinition.getUserTestDefinitionParameter());
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(new ArrayList<TestDefinitionParameter>(usedParameters));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting TestDefinition parameters for TestDefinition " + (String)this.getId() + " to JSON", e);
            return "Exception converting TestDefinition parameters for TestDefinition " + (String)this.getId() + " to JSON: " + e.getMessage();
        }
    }

    @JsonProperty(value="testInstances")
    public URI getTestInstancesUri() {
        return this.testInstancesUri;
    }

    @JsonIgnore
    public boolean getHasUserParameter() {
        if (this.parameters == null) {
            return false;
        }
        for (TestDefinitionParameter parameter : this.parameters) {
            if (!parameter.equals(TestDefinition.getUserTestDefinitionParameter())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public boolean getHasServerParameter() {
        if (this.parameters == null) {
            return false;
        }
        for (TestDefinitionParameter parameter : this.parameters) {
            if (!parameter.equals(TestDefinition.getServerTestDefinitionParameter())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public TestDefinitionParameter getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        for (TestDefinitionParameter parameter : this.parameters) {
            if (parameter.getName() == null || !parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @JsonIgnore
    public String getParameterType(String name) {
        if (this.parameters == null) {
            return null;
        }
        for (TestDefinitionParameter parameter : this.parameters) {
            if (parameter.getName() == null || !parameter.getName().equals(name)) continue;
            return parameter.getType();
        }
        return null;
    }

    @JsonIgnore
    public String getParameterDescription(String name) {
        if (this.parameters == null) {
            return null;
        }
        for (TestDefinitionParameter parameter : this.parameters) {
            if (parameter.getName() == null || !parameter.getName().equals(name)) continue;
            return parameter.getDescription();
        }
        return null;
    }

    @JsonIgnore
    public Object getParameterDefault(String name) {
        if (this.parameters == null) {
            return null;
        }
        for (TestDefinitionParameter parameter : this.parameters) {
            if (parameter.getName() == null || !parameter.getName().equals(name)) continue;
            return parameter.getDefaultValue();
        }
        return null;
    }

    @JsonIgnore
    public String getStringParameterDefault(String name) {
        Object res = this.getParameterDefault(name);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            return (String)res;
        }
        if (res instanceof Number || res instanceof Boolean) {
            return "" + res;
        }
        throw new RuntimeException("\"" + name + "\" is not a String parameter, but a " + res.getClass().getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestDefinition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestDefinition that = (TestDefinition)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.maxTestDurationMs != null ? !this.maxTestDurationMs.equals(that.maxTestDurationMs) : that.maxTestDurationMs != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.geniDatastoreMetric != null ? !this.geniDatastoreMetric.equals(that.geniDatastoreMetric) : that.geniDatastoreMetric != null) {
            return false;
        }
        if (this.geniDatastoreDescription != null ? !this.geniDatastoreDescription.equals(that.geniDatastoreDescription) : that.geniDatastoreDescription != null) {
            return false;
        }
        if (this.geniDatastoreUnits != null ? !this.geniDatastoreUnits.equals(that.geniDatastoreUnits) : that.geniDatastoreUnits != null) {
            return false;
        }
        return this.testInstancesUri != null ? this.testInstancesUri.equals(that.testInstancesUri) : that.testInstancesUri == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.maxTestDurationMs != null ? this.maxTestDurationMs.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.geniDatastoreMetric != null ? this.geniDatastoreMetric.hashCode() : 0);
        result = 31 * result + (this.geniDatastoreDescription != null ? this.geniDatastoreDescription.hashCode() : 0);
        result = 31 * result + (this.geniDatastoreUnits != null ? this.geniDatastoreUnits.hashCode() : 0);
        result = 31 * result + (this.testInstancesUri != null ? this.testInstancesUri.hashCode() : 0);
        return result;
    }

    public static TestDefinitionParameter getServerTestDefinitionParameter() {
        return new TestDefinitionParameter("server", "server", "The target Server for this test", null, true);
    }

    public static TestDefinitionParameter getUserTestDefinitionParameter() {
        return new TestDefinitionParameter("user", "user", "The user providing the PEM login file containing the private key and certificate that are used for this test", null, true);
    }
}

