/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionParameter;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestDefinition.class)
public class TestDefinitionBuilder
extends PrimaryIdObjectBuilder<String, TestDefinition, TestDefinitionBuilder> {
    private String type;
    private Long maxTestDurationMs;
    private List<TestDefinitionParameter> parameters;
    private String geniDatastoreMetric;
    private String geniDatastoreDescription;
    private String geniDatastoreUnits;
    private URI testInstancesUri;

    public TestDefinitionBuilder() {
    }

    public TestDefinitionBuilder(TestDefinition orig) {
        super(orig);
        this.type = orig.getType();
        this.maxTestDurationMs = orig.getMaxTestDurationMs();
        this.parameters = orig.getParameters();
        this.testInstancesUri = orig.getTestInstancesUri();
        this.geniDatastoreMetric = orig.getGeniDatastoreMetric();
        this.geniDatastoreDescription = orig.getGeniDatastoreDescription();
        this.geniDatastoreUnits = orig.getGeniDatastoreUnits();
    }

    public TestDefinitionBuilder setTestInstancesUri(URI testInstancesUri) {
        this.testInstancesUri = testInstancesUri;
        return this;
    }

    public TestDefinitionBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public TestDefinitionBuilder setMaxTestDurationMs(Long maxTestDurationMs) {
        this.maxTestDurationMs = maxTestDurationMs;
        return this;
    }

    public TestDefinitionBuilder setGeniDatastoreMetric(String geniDatastoreMetric) {
        this.geniDatastoreMetric = geniDatastoreMetric;
        return this;
    }

    public TestDefinitionBuilder setGeniDatastoreDescription(String geniDatastoreDescription) {
        this.geniDatastoreDescription = geniDatastoreDescription;
        return this;
    }

    public TestDefinitionBuilder setGeniDatastoreUnits(String geniDatastoreUnits) {
        this.geniDatastoreUnits = geniDatastoreUnits;
        return this;
    }

    public TestDefinitionBuilder setParameters(List<TestDefinitionParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public TestDefinition create() {
        return new TestDefinition((String)this.id, this.type, this.maxTestDurationMs, this.parameters, this.geniDatastoreMetric, this.geniDatastoreDescription, this.geniDatastoreUnits, this.uri, this.testInstancesUri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    @Override
    public TestDefinition createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new TestDefinition(minimization.includeId() ? (String)this.id : null, minimization.includeOtherProperties() ? this.type : null, minimization.includeOtherProperties() ? this.maxTestDurationMs : null, minimization.includeOtherProperties() ? this.parameters : null, minimization.includeOtherProperties() ? this.geniDatastoreMetric : null, minimization.includeOtherProperties() ? this.geniDatastoreDescription : null, minimization.includeOtherProperties() ? this.geniDatastoreUnits : null, minimization.includeId() ? this.uri : null, minimization.includeOtherProperties() ? this.testInstancesUri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<TestDefinition> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<TestDefinition> in) {
        if (in == null) {
            return null;
        }
        ArrayList<TestDefinition> res = new ArrayList<TestDefinition>();
        for (TestDefinition tb : in) {
            res.add(new TestDefinitionBuilder(tb).createMinimized(minimization));
        }
        return res;
    }

    public static TestDefinition minimize(JsonLdObjectsMetaData.Minimization minimization, TestDefinition in) {
        if (in == null) {
            return null;
        }
        return new TestDefinitionBuilder(in).createMinimized(minimization);
    }

    public String getType() {
        return this.type;
    }

    public Long getMaxTestDurationMs() {
        return this.maxTestDurationMs;
    }

    public List<TestDefinitionParameter> getParameters() {
        return this.parameters;
    }

    public URI getTestInstancesUri() {
        return this.testInstancesUri;
    }

    public String getGeniDatastoreMetric() {
        return this.geniDatastoreMetric;
    }

    public String getGeniDatastoreDescription() {
        return this.geniDatastoreDescription;
    }

    public String getGeniDatastoreUnits() {
        return this.geniDatastoreUnits;
    }
}

