/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDefinitionParameter {
    private static final Logger LOG = LoggerFactory.getLogger(TestDefinitionParameter.class);
    private final String name;
    private final String type;
    private final String description;
    private final Object defaultValue;
    private final boolean nonNullValueRequired;

    @JsonCreator
    public TestDefinitionParameter(@Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="type") String type, @Nullable @JsonProperty(value="description") String description, @Nullable @JsonProperty(value="defaultValue") Object defaultValue, @JsonProperty(value="nonNullValueRequired") boolean nonNullValueRequired) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
        this.nonNullValueRequired = nonNullValueRequired;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.AnyFedmonObjectDeserializer.class)
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty
    public boolean isNonNullValueRequired() {
        return this.nonNullValueRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestDefinitionParameter)) {
            return false;
        }
        TestDefinitionParameter that = (TestDefinitionParameter)o;
        if (this.nonNullValueRequired != that.nonNullValueRequired) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.nonNullValueRequired ? 1 : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting TestDefinitionParameter to JSON", e);
            return "Exception converting TestDefinitionParameter to JSON: " + e.getMessage();
        }
    }
}

