/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfigBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="testemailconfig", builderClass=TestEmailConfigBuilder.class, uriType=JsonLdObjectsMetaData.UriType.NONE, idType=JsonLdObjectsMetaData.IdType.NONE)
public class TestEmailConfig
extends BasicLdObject {
    private static final Logger LOG = LoggerFactory.getLogger(TestEmailConfig.class);
    private final List<String> addresses;
    private final List<String> altAddresses;
    private final List<Trigger> triggers;
    private final Limits limits;

    @JsonCreator
    TestEmailConfig(@Nullable @JsonProperty(value="addresses") List<String> addresses, @Nullable @JsonProperty(value="altAddresses") List<String> altAddresses, @Nullable @JsonProperty(value="triggers") List<Trigger> triggers, @Nullable @JsonProperty(value="limits") Limits limits) {
        this.addresses = addresses == null ? null : Collections.unmodifiableList(addresses);
        this.altAddresses = altAddresses == null ? null : Collections.unmodifiableList(altAddresses);
        this.triggers = triggers == null ? null : Collections.unmodifiableList(triggers);
        this.limits = limits;
    }

    @Nullable
    @JsonProperty
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Nullable
    @JsonProperty
    public List<String> getAltAddresses() {
        return this.altAddresses;
    }

    @Nullable
    @JsonProperty
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    @Nullable
    @JsonProperty
    public Limits getLimits() {
        return this.limits;
    }

    @JsonIgnore
    public Trigger getTrigger(@Nonnull TestResultStatus requiredStatus, boolean onlyForFirst, boolean negate) {
        if (this.triggers == null) {
            return null;
        }
        for (Trigger trigger : this.triggers) {
            if (trigger.getRequiredStatus() == null || !trigger.getRequiredStatus().equals((Object)requiredStatus) || trigger.getOnlyForFirstOrDefault() != onlyForFirst || trigger.getNegationOrDefault() != negate) continue;
            return trigger;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestEmailConfig)) {
            return false;
        }
        TestEmailConfig that = (TestEmailConfig)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.altAddresses != null ? !this.altAddresses.equals(that.altAddresses) : that.altAddresses != null) {
            return false;
        }
        if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) {
            return false;
        }
        return this.limits != null ? this.limits.equals(that.limits) : that.limits == null;
    }

    public int hashCode() {
        int result = this.addresses != null ? this.addresses.hashCode() : 0;
        result = 31 * result + (this.altAddresses != null ? this.altAddresses.hashCode() : 0);
        result = 31 * result + (this.triggers != null ? this.triggers.hashCode() : 0);
        result = 31 * result + (this.limits != null ? this.limits.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting TestEmailConfig to JSON", e);
            return "Exception converting TestEmailConfig to JSON: " + e.getMessage();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Limits {
        private final Integer maxPerDay;
        private final Integer maxPerHour;

        public Limits(@Nullable @JsonProperty(value="maxPerDay") Integer maxPerDay, @Nullable @JsonProperty(value="maxPerHour") Integer maxPerHour) {
            this.maxPerDay = maxPerDay;
            this.maxPerHour = maxPerHour;
        }

        @Nullable
        @JsonProperty
        public Integer getMaxPerDay() {
            return this.maxPerDay;
        }

        @Nullable
        @JsonProperty
        public Integer getMaxPerHour() {
            return this.maxPerHour;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Limits)) {
                return false;
            }
            Limits limits = (Limits)o;
            if (this.maxPerDay != null ? !this.maxPerDay.equals(limits.maxPerDay) : limits.maxPerDay != null) {
                return false;
            }
            return this.maxPerHour != null ? this.maxPerHour.equals(limits.maxPerHour) : limits.maxPerHour == null;
        }

        public int hashCode() {
            int result = this.maxPerDay != null ? this.maxPerDay.hashCode() : 0;
            result = 31 * result + (this.maxPerHour != null ? this.maxPerHour.hashCode() : 0);
            return result;
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting Limits to JSON", e);
                return "Exception converting Limits to JSON: " + e.getMessage();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Trigger {
        @Nonnull
        private final TestResultStatus requiredStatus;
        private final Boolean onlyForFirst;
        private final Boolean negation;
        private final String repeatCron;
        private final String subject;
        private final String body;

        @JsonCreator
        public Trigger(@Nonnull @JsonProperty(value="requiredStatus") TestResultStatus requiredStatus, @Nullable @JsonProperty(value="onlyForFirst") Boolean onlyForFirst, @Nullable @JsonProperty(value="negation") Boolean negation, @Nullable @JsonProperty(value="repeatCron") String repeatCron, @Nullable @JsonProperty(value="subject") String subject, @Nullable @JsonProperty(value="body") String body) {
            this.requiredStatus = requiredStatus;
            this.onlyForFirst = onlyForFirst;
            this.negation = negation;
            this.repeatCron = repeatCron;
            this.subject = subject;
            this.body = body;
        }

        @Nonnull
        @JsonProperty
        public TestResultStatus getRequiredStatus() {
            return this.requiredStatus;
        }

        @Nullable
        @JsonProperty
        public Boolean getOnlyForFirst() {
            return this.onlyForFirst;
        }

        @Nullable
        @JsonProperty
        public String getRepeatCron() {
            return this.repeatCron;
        }

        @JsonIgnore
        public boolean getOnlyForFirstOrDefault() {
            return this.onlyForFirst == null ? false : this.onlyForFirst;
        }

        @Nullable
        @JsonProperty
        public Boolean getNegation() {
            return this.negation;
        }

        @JsonIgnore
        public boolean getNegationOrDefault() {
            return this.negation == null ? false : this.negation;
        }

        @Nullable
        @JsonProperty
        public String getSubject() {
            return this.subject;
        }

        @Nullable
        @JsonProperty
        public String getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Trigger)) {
                return false;
            }
            Trigger trigger = (Trigger)o;
            if (this.requiredStatus != trigger.requiredStatus) {
                return false;
            }
            if ((this.onlyForFirst != null ? !this.onlyForFirst.equals(trigger.onlyForFirst) : trigger.onlyForFirst != null) && (this.negation != null ? !this.negation.equals(trigger.negation) : trigger.negation != null)) {
                return false;
            }
            if (this.repeatCron != null ? !this.repeatCron.equals(trigger.repeatCron) : trigger.repeatCron != null) {
                return false;
            }
            if (this.subject != null ? !this.subject.equals(trigger.subject) : trigger.subject != null) {
                return false;
            }
            return this.body != null ? this.body.equals(trigger.body) : trigger.body == null;
        }

        public int hashCode() {
            int result = this.requiredStatus.hashCode();
            result = 31 * result + (this.onlyForFirst != null ? this.onlyForFirst.hashCode() : 0);
            result = 31 * result + (this.negation != null ? this.negation.hashCode() : 0);
            result = 31 * result + (this.repeatCron != null ? this.repeatCron.hashCode() : 0);
            result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
            result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
            return result;
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting Trigger to JSON", e);
                return "Exception converting Trigger to JSON: " + e.getMessage();
            }
        }
    }

    public static enum TestResultStatus {
        SUCCESS("Success"),
        WARNING("Warning"),
        FAILURE("Failure");

        @Nonnull
        private final String name;

        private TestResultStatus(String name) {
            this.name = name;
        }

        public boolean nameMatches(@Nonnull String n) {
            return this.name.equalsIgnoreCase(n);
        }

        @JsonCreator
        public static TestResultStatus forValue(String value) {
            if (value == null) {
                return null;
            }
            for (TestResultStatus testResultStatus : TestResultStatus.values()) {
                if (!testResultStatus.nameMatches(value)) continue;
                return testResultStatus;
            }
            throw new IllegalArgumentException("\"" + value + "\" is a bad value for TestResultStatus");
        }
    }
}

