/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessageBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="triggeredMessage", builderClass=TriggeredMessageBuilder.class, uriType=JsonLdObjectsMetaData.UriType.NONE, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class TriggeredMessage
extends BasicLdObject
implements JsonLdObjectWithId<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(TriggeredMessage.class);
    private final Integer id;
    private final GuiTrigger guiTrigger;
    private final Integer onlyTriggerForServer;
    private Boolean onlyTriggerOnProxyForJFedState;
    private Boolean onlyTriggerOnProxyForSshState;
    private final String title;
    private final String text;
    private final MessageType type;
    private final TriggerFrequency frequency;
    private final Boolean enableDoNotShowAgainButton;

    @JsonCreator
    public TriggeredMessage(@JsonProperty(value="id") Integer id, @JsonProperty(value="guiTrigger") GuiTrigger guiTrigger, @JsonProperty(value="onlyTriggerForServer") Integer onlyTriggerForServer, @JsonProperty(value="onlyTriggerOnProxyForJFedState") Boolean onlyTriggerOnProxyForJFedState, @JsonProperty(value="onlyTriggerOnProxyForSshState") Boolean onlyTriggerOnProxyForSshState, @JsonProperty(value="title") String title, @JsonProperty(value="text") String text, @JsonProperty(value="type") MessageType type, @JsonProperty(value="frequency") TriggerFrequency frequency, @JsonProperty(value="enableDoNotShowAgainButton") Boolean enableDoNotShowAgainButton) {
        this.id = id;
        this.guiTrigger = guiTrigger;
        this.onlyTriggerForServer = onlyTriggerForServer;
        this.onlyTriggerOnProxyForJFedState = onlyTriggerOnProxyForJFedState;
        this.onlyTriggerOnProxyForSshState = onlyTriggerOnProxyForSshState;
        this.text = text;
        this.type = type;
        this.title = title;
        this.frequency = frequency;
        this.enableDoNotShowAgainButton = enableDoNotShowAgainButton;
    }

    @Override
    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    @JsonProperty
    public GuiTrigger getGuiTrigger() {
        return this.guiTrigger;
    }

    @JsonProperty
    public Integer getOnlyTriggerForServer() {
        return this.onlyTriggerForServer;
    }

    @JsonProperty
    public Boolean getOnlyTriggerOnProxyForJFedState() {
        return this.onlyTriggerOnProxyForJFedState;
    }

    @JsonProperty
    public Boolean getOnlyTriggerOnProxyForSshState() {
        return this.onlyTriggerOnProxyForSshState;
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    public String getText() {
        return this.text;
    }

    @JsonProperty
    public MessageType getType() {
        return this.type;
    }

    @JsonProperty
    public TriggerFrequency getFrequency() {
        return this.frequency;
    }

    @JsonProperty
    public Boolean getEnableDoNotShowAgainButton() {
        return this.enableDoNotShowAgainButton;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggeredMessage that = (TriggeredMessage)o;
        if (this.enableDoNotShowAgainButton != null ? !this.enableDoNotShowAgainButton.equals(that.enableDoNotShowAgainButton) : that.enableDoNotShowAgainButton != null) {
            return false;
        }
        if (this.frequency != that.frequency) {
            return false;
        }
        if (this.guiTrigger != that.guiTrigger) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.onlyTriggerForServer != null ? !this.onlyTriggerForServer.equals(that.onlyTriggerForServer) : that.onlyTriggerForServer != null) {
            return false;
        }
        if (this.onlyTriggerOnProxyForJFedState != null ? !this.onlyTriggerOnProxyForJFedState.equals(that.onlyTriggerOnProxyForJFedState) : that.onlyTriggerOnProxyForJFedState != null) {
            return false;
        }
        if (this.onlyTriggerOnProxyForSshState != null ? !this.onlyTriggerOnProxyForSshState.equals(that.onlyTriggerOnProxyForSshState) : that.onlyTriggerOnProxyForSshState != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.guiTrigger != null ? this.guiTrigger.hashCode() : 0);
        result = 31 * result + (this.onlyTriggerForServer != null ? this.onlyTriggerForServer.hashCode() : 0);
        result = 31 * result + (this.onlyTriggerOnProxyForJFedState != null ? this.onlyTriggerOnProxyForJFedState.hashCode() : 0);
        result = 31 * result + (this.onlyTriggerOnProxyForSshState != null ? this.onlyTriggerOnProxyForSshState.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.frequency != null ? this.frequency.hashCode() : 0);
        result = 31 * result + (this.enableDoNotShowAgainButton != null ? this.enableDoNotShowAgainButton.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClassName() + " to JSON", e);
            return "Exception converting " + this.getClassName() + " to JSON: " + e.getMessage();
        }
    }

    public static enum GuiTrigger {
        LOGIN,
        DESIGN_EXPERIMENT,
        SELECT_SERVER,
        RUN_EXPERIMENT,
        RECOVER_EXPERIMENT,
        SSH_TERMINAL_START,
        EXIT;

    }

    public static enum MessageType {
        WARNING,
        ERROR,
        INFO;

    }

    public static enum TriggerFrequency {
        DAILY,
        ALWAYS,
        ONCE,
        ONCE_PER_SESSION;

    }
}

