/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfoBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.VersionInfo;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="userinfo", builderClass=UserInfoBuilder.class, uriType=JsonLdObjectsMetaData.UriType.NONE, idType=JsonLdObjectsMetaData.IdType.NONE)
public class UserInfo
extends BasicLdObject {
    private static final Logger LOG = LoggerFactory.getLogger(UserInfo.class);
    private final String urn;
    private final List<String> extra;
    private final VersionInfo version;

    @JsonCreator
    UserInfo(@JsonProperty(value="urn") String urn, @JsonProperty(value="extra") List<String> extra, @JsonProperty(value="version") VersionInfo version) {
        this.urn = urn;
        this.extra = extra == null ? extra : Collections.unmodifiableList(extra);
        this.version = version;
    }

    @JsonProperty
    public String getUrn() {
        return this.urn;
    }

    @JsonProperty
    public List<String> getExtra() {
        return this.extra;
    }

    @JsonProperty
    public VersionInfo getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Map<String, Object> getQueryParameters() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (this.getUrn() != null) {
            res.put("userurn", this.getUrn());
        }
        if (this.getExtra() != null && !this.getExtra().isEmpty()) {
            res.put("extra", String.join((CharSequence)",", this.getExtra()));
        }
        if (this.getVersion() != null) {
            VersionInfo version = this.getVersion();
            if (version.getArch() != null) {
                res.put("version-arch", version.getArch());
            }
            if (version.getJava() != null) {
                res.put("version-java", version.getJava());
            }
            if (version.getJavaVendor() != null) {
                res.put("version-java-vendor", version.getJavaVendor());
            }
            if (version.getJavaSpec() != null) {
                res.put("version-java-spec", version.getJavaSpec());
            }
            if (version.getjFed() != null) {
                res.put("version-jfed", version.getjFed());
            }
            if (version.getOs() != null) {
                res.put("version-os", version.getOs());
            }
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        if (this.extra != null ? !this.extra.equals(userInfo.extra) : userInfo.extra != null) {
            return false;
        }
        if (this.urn != null ? !this.urn.equals(userInfo.urn) : userInfo.urn != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(userInfo.version) : userInfo.version != null);
    }

    public int hashCode() {
        int result = this.urn != null ? this.urn.hashCode() : 0;
        result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting UserInfo to JSON", e);
            return "Exception converting UserInfo to JSON: " + e.getMessage();
        }
    }

    @Nonnull
    @JsonIgnore
    public String getAsJsonString() {
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting triggeredMessages into JSON", e);
            throw new RuntimeException("Exception converting triggeredMessages into JSON");
        }
    }
}

