/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.VersionInfo;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=UserInfo.class)
public class UserInfoBuilder
extends BasicLdObjectBuilder<UserInfo> {
    private String urn;
    private List<String> extra;
    private String versionJFed;
    private String versionJava;
    private String versionJavaVendor;
    private String versionJavaSpec;
    private String versionOs;
    private String versionArch;

    public UserInfoBuilder() {
    }

    public UserInfoBuilder(UserInfo orig) {
        super(orig);
        this.urn = orig.getUrn();
        this.extra = orig.getExtra();
        this.versionJFed = orig.getVersion() == null ? null : orig.getVersion().getjFed();
        this.versionJava = orig.getVersion() == null ? null : orig.getVersion().getJava();
        this.versionJavaVendor = orig.getVersion() == null ? null : orig.getVersion().getJavaVendor();
        this.versionJavaSpec = orig.getVersion() == null ? null : orig.getVersion().getJavaSpec();
        this.versionOs = orig.getVersion() == null ? null : orig.getVersion().getOs();
        this.versionArch = orig.getVersion() == null ? null : orig.getVersion().getArch();
    }

    @Nonnull
    public UserInfoBuilder setUrn(@Nullable GeniUrn urn) {
        this.urn = urn == null ? null : urn.toString();
        return this;
    }

    @Nonnull
    public UserInfoBuilder setUrn(@Nullable String urn) {
        this.urn = urn;
        return this;
    }

    @Nonnull
    public UserInfoBuilder setExtraFromCsvString(String extraCsv) {
        this.extra = extraCsv == null ? null : (extraCsv.trim().isEmpty() ? Collections.emptyList() : Arrays.asList(extraCsv.trim().split(",")).stream().map(String::trim).filter(s2 -> !s2.isEmpty()).collect(Collectors.toList()));
        return this;
    }

    @Nonnull
    public UserInfoBuilder setExtra(List<String> extra) {
        this.extra = extra;
        return this;
    }

    @Nonnull
    public UserInfoBuilder addExtra(String entry) {
        if (this.extra == null) {
            this.extra = new ArrayList<String>();
        }
        this.extra.add(entry);
        return this;
    }

    @Nonnull
    public UserInfoBuilder setVersionJFed(String versionJFed) {
        this.versionJFed = versionJFed;
        return this;
    }

    @Nonnull
    public UserInfoBuilder setVersionJava(String versionJava) {
        this.versionJava = versionJava;
        return this;
    }

    @Nonnull
    public UserInfoBuilder setVersionJavaVendor(String versionJavaVendor) {
        this.versionJavaVendor = versionJavaVendor;
        return this;
    }

    @Nonnull
    public UserInfoBuilder setVersionJavaSpec(String versionJavaSpec) {
        this.versionJavaSpec = versionJavaSpec;
        return this;
    }

    @Nonnull
    public UserInfoBuilder setVersionOs(String versionOs) {
        this.versionOs = versionOs;
        return this;
    }

    @Nonnull
    public UserInfoBuilder setVersionArch(String versionArch) {
        this.versionArch = versionArch;
        return this;
    }

    @Override
    @Nonnull
    public UserInfo create() {
        VersionInfo version = new VersionInfo(this.versionJFed, this.versionJava, this.versionJavaVendor, this.versionJavaSpec, this.versionOs, this.versionArch);
        return new UserInfo(this.urn, this.extra, version);
    }

    public String getUrn() {
        return this.urn;
    }

    public List<String> getExtra() {
        return this.extra;
    }

    public String getVersionJFed() {
        return this.versionJFed;
    }

    public String getVersionJava() {
        return this.versionJava;
    }

    public String getVersionJavaVendor() {
        return this.versionJavaVendor;
    }

    public String getVersionJavaSpec() {
        return this.versionJavaSpec;
    }

    public String getVersionOs() {
        return this.versionOs;
    }

    public String getVersionArch() {
        return this.versionArch;
    }
}

