/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionNumbers
implements Comparable<VersionNumbers> {
    private static final Logger LOG = LoggerFactory.getLogger(VersionNumbers.class);
    @Nonnull
    private final List<Integer> numbers = new ArrayList<Integer>();
    @Nullable
    private final String suffix;
    private static final Pattern pattern = Pattern.compile("([0-9]+)(\\.[0-9]+)?(\\.[0-9]+)?(-[A-Za-z0-9_]+)?");

    public VersionNumbers(@Nonnull String fullVersion) {
        Matcher matcher = pattern.matcher(fullVersion);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not a valid version number \"" + fullVersion + "\"");
        }
        int suffixGroupIndex = matcher.groupCount() - 1;
        int lastNumberGroupIndex = suffixGroupIndex - 1;
        String suffixMatch = matcher.group(suffixGroupIndex + 1);
        this.suffix = suffixMatch != null && !suffixMatch.isEmpty() ? suffixMatch.substring(1) : null;
        for (int i = 0; i <= lastNumberGroupIndex; ++i) {
            assert (i + 1 <= matcher.groupCount());
            String numberStr = matcher.group(i + 1);
            if (numberStr == null || numberStr.isEmpty()) continue;
            if (i > 0) {
                assert (numberStr.startsWith(".")) : "numberStr=\"" + numberStr + "\" does not start with .";
                numberStr = numberStr.substring(1);
            }
            Integer num = Integer.parseInt(numberStr);
            this.numbers.add(num);
        }
        assert (!this.numbers.isEmpty());
    }

    @NotNull
    public List<Integer> getNumbers() {
        return this.numbers;
    }

    @Nullable
    public String getSuffix() {
        return this.suffix;
    }

    public int getMajor() {
        return this.numbers.get(0);
    }

    @Nullable
    public Integer getMinor() {
        if (this.numbers.size() < 2) {
            return null;
        }
        return this.numbers.get(1);
    }

    @Nullable
    public Integer getFix() {
        if (this.numbers.size() < 3) {
            return null;
        }
        return this.numbers.get(2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionNumbers that = (VersionNumbers)o;
        if (!this.numbers.equals(that.numbers)) {
            return false;
        }
        return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
    }

    public int hashCode() {
        int result = this.numbers.hashCode();
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(@NotNull VersionNumbers o) {
        int ofix;
        int omin;
        if (o.getMajor() > this.getMajor()) {
            return -1;
        }
        if (o.getMajor() < this.getMajor()) {
            return 1;
        }
        int min2 = this.getMinor() == null ? -1 : this.getMinor();
        int n = omin = o.getMinor() == null ? -1 : o.getMinor();
        if (omin > min2) {
            return -1;
        }
        if (omin < min2) {
            return 1;
        }
        int fix = this.getFix() == null ? -1 : this.getFix();
        int n2 = ofix = o.getFix() == null ? -1 : o.getFix();
        if (ofix > fix) {
            return -1;
        }
        if (ofix < fix) {
            return 1;
        }
        if (this.getSuffix() == null && o.getSuffix() == null) {
            return 0;
        }
        if (this.getSuffix() == null && o.getSuffix() != null) {
            return -1;
        }
        if (o.getSuffix() == null && this.getSuffix() != null) {
            return 1;
        }
        return this.getSuffix().compareTo(o.getSuffix());
    }

    public boolean isGreaterThan(@NotNull VersionNumbers o) {
        return this.compareTo(o) > 0;
    }

    public boolean isLessThan(@NotNull VersionNumbers o) {
        return this.compareTo(o) < 0;
    }

    public boolean isGreaterThanOrEqual(@NotNull VersionNumbers o) {
        return this.compareTo(o) >= 0;
    }

    public boolean isLessThanOrEqual(@NotNull VersionNumbers o) {
        return this.compareTo(o) <= 0;
    }
}

