/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.GuiConfigSetDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.JFedExperimenterGuiConfigDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.JFedUserStatisticsDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceClassDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.UserConfigSetMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfoBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.VersionNumbers;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.codahale.metrics.annotation.Timed;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jersey.repackaged.com.google.common.cache.CacheBuilder;
import jersey.repackaged.com.google.common.cache.CacheLoader;
import jersey.repackaged.com.google.common.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/guiconfig")
@Produces(value={"application/json"})
@Singleton
public class JFedExperimenterGuiConfigResource {
    private static final Logger LOG = LoggerFactory.getLogger(JFedExperimenterGuiConfigResource.class);
    @Context
    UriInfo uriInfo;
    private final JFedExperimenterGuiConfigDao jFedExperimenterGuiConfigDao;
    private final UserConfigSetMappingDao userConfigSetMappingDao;
    private final GuiConfigSetDao guiConfigSetDao;
    private final ResourceClassDao resourceClassDao;
    private final ResourceDao resourceDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private final JFedUserStatisticsDao jFedUserStatisticsDao;
    LoadingCache<CacheKey, JFedExperimenterGuiConfig> guiConfigs = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(10L, TimeUnit.MINUTES).build(new CacheLoader<CacheKey, JFedExperimenterGuiConfig>(){

        @Override
        public JFedExperimenterGuiConfig load(CacheKey key) {
            return JFedExperimenterGuiConfigResource.this.uncachedGet(key.getUserInfoBuilder());
        }
    });
    private static final String WIRELESS_CHANNEL_ID_PREFIX = "wireless-channel";
    private static final String GEANT_TESTBED_ID_PREFIX = "geant-testbed";
    private static final String ADDRESS_POOL_ID_PREFIX = "address-pool";

    public JFedExperimenterGuiConfigResource(JFedExperimenterGuiConfigDao jFedExperimenterGuiConfigDao, UserConfigSetMappingDao userConfigSetMappingDao, GuiConfigSetDao guiConfigSetDao, ResourceClassDao resourceClassDao, ResourceDao resourceDao, FedmonWebApiServiceConfiguration configuration, JFedUserStatisticsDao jFedUserStatisticsLogger) {
        this.jFedExperimenterGuiConfigDao = jFedExperimenterGuiConfigDao;
        this.userConfigSetMappingDao = userConfigSetMappingDao;
        this.guiConfigSetDao = guiConfigSetDao;
        this.resourceClassDao = resourceClassDao;
        this.resourceDao = resourceDao;
        this.configuration = configuration;
        this.jFedUserStatisticsDao = jFedUserStatisticsLogger;
    }

    public void invalidateCache() {
        this.guiConfigs.invalidateAll();
    }

    @GET
    @Timed
    public JFedExperimenterGuiConfig get(@BeanParam AnnotatedUserInfoBuilder userInfoBuilder) {
        try {
            this.jFedUserStatisticsDao.logUserConfigRequest(userInfoBuilder.create());
        }
        catch (Exception e) {
            LOG.error("Ignoring error logging GET /userconfig", e);
        }
        return this.guiConfigs.getUnchecked(new CacheKey(userInfoBuilder));
    }

    private static boolean isNormalResourceClass(ResourceClass resourceClass) {
        if (resourceClass.getId() == null) {
            return true;
        }
        if (((String)resourceClass.getId()).startsWith(WIRELESS_CHANNEL_ID_PREFIX)) {
            return false;
        }
        if (((String)resourceClass.getId()).startsWith(GEANT_TESTBED_ID_PREFIX)) {
            return false;
        }
        return !((String)resourceClass.getId()).startsWith(ADDRESS_POOL_ID_PREFIX);
    }

    private static boolean isNormalResourceClass(ResourceClassBuilder resourceClass) {
        if (resourceClass.getId() == null) {
            return true;
        }
        if (((String)resourceClass.getId()).startsWith(WIRELESS_CHANNEL_ID_PREFIX)) {
            return false;
        }
        if (((String)resourceClass.getId()).startsWith(GEANT_TESTBED_ID_PREFIX)) {
            return false;
        }
        return !((String)resourceClass.getId()).startsWith(ADDRESS_POOL_ID_PREFIX);
    }

    private static boolean mustRemoveHardcodedIcons(UserInfo userInfo) {
        try {
            if (userInfo.getVersion() != null && userInfo.getVersion().getjFed() != null) {
                VersionNumbers versionNumbers = userInfo.getVersion().getjFedVersionNumbers();
                return versionNumbers == null || !versionNumbers.isGreaterThanOrEqual(new VersionNumbers("5.7.3"));
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while checking jFed version number (will be ignored)", e);
            return false;
        }
        return false;
    }

    private static boolean mustRemoveNewResourceFields(UserInfo userInfo) {
        try {
            if (userInfo.getVersion() != null && userInfo.getVersion().getjFed() != null) {
                VersionNumbers versionNumbers = userInfo.getVersion().getjFedVersionNumbers();
                return versionNumbers == null || !versionNumbers.isGreaterThanOrEqual(new VersionNumbers("5.8.1"));
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while checking jFed version number (will be ignored)", e);
            return false;
        }
        return false;
    }

    private List<Resource> modifyResources(List<Resource> resources, Consumer<ResourceBuilder> changer) {
        List<ResourceBuilder> builders = resources.stream().map(ResourceBuilder::new).collect(Collectors.toList());
        builders.forEach(changer);
        return builders.stream().map(ResourceBuilder::create).collect(Collectors.toList());
    }

    private List<ResourceBuilder> modifyResourceBuilders(List<ResourceBuilder> resources, Consumer<ResourceBuilder> changer) {
        resources.forEach(changer);
        return resources;
    }

    private ResourceClassBuilder modifyResources(ResourceClassBuilder resourceClassBuilder, Consumer<ResourceBuilder> changer) {
        if (resourceClassBuilder.getResources() != null && !resourceClassBuilder.getResources().isEmpty()) {
            resourceClassBuilder.setResources(this.modifyResources(resourceClassBuilder.getResources(), changer));
        }
        if (resourceClassBuilder.getResourceBuilders() != null && !resourceClassBuilder.getResourceBuilders().isEmpty()) {
            resourceClassBuilder.setResourceBuilders(this.modifyResourceBuilders(resourceClassBuilder.getResourceBuilders(), changer));
        }
        return resourceClassBuilder;
    }

    private ResourceClass modifyResources(ResourceClass resourceClass, Consumer<ResourceBuilder> changer) {
        ResourceClassBuilder resourceClassBuilder = new ResourceClassBuilder(resourceClass);
        if (resourceClassBuilder.getResources() != null && !resourceClassBuilder.getResources().isEmpty()) {
            resourceClassBuilder.setResources(this.modifyResources(resourceClassBuilder.getResources(), changer));
        }
        if (resourceClassBuilder.getResourceBuilders() != null && !resourceClassBuilder.getResourceBuilders().isEmpty()) {
            resourceClassBuilder.setResourceBuilders(this.modifyResourceBuilders(resourceClassBuilder.getResourceBuilders(), changer));
        }
        return resourceClassBuilder.create();
    }

    public JFedExperimenterGuiConfig uncachedGet(UserInfoBuilder userInfoBuilder) {
        UserInfo userInfo = userInfoBuilder.create();
        Collection<String> guiConfigSetIds = this.userInfoToGuiConfigSetIds(userInfo);
        LOG.debug("JFedExperimenterGuiConfig GET UserInfo translates to config sets: " + guiConfigSetIds);
        JFedExperimenterGuiConfigBuilder resBuilder = this.jFedExperimenterGuiConfigDao.getConfig(guiConfigSetIds);
        if (JFedExperimenterGuiConfigResource.mustRemoveHardcodedIcons(userInfo)) {
            if (resBuilder.getResourceClasses() != null) {
                resBuilder.setResourceClasses(resBuilder.getResourceClasses().stream().filter(JFedExperimenterGuiConfigResource::isNormalResourceClass).collect(Collectors.toSet()));
            }
            if (resBuilder.getResourceClassBuilders() != null) {
                resBuilder.setResourceClassBuilders(resBuilder.getResourceClassBuilders().stream().filter(JFedExperimenterGuiConfigResource::isNormalResourceClass).collect(Collectors.toSet()));
            }
        }
        if (JFedExperimenterGuiConfigResource.mustRemoveNewResourceFields(userInfo)) {
            Consumer<ResourceBuilder> changer = rb -> {
                rb.setAllowLinks(null);
                rb.setAllowStitchedLinks(null);
                rb.setAllowedLinkTypes(null);
                rb.setDefaultLinkType(null);
            };
            if (resBuilder.getResourceClassBuilders() != null) {
                resBuilder.setResourceClassBuilders(resBuilder.getResourceClassBuilders().stream().map(rc -> this.modifyResources((ResourceClassBuilder)rc, changer)).collect(Collectors.toSet()));
            }
            if (resBuilder.getResourceClasses() != null) {
                resBuilder.setResourceClasses(resBuilder.getResourceClasses().stream().map(rc -> this.modifyResources((ResourceClass)rc, changer)).collect(Collectors.toSet()));
            }
        }
        this.configuration.getUriTool().setUriRecursive(resBuilder);
        return resBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBED_ONLY_CHILDREN);
    }

    private Collection<String> userInfoToGuiConfigSetIds(UserInfo userInfo) {
        GeniUrn userUrn;
        TreeSet<String> res = new TreeSet<String>();
        if (userInfo.getExtra() != null) {
            res.addAll(userInfo.getExtra());
        }
        if ((userUrn = GeniUrn.parse(userInfo.getUrn())) != null) {
            String tla = userUrn.getEncodedTopLevelAuthority_withoutSubAuth();
            String username = userUrn.getEncodedResourceName();
            Collection<String> configSetsFromUserUrn = this.userConfigSetMappingDao.getGuiConfigSetIdFromUserUrn(tla, username);
            assert (configSetsFromUserUrn != null);
            if (configSetsFromUserUrn.isEmpty()) {
                LOG.warn("No configset found for user of authority \"" + tla + "\": " + userUrn);
            }
            res.addAll(configSetsFromUserUrn);
        }
        try {
            if (userInfo.getVersion() != null && userInfo.getVersion().getjFed() != null) {
                VersionNumbers versionNumbers = userInfo.getVersion().getjFedVersionNumbers();
                if (versionNumbers.isLessThan(new VersionNumbers("6.3.2"))) {
                    res.add("old-jfed-version-63");
                }
                if (versionNumbers.isLessThan(new VersionNumbers("6.4.4"))) {
                    res.add("new-jfed-version-available");
                }
                if (versionNumbers.isLessThan(new VersionNumbers("6.4.7"))) {
                    res.add("jfed-version-older-6-4-7");
                }
                if (versionNumbers.isGreaterThanOrEqual(new VersionNumbers("5.7.4"))) {
                    res.add("espec");
                    res.add("docker");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while checking jFed version number (will be ignored)", e);
        }
        return res;
    }

    public static class AnnotatedUserInfoBuilder
    extends UserInfoBuilder {
        public AnnotatedUserInfoBuilder() {
        }

        public AnnotatedUserInfoBuilder(UserInfo orig) {
            super(orig);
        }

        @Override
        @QueryParam(value="userurn")
        public AnnotatedUserInfoBuilder setUrn(String urn) {
            return (AnnotatedUserInfoBuilder)super.setUrn(urn);
        }

        @Override
        @QueryParam(value="extra")
        public AnnotatedUserInfoBuilder setExtraFromCsvString(String extraCsv) {
            return (AnnotatedUserInfoBuilder)super.setExtraFromCsvString(extraCsv);
        }

        @Override
        @QueryParam(value="version-jfed")
        public AnnotatedUserInfoBuilder setVersionJFed(String versionJFed) {
            return (AnnotatedUserInfoBuilder)super.setVersionJFed(versionJFed);
        }

        @Override
        @QueryParam(value="version-java")
        public AnnotatedUserInfoBuilder setVersionJava(String versionJava) {
            return (AnnotatedUserInfoBuilder)super.setVersionJava(versionJava);
        }

        @Override
        @QueryParam(value="version-java-vendor")
        public AnnotatedUserInfoBuilder setVersionJavaVendor(String versionJavaVendor) {
            return (AnnotatedUserInfoBuilder)super.setVersionJavaVendor(versionJavaVendor);
        }

        @Override
        @QueryParam(value="version-java-spec")
        public AnnotatedUserInfoBuilder setVersionJavaSpec(String versionJavaSpec) {
            return (AnnotatedUserInfoBuilder)super.setVersionJavaSpec(versionJavaSpec);
        }

        @Override
        @QueryParam(value="version-os")
        public AnnotatedUserInfoBuilder setVersionOs(String versionOs) {
            return (AnnotatedUserInfoBuilder)super.setVersionOs(versionOs);
        }

        @Override
        @QueryParam(value="version-arch")
        public AnnotatedUserInfoBuilder setVersionArch(String versionArch) {
            return (AnnotatedUserInfoBuilder)super.setVersionArch(versionArch);
        }
    }

    private static class CacheKey {
        @Nullable
        private final String userTld;
        @Nullable
        private final List<String> extra;
        private final boolean mustRemoveHardcoded;
        private final boolean mustRemoveResourceFields;
        @Nullable
        private final VersionNumbers jFedVersion;
        @Nonnull
        private UserInfoBuilder userInfoBuilder;

        public CacheKey(@Nonnull UserInfoBuilder userInfo) {
            VersionNumbers jFedVersionNumber;
            GeniUrn urn = GeniUrn.parse(userInfo.getUrn());
            this.userTld = urn == null ? null : urn.getEncodedTopLevelAuthority();
            this.extra = userInfo.getExtra();
            this.userInfoBuilder = userInfo;
            this.mustRemoveHardcoded = JFedExperimenterGuiConfigResource.mustRemoveHardcodedIcons(userInfo.create());
            this.mustRemoveResourceFields = JFedExperimenterGuiConfigResource.mustRemoveNewResourceFields(userInfo.create());
            try {
                jFedVersionNumber = userInfo.create().getVersion().getjFedVersionNumbers();
            }
            catch (Exception e) {
                LOG.warn("Exception while checking jFed version number (will be ignored)", e);
                jFedVersionNumber = null;
            }
            this.jFedVersion = jFedVersionNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.mustRemoveHardcoded != cacheKey.mustRemoveHardcoded) {
                return false;
            }
            if (this.mustRemoveResourceFields != cacheKey.mustRemoveResourceFields) {
                return false;
            }
            if (this.userTld != null ? !this.userTld.equals(cacheKey.userTld) : cacheKey.userTld != null) {
                return false;
            }
            if (this.extra != null ? !this.extra.equals(cacheKey.extra) : cacheKey.extra != null) {
                return false;
            }
            return this.jFedVersion != null ? this.jFedVersion.equals(cacheKey.jFedVersion) : cacheKey.jFedVersion == null;
        }

        public int hashCode() {
            int result = this.userTld != null ? this.userTld.hashCode() : 0;
            result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
            result = 31 * result + (this.mustRemoveHardcoded ? 1 : 0);
            result = 31 * result + (this.mustRemoveResourceFields ? 1 : 0);
            result = 31 * result + (this.jFedVersion != null ? this.jFedVersion.hashCode() : 0);
            return result;
        }

        @Nonnull
        public UserInfoBuilder getUserInfoBuilder() {
            return this.userInfoBuilder;
        }
    }
}

