/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ProxyDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ProxyBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/proxy")
@Produces(value={"application/json"})
public class ProxyResource {
    @Context
    UriInfo uriInfo;
    private final ProxyDao proxyDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public ProxyResource(ProxyDao proxyDAO, FedmonWebApiServiceConfiguration configuration) {
        this.proxyDAO = proxyDAO;
        this.configuration = configuration;
    }

    @GET
    @Timed
    public List<Proxy> getAll() {
        List<Proxy> resBase = this.proxyDAO.getAll();
        ArrayList<Proxy> res = new ArrayList<Proxy>();
        for (Proxy tc : resBase) {
            ProxyBuilder proxyBuilder = new ProxyBuilder(tc);
            proxyBuilder = this.addUris(proxyBuilder);
            res.add(this.createMinimized(proxyBuilder));
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Proxy get(@NotNull @PathParam(value="id") Integer id) {
        Proxy res = this.proxyDAO.get(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        ProxyBuilder proxyBuilder = new ProxyBuilder(res);
        proxyBuilder = this.addUris(proxyBuilder);
        return this.createMinimized(proxyBuilder);
    }

    private Proxy createMinimized(ProxyBuilder proxyBuilder) {
        return proxyBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    public ProxyBuilder addUris(ProxyBuilder orig) {
        assert (this.uriInfo != null);
        assert (orig != null);
        assert (orig.getId() != null);
        return this.configuration.getUriTool().setUriRecursive(orig);
    }
}

