/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.JFedExperimenterGuiConfigResource;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resource")
@Produces(value={"application/json"})
public class ResourceResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceResource.class);
    @Context
    UriInfo uriInfo;
    private final ResourceDao resourceDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private final JFedExperimenterGuiConfigResource jFedExperimenterGuiConfigResource;

    public ResourceResource(ResourceDao resourceDao, FedmonWebApiServiceConfiguration configuration, JFedExperimenterGuiConfigResource jFedExperimenterGuiConfigResource) {
        this.resourceDao = resourceDao;
        this.configuration = configuration;
        this.jFedExperimenterGuiConfigResource = jFedExperimenterGuiConfigResource;
    }

    @GET
    @Timed
    public List<Resource> search(@Context HttpServletRequest request, @Nullable @QueryParam(value="serverId") Integer serverId) {
        if (serverId != null) {
            return this.findByServerId(request, serverId);
        }
        return this.all(request);
    }

    public List<Resource> all(HttpServletRequest request) {
        List<ResourceBuilder> resBase = this.resourceDao.findAll();
        if (resBase == null) {
            return Collections.emptyList();
        }
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (ResourceBuilder rb : resBase) {
            rb = this.configuration.getUriTool().setUriRecursive(rb, false);
            res.add(rb.create());
        }
        return res;
    }

    public List<Resource> findByServerId(HttpServletRequest request, Integer serverId) {
        List<ResourceBuilder> resBase = this.resourceDao.findByServerId(serverId);
        if (resBase == null) {
            return Collections.emptyList();
        }
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (ResourceBuilder rb : resBase) {
            rb = this.configuration.getUriTool().setUriRecursive(rb, false);
            res.add(rb.create());
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Resource get(@NotNull @PathParam(value="id") Integer id) {
        ResourceBuilder resBuilder = this.resourceDao.findById(id);
        if (resBuilder == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        resBuilder = this.configuration.getUriTool().setUriRecursive(resBuilder, false);
        return resBuilder.create();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Resource insert(@NotNull Resource resource, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        Integer newId = this.resourceDao.insert(resource);
        if (newId == null) {
            throw new RuntimeException("Exception inserting resource");
        }
        ResourceBuilder res = new ResourceBuilder(resource);
        res.setId(newId);
        if (res.getAllowedSliverTypes() == null) {
            res.setAllowedSliverTypes(Collections.emptyList());
        }
        if (res.getAllowedSliverTypes().isEmpty() && res.getSliverType() != null) {
            res.setAllowedSliverTypes(Collections.singletonList(res.getSliverType()));
        }
        this.jFedExperimenterGuiConfigResource.invalidateCache();
        return res.create();
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull Integer id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.resourceDao.delete(id);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Resource update(@NotNull @PathParam(value="id") Integer id, Resource resource, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (resource.getId() == null || !((Integer)resource.getId()).equals(id)) {
            throw new WebApplicationException("ID of provided Resource differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        this.resourceDao.update(resource);
        this.jFedExperimenterGuiConfigResource.invalidateCache();
        return this.get(id);
    }
}

