/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.AdminDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FrequencyDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResultDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TaskDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestDefinitionDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceStatisticsDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.UserDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdminBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.logic.FedmonLogic;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.ResourceCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.TestbedResource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.util.EmailSender;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/result")
@Produces(value={"application/json"})
public class ResultResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResultResource.class);
    @Context
    UriInfo uriInfo;
    private final AdminDao adminDao;
    private final TaskDao taskDao;
    private final ResultDao resultDAO;
    private final TestInstanceDao testInstanceDao;
    private final TestInstanceStatisticsDao testInstanceStatisticsDao;
    private final UserDao userDao;
    private final FrequencyDao frequencyDao;
    private final TestDefinitionDao testDefinitionDao;
    private final TestbedResource testbedResource;
    private final FedmonWebApiServiceConfiguration configuration;
    private final EmailSender emailSender;

    public ResultResource(TaskDao taskDao, ResultDao resultDAO, TestInstanceDao testInstanceDao, TestInstanceStatisticsDao testInstanceStatisticsDao, FrequencyDao frequencyDao, TestDefinitionDao testDefinitionDao, AdminDao adminDao, UserDao userDao, TestbedResource testbedResource, FedmonWebApiServiceConfiguration configuration, EmailSender emailSender) {
        this.adminDao = adminDao;
        this.taskDao = taskDao;
        this.resultDAO = resultDAO;
        this.testInstanceDao = testInstanceDao;
        this.testInstanceStatisticsDao = testInstanceStatisticsDao;
        this.frequencyDao = frequencyDao;
        this.testDefinitionDao = testDefinitionDao;
        this.userDao = userDao;
        this.testbedResource = testbedResource;
        this.configuration = configuration;
        this.emailSender = emailSender;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Result createResultAndDeleteTask(@NotNull Result result, @Context HttpServletRequest request) {
        User user;
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        LOG.debug("createResultAndDeleteTask() called with result=" + result);
        if (result.getTestInstanceId() == null) {
            throw new BadRequestException("Result does not have a testinstanceid");
        }
        if (result.getSummary() == null) {
            throw new BadRequestException("Result does not have a summary");
        }
        if (result.getCreated() == null) {
            throw new BadRequestException("Result does not have a timestamp");
        }
        Date now = Clock.nowDate();
        TestInstance testInstance = this.testInstanceDao.findById(result.getTestInstanceId());
        Frequency testInstanceFrequency = testInstance.getFrequencyId() == null ? null : this.frequencyDao.findById(testInstance.getFrequencyId());
        TestDefinition testDefinition = this.testDefinitionDao.findById(testInstance.getTestDefinitionId());
        User user2 = user = testInstance.getUserParameter() == null ? null : this.userDao.findById(testInstance.getUserIdParameter());
        if (user != null && Objects.equals(user.getSelfTestFailed(), Boolean.TRUE) && !Objects.equals(testInstance.getSelfTestImmune(), Boolean.TRUE)) {
            this.taskDao.updateState(result.getTaskId(), Task.State.CANCELLED, new Timestamp(now.getTime()));
            throw new WebApplicationException("Self test for user has failed. Result was not committed.", Response.Status.RESET_CONTENT);
        }
        Date resultReceivedDate = now;
        FedmonLogic.NextRunAndExpire nextRunAndExpire = null;
        try {
            nextRunAndExpire = FedmonLogic.calculateResultNextRunAndExpire(result, testInstance, testInstanceFrequency, testDefinition, resultReceivedDate);
        }
        catch (Exception e) {
            LOG.error("Exception while calculating expire and nextRun. (This is bad!)", e);
            Admin adminInfo = this.adminDao.get();
            Admin updatedAdminInfo = new AdminBuilder(adminInfo).setDisableAllTests(true).create();
            LOG.warn("SAFETY BRAKE: will stop ALL tests now.");
            this.adminDao.update(adminInfo);
            String message = "MAJOR BUG: Stopped all tests!\n\nException while calculating expire and nextRun. This is bad! Safety brake activated: stopped all tests.\n\nStacktrace:\n" + IOUtils.exceptionToStacktraceString(e) + "\n";
            this.emailSender.sendToAdmin("MAJOR BUG: Stopped all tests!", message);
            throw e;
        }
        if (nextRunAndExpire.getExpire() == null && result.getExpire() != null) {
            LOG.debug("Expire could not be calculated, but Result has expire info, so we'll use that.");
            nextRunAndExpire = new FedmonLogic.NextRunAndExpire(result.getExpire(), nextRunAndExpire.getNextRun());
        }
        ResultBuilder commitedResult = new ResultBuilder(result);
        Long resultId = null;
        try {
            resultId = this.resultDAO.insert(commitedResult.create(), nextRunAndExpire.getExpire(), nextRunAndExpire.getNextRun());
        }
        catch (TransactionFailedException e) {
            if (e.getCause() instanceof ResultDao.ResultInsertException) {
                throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.CONFLICT);
            }
            throw e;
        }
        catch (ResultDao.ResultInsertException e) {
            throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.CONFLICT);
        }
        LOG.debug("createResultAndDeleteTask created result " + resultId);
        if (result.getTaskId() != null) {
            if (resultId != null) {
                LOG.debug("createResultAndDeleteTask is updating task " + result.getTaskId() + " with result " + resultId);
                this.taskDao.setResult(result.getTaskId(), resultId);
            } else {
                return null;
            }
        }
        boolean debugHack = testInstance.getId() != null && (((Integer)testInstance.getId()).equals(7) || ((Integer)testInstance.getId()).equals(135));
        try {
            FedmonWebApiServiceConfiguration rrdConfig = this.configuration;
            RrdManager rrdManager = new RrdManager(rrdConfig);
            List<TestInstanceRrd> testInstanceRrds = rrdManager.get(testInstance, testInstanceFrequency, testDefinition, false);
            if (testInstanceRrds != null) {
                long startTime = System.currentTimeMillis();
                if (testInstanceRrds.isEmpty()) {
                    LOG.debug("testInstanceRrds.isEmpty()");
                    if (debugHack) {
                        LOG.info("ResultResource RRD handling debugHack ti={} testInstanceRrds.isEmpty()", testInstance.getId());
                    }
                }
                for (TestInstanceRrd testInstanceRrd : testInstanceRrds) {
                    if (debugHack) {
                        LOG.info("ResultResource RRD handling debugHack ti={} handling TestInstanceRrd type={} class={} enabled={} td.id={} td.type={}", testInstance.getId(), testInstanceRrd == null ? "NULL" : testInstanceRrd.getType(), testInstanceRrd == null ? "NULL" : testInstanceRrd.getClass().getName(), testInstanceRrd == null ? "NULL" : Boolean.valueOf(testInstanceRrd.isEnabled()), testDefinition.getId(), testDefinition.getType());
                    }
                    if (testInstanceRrd != null && testInstanceRrd.isEnabled()) {
                        LOG.debug("Handling RRD");
                        if (!testInstanceRrd.exists()) {
                            testInstanceRrd.create();
                        }
                        testInstanceRrd.insert(commitedResult.create());
                        LOG.debug("updating statistics in TestInstance if needed");
                        TestInstanceStatistics.RrdStatistics updatedStatistics = testInstanceRrd.getTestStatistics();
                        if (updatedStatistics != null) {
                            String testStatisticsJsonText = new ObjectMapper().writeValueAsString(updatedStatistics);
                            this.testInstanceStatisticsDao.updateTestStatistics((Integer)testInstance.getId(), testStatisticsJsonText);
                            if (debugHack) {
                                LOG.info("ResultResource RRD handling debugHack ti={} updated statistics: {}", testInstance.getId(), (Object)testStatisticsJsonText);
                            }
                        } else if (debugHack) {
                            LOG.info("ResultResource RRD handling debugHack ti={} updatedStatistics == null", testInstance.getId());
                        }
                        LOG.debug("updating summation in TestInstance if needed");
                        TestInstanceStatistics.Summation updatedSummation = testInstanceRrd.getSummation();
                        if (updatedSummation != null) {
                            String summationJsonText = new ObjectMapper().writeValueAsString(updatedSummation);
                            this.testInstanceStatisticsDao.updateSummation((Integer)testInstance.getId(), summationJsonText);
                        }
                        long stopTime = System.currentTimeMillis();
                        LOG.debug("Handled RRD update in " + (stopTime - startTime) + " ms");
                        if (!debugHack) continue;
                        LOG.info("ResultResource RRD handling debugHack ti={} Handled RRD update in " + (stopTime - startTime) + " ms", testInstance.getId());
                        continue;
                    }
                    if (testInstanceRrd != null) {
                        LOG.debug("testInstanceRrd.isEnabled() == " + testInstanceRrd.isEnabled());
                        if (!debugHack) continue;
                        LOG.info("ResultResource RRD handling debugHack ti={} a testInstanceRrd.isEnabled() == {}", testInstance.getId(), (Object)testInstanceRrd.isEnabled());
                        continue;
                    }
                    LOG.debug("testInstanceRrd == null");
                    if (!debugHack) continue;
                    LOG.info("ResultResource RRD handling debugHack ti={} a testInstanceRrd == null", testInstance.getId());
                }
            } else if (debugHack) {
                LOG.info("ResultResource RRD handling debugHack ti={} testInstanceRrds == null", testInstance.getId());
            } else {
                LOG.debug("testInstanceRrds == null");
            }
        }
        catch (Throwable e) {
            if (debugHack) {
                LOG.info("ResultResource RRD handling debugHack ti={} Something went wrong trying to update RDD. Will ignore that.", testInstance.getId());
            }
            LOG.error("Something went wrong trying to update RDD. Will ignore that.", e);
        }
        UriBuilder ub = this.uriInfo.getAbsolutePathBuilder();
        URI uri = ub.path("" + resultId).build(new Object[0]);
        Result res = ((ResultBuilder)((ResultBuilder)new ResultBuilder().setId(resultId)).setUri(uri)).create();
        return res;
    }

    private Result embedParentLinks(Result orig) {
        if (orig == null) {
            return null;
        }
        if (orig.getTestInstanceId() == null) {
            return orig;
        }
        ResultBuilder resultBuilder = new ResultBuilder(orig);
        if (resultBuilder.getTestInstance() == null) {
            return orig;
        }
        TestInstanceBuilder testInstanceBuilder = new TestInstanceBuilder(resultBuilder.getTestInstance());
        if (testInstanceBuilder.getTestDefinition() != null) {
            TestDefinitionBuilder testDefinitionBuilder = new TestDefinitionBuilder(testInstanceBuilder.getTestDefinition());
            testInstanceBuilder.setTestDefinition(testDefinitionBuilder.create());
        }
        if (testInstanceBuilder.getServerParameter() != null) {
            ServerBuilder serverBuilder = new ServerBuilder(testInstanceBuilder.getServerParameter());
            testInstanceBuilder.setServerParameter(serverBuilder.create());
        }
        resultBuilder.setTestInstance(testInstanceBuilder.create());
        resultBuilder.setTestInstance(testInstanceBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL));
        return resultBuilder.create();
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Result get(@NotNull @PathParam(value="id") Long id, @QueryParam(value="embed") Boolean embed) {
        assert (id != null);
        Result res = this.resultDAO.findById(id);
        if (embed != null && embed.booleanValue()) {
            res = this.embedParentLinks(res);
        }
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        return this.addUris(this.uriInfo, res);
    }

    @GET
    @Timed
    public List<Result> search(@QueryParam(value="last") String last, @QueryParam(value="testinstanceid") String testInstanceIds, @QueryParam(value="testversionname") String testVersionNames, @QueryParam(value="testdefinitionname") String testDefinitionNames, @QueryParam(value="testbedcategory") String testbedCategories, @QueryParam(value="testname") String testInstanceNames, @QueryParam(value="testbed") String testbedNames, @QueryParam(value="server") String serverIds, @QueryParam(value="testbed_urn") String testbedUrnNames, @QueryParam(value="geni_testbed") String testbedGeniNames, @QueryParam(value="summary") String summaries, @QueryParam(value="enabled") String enabledParam, @QueryParam(value="disabled") String disabledParam, @QueryParam(value="expired") String expiredParam, @QueryParam(value="cancelled_excluded") String cancelledExcludedParam, @QueryParam(value="cancelled_included") String cancelledIncludedParam, @QueryParam(value="from") Date from, @QueryParam(value="till") Date till, @QueryParam(value="embed") Boolean embed) {
        List<Result> baseRes;
        Boolean tmp;
        int lastParamIntValue;
        boolean lastParamIsMultiLast;
        boolean lastParamIsSingleLast;
        boolean lastParamSet;
        if (last != null) {
            lastParamSet = true;
            if (last.trim().isEmpty()) {
                lastParamIsSingleLast = true;
                lastParamIsMultiLast = false;
                lastParamIntValue = 1;
            } else {
                Boolean truthRes = TextUtil.stringToBoolean(last);
                if (truthRes != null) {
                    lastParamSet = truthRes;
                    lastParamIsSingleLast = truthRes;
                    lastParamIsMultiLast = false;
                    lastParamIntValue = truthRes != false ? 1 : -1;
                } else {
                    try {
                        lastParamIntValue = Integer.parseInt(last);
                        lastParamIsMultiLast = true;
                        lastParamIsSingleLast = false;
                    }
                    catch (NumberFormatException e) {
                        throw new WebApplicationException("last parameter is not understood: \"" + last + "\"", Response.Status.BAD_REQUEST);
                    }
                }
            }
        } else {
            lastParamSet = false;
            lastParamIsSingleLast = false;
            lastParamIsMultiLast = false;
            lastParamIntValue = -1;
        }
        List<Integer> testInstanceIdFilter = ResourceCommon.parseIntListArg(testInstanceIds);
        List<String> versionNameFilter = ResourceCommon.parseArg(testVersionNames);
        List<String> testInstanceNameFilter = ResourceCommon.parseArg(testInstanceNames);
        List<String> testDefinitionNameFilter = ResourceCommon.parseArg(testDefinitionNames);
        List<String> testbedCategoryFilter = ResourceCommon.parseArg(testbedCategories);
        List<String> testbedGeniNameFilter = ResourceCommon.parseArg(testbedGeniNames);
        List<String> testbedUrnFilter = ResourceCommon.parseArg(testbedUrnNames);
        List<String> testbedNameFilter = ResourceCommon.parseArg(testbedNames);
        List<Integer> serverIdFilter = ResourceCommon.parseIntListArg(serverIds);
        if (disabledParam != null && enabledParam != null && ResourceCommon.parameterTruth(disabledParam) == ResourceCommon.parameterTruth(enabledParam)) {
            throw new WebApplicationException("disabled and enabled query parameter conflict", Response.Status.BAD_REQUEST);
        }
        Boolean disabled = disabledParam == null ? ((tmp = ResourceCommon.parameterTruthOrNull(enabledParam)) == null ? null : Boolean.valueOf(tmp == false)) : ResourceCommon.parameterTruthOrNull(disabledParam);
        ResultDao.CancelledTestResultIncluded cancelledIncluded = ResultDao.CancelledTestResultIncluded.INCLUDED;
        if (cancelledExcludedParam != null && cancelledIncludedParam != null && Objects.equals(cancelledExcludedParam, cancelledIncludedParam)) {
            LOG.error("cancelled_excluded (" + cancelledExcludedParam + ") contradicts cancelled_included (" + cancelledIncludedParam + ")");
            throw new WebApplicationException("cancelled_excluded contradicts cancelled_included", Response.Status.BAD_REQUEST);
        }
        if (cancelledExcludedParam != null) {
            ResultDao.CancelledTestResultIncluded cancelledTestResultIncluded = cancelledIncluded = ResourceCommon.parameterTruth(cancelledExcludedParam) ? ResultDao.CancelledTestResultIncluded.EXCLUDED : ResultDao.CancelledTestResultIncluded.INCLUDED;
        }
        if (cancelledIncludedParam != null) {
            cancelledIncluded = ResourceCommon.parameterTruth(cancelledIncludedParam) ? ResultDao.CancelledTestResultIncluded.INCLUDED : ResultDao.CancelledTestResultIncluded.EXCLUDED;
        }
        Boolean expired = ResourceCommon.parameterTruthOrNull(expiredParam);
        List<String> summary = ResourceCommon.parseArg(summaries);
        boolean mustBeHistory = false;
        boolean mustBeLast = false;
        boolean noSummary = false;
        if (testInstanceIdFilter == null || testInstanceIdFilter.size() != 1) {
            mustBeLast = true;
        }
        if (!ResourceCommon.empty(versionNameFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (!ResourceCommon.empty(testInstanceNameFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (!ResourceCommon.empty(testDefinitionNameFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (!ResourceCommon.empty(testbedCategoryFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (!ResourceCommon.empty(testbedGeniNameFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (!ResourceCommon.empty(testbedUrnFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (!ResourceCommon.empty(testbedNameFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (!ResourceCommon.empty(serverIdFilter)) {
            mustBeLast = true;
            noSummary = true;
        }
        if (disabled != null) {
            mustBeLast = true;
            noSummary = true;
        }
        if (cancelledIncluded == ResultDao.CancelledTestResultIncluded.EXCLUDED) {
            mustBeLast = true;
            noSummary = true;
        }
        if (expired != null) {
            mustBeLast = true;
        }
        if (!ResourceCommon.empty(summary)) {
            mustBeLast = true;
        }
        if (from != null) {
            mustBeHistory = true;
            noSummary = true;
        }
        if (till != null) {
            mustBeHistory = true;
            noSummary = true;
        }
        if (!lastParamSet || lastParamIsMultiLast) {
            mustBeHistory = true;
        }
        if (mustBeHistory && mustBeLast) {
            LOG.error("illegal combination of parameters. (last=\"" + last + "\") mustBeHistory=" + mustBeHistory + " mustBeLast=" + mustBeLast + " testInstanceIdFilter=" + testInstanceIdFilter + " cancelledIncluded=" + cancelledIncluded);
            throw new WebApplicationException("illegal combination of parameters. (last=\"" + last + "\")", Response.Status.BAD_REQUEST);
        }
        if (!mustBeHistory && !mustBeLast) {
            mustBeLast = true;
        }
        assert (mustBeHistory != mustBeLast);
        if (mustBeLast) {
            if (!ResourceCommon.empty(summary)) {
                List<String> summaryUpper = summary.stream().map(String::toUpperCase).map(String::trim).collect(Collectors.toList());
                List acceptableSummaryNames = Arrays.stream(Result.ResultStatus.values()).map(Object::toString).collect(Collectors.toList());
                if (!acceptableSummaryNames.containsAll(summaryUpper)) {
                    throw new WebApplicationException("illegal value in summary: " + String.join((CharSequence)", ", summary) + " (acceptable values: " + String.join((CharSequence)", ", acceptableSummaryNames) + ")", Response.Status.BAD_REQUEST);
                }
                if (testInstanceIdFilter == null || testInstanceIdFilter.size() != 1 || noSummary) {
                    throw new WebApplicationException("illegal combination of parameters. (summary filter can only be used with: last, single testinstanceid filter and optionally expired)", Response.Status.BAD_REQUEST);
                }
                baseRes = this.resultDAO.searchLastSummaryFiltered(testInstanceIdFilter.get(0), expired, summaryUpper);
            } else {
                baseRes = this.resultDAO.searchLast(versionNameFilter, testInstanceNameFilter, testDefinitionNameFilter, testInstanceIdFilter, testbedCategoryFilter, testbedGeniNameFilter, testbedUrnFilter, testbedNameFilter, serverIdFilter, disabled, cancelledIncluded, expired);
            }
        } else {
            assert (testInstanceIdFilter != null);
            assert (testInstanceIdFilter.size() == 1) : "testInstanceIdFilter.size() == " + testInstanceIdFilter.size() + " != 1";
            int testInstanceId = testInstanceIdFilter.get(0);
            baseRes = this.resultDAO.searchHistory(testInstanceId, lastParamIntValue <= 0 ? null : Integer.valueOf(lastParamIntValue), from, till);
        }
        ArrayList<Result> res = new ArrayList<Result>(baseRes.size());
        for (Result r : baseRes) {
            if (embed != null && embed.booleanValue()) {
                r = this.embedParentLinks(r);
            }
            res.add(this.addUris(this.uriInfo, r));
        }
        return res;
    }

    @GET
    @Path(value="results/extract/{name}")
    @Produces(value={"*/*"})
    @Timed
    public Response searchExtractedData(final @NotNull @PathParam(value="name") String extractName, @QueryParam(value="last") String last, @QueryParam(value="testinstanceid") String testInstanceIds, @QueryParam(value="testversionname") String testVersionNames, @QueryParam(value="testdefinitionname") String testDefinitionNames, @QueryParam(value="testbedcategory") String testbedCategories, @QueryParam(value="testname") String testInstanceNames, @QueryParam(value="testbed") String testbedNames, @QueryParam(value="server") String serverIds, @QueryParam(value="testbed_urn") String testbedUrnNames, @QueryParam(value="geni_testbed") String testbedGeniNames, @QueryParam(value="summary") String summaries, @QueryParam(value="enabled") String enabledParam, @QueryParam(value="disabled") String disabledParam, @QueryParam(value="expired") String expiredParam, @QueryParam(value="cancelled_excluded") String cancelledExcludedParam, @QueryParam(value="cancelled_included") String cancelledIncludedParam, @QueryParam(value="from") Date from, @QueryParam(value="till") Date till, @QueryParam(value="embed") Boolean embed) {
        final List<Result> results = this.search(last, testInstanceIds, testVersionNames, testDefinitionNames, testbedCategories, testInstanceNames, testbedNames, serverIds, testbedUrnNames, testbedGeniNames, summaries, enabledParam, disabledParam, expiredParam, cancelledExcludedParam, cancelledIncludedParam, from, till, embed);
        if (results == null || results.isEmpty()) {
            return Response.noContent().build();
        }
        StreamingOutput stream = new StreamingOutput(){

            @Override
            public void write(OutputStream os) throws IOException, WebApplicationException {
                try (PrintWriter pw = new PrintWriter(os);){
                    for (Result r : results) {
                        Object nodeName;
                        Map extractMap;
                        Object c;
                        SortedMap<String, Object> subresults = r.getResults();
                        Object extract = subresults.get("extract");
                        if (extract == null || !(extract instanceof Map) || (c = (extractMap = (Map)extract).get(extractName)) == null || (nodeName = subresults.get("fixed_node_name")) == null || !(nodeName instanceof String)) continue;
                        String status = r.getSummary();
                        pw.println(nodeName + "," + status + "," + c);
                    }
                }
            }
        };
        return Response.ok((Object)stream, MediaType.TEXT_PLAIN_TYPE).build();
    }

    public Result addUris(UriInfo uriInfo, Result orig) {
        assert (uriInfo != null);
        assert (orig != null);
        assert (orig.getId() != null);
        return this.configuration.getUriTool().setUriRecursive(orig);
    }
}

