/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServiceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.codahale.metrics.annotation.Timed;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/service")
@Produces(value={"application/json"})
public class ServiceResource {
    @Context
    UriInfo uriInfo;
    private final ServiceDao serviceDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private final SharedResourceCache sharedResourceCache;

    public ServiceResource(ServiceDao serviceDao, FedmonWebApiServiceConfiguration configuration, SharedResourceCache sharedResourceCache) {
        this.serviceDao = serviceDao;
        this.configuration = configuration;
        this.sharedResourceCache = sharedResourceCache;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Timed
    public Service get(@NotNull @PathParam(value="id") Integer id, @Context HttpServletRequest request) {
        Service res = this.serviceDao.findById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        ServiceBuilder serviceBuilder = new ServiceBuilder(res);
        this.configuration.getUriTool().setUriRecursive(serviceBuilder);
        return serviceBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Service update(@NotNull @PathParam(value="id") Integer id, Service service, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (service.getId() == null || !((Integer)service.getId()).equals(id)) {
            throw new WebApplicationException("ID of provided Service differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        if (service.getUri() != null && !service.getUri().toASCIIString().endsWith("/" + id)) {
            throw new WebApplicationException("@id of provided Service differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        if (service.getApi() == null || service.getApiVersion() == null) {
            throw new WebApplicationException("Service requires api and apiVersion to be specified", Response.Status.BAD_REQUEST);
        }
        if (service.getUrl() == null) {
            throw new WebApplicationException("Service requires URL to be specified", Response.Status.BAD_REQUEST);
        }
        if (service.getUrn() == null) {
            throw new WebApplicationException("Service requires URN to be specified", Response.Status.BAD_REQUEST);
        }
        if (service.getServer() != null) {
            int rowsChanged = this.serviceDao.updateIfSameServer(service);
            if (rowsChanged == 0) {
                throw new WebApplicationException("Service with ID " + id + " and server ID " + service.getServerId() + " does not exist", Response.Status.NOT_FOUND);
            }
        } else {
            int rowsChanged = this.serviceDao.updateIgnoreServer(service);
            if (rowsChanged == 0) {
                throw new WebApplicationException("Service with ID " + id + " does not exist", Response.Status.NOT_FOUND);
            }
        }
        this.sharedResourceCache.invalidateFull();
        return this.get(id, request);
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") Integer id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Service insert(@NotNull Service service, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        Integer newId = this.serviceDao.insert(service);
        this.sharedResourceCache.invalidateFull();
        ServiceBuilder res = (ServiceBuilder)new ServiceBuilder(service).setId(newId);
        this.configuration.getUriTool().setUriRecursive(res);
        return res.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }
}

