/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceStatisticsDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.ResourceCommon;
import be.iminds.ilabt.util.jsonld.UriTool;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/testinstancestatistics")
@Produces(value={"application/json"})
@Singleton
public class TestInstanceStatisticsResource {
    private static final Logger LOG = LoggerFactory.getLogger(TestInstanceStatisticsResource.class);
    @Context
    UriInfo uriInfo;
    private final TestInstanceStatisticsDao testInstanceStatisticsDao;
    private final FedmonWebApiServiceConfiguration configuration;

    public TestInstanceStatisticsResource(TestInstanceStatisticsDao testInstanceStatisticsDao, FedmonWebApiServiceConfiguration configuration) {
        this.testInstanceStatisticsDao = testInstanceStatisticsDao;
        this.configuration = configuration;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    public List<TestInstanceStatistics> search(@QueryParam(value="testversionname") String versionNameArgString, @QueryParam(value="testname") String testInstanceNameArgString, @QueryParam(value="testdefinitionname") String testDefinitionNameArgString, @QueryParam(value="testinstanceid") String testInstanceIdArgString, @QueryParam(value="testbedcategory") String testbedCategoryArgString, @QueryParam(value="geni_testbed") String testbedGeniNameArgString, @QueryParam(value="testbed") String testbedNameArgString, @QueryParam(value="testbed_urn") String testbedUrnNamesArgString, @QueryParam(value="nextrun") String nextRunArg, @QueryParam(value="enabled") String enabledArg, @QueryParam(value="disabled") String disabledArg, @QueryParam(value="activeTasks") String hasActiveTasksArg) {
        List<String> versionNameFilter = ResourceCommon.parseArg(versionNameArgString);
        List<String> testInstanceNameFilter = ResourceCommon.parseArg(testInstanceNameArgString);
        List<String> testDefinitionNameFilter = ResourceCommon.parseArg(testDefinitionNameArgString);
        List<Integer> testInstanceIdFilter = ResourceCommon.parseIntListArg(testInstanceIdArgString);
        List<String> testbedCategoryFilter = ResourceCommon.parseArg(testbedCategoryArgString);
        List<String> testbedGeniNameFilter = ResourceCommon.parseArg(testbedGeniNameArgString);
        List<String> testbedNameFilter = ResourceCommon.parseArg(testbedNameArgString);
        List<String> testbedUrnNames = ResourceCommon.parseArg(testbedUrnNamesArgString);
        LOG.debug("testbedNameFilter=" + testbedNameFilter);
        if (disabledArg != null && enabledArg != null && ResourceCommon.parameterTruth(disabledArg) == ResourceCommon.parameterTruth(enabledArg)) {
            throw new WebApplicationException("disabled and enabled query parameter conflict", Response.Status.BAD_REQUEST);
        }
        Boolean disabled = disabledArg == null ? ResourceCommon.parameterTruthOrNull(enabledArg) : ResourceCommon.parameterTruthOrNull(disabledArg);
        Boolean nextRunHelper = ResourceCommon.parameterTruthOrNull(nextRunArg);
        List<TestInstanceStatisticsBuilder> resBase = this.testInstanceStatisticsDao.search(versionNameFilter, testInstanceNameFilter, testDefinitionNameFilter, testInstanceIdFilter, testbedCategoryFilter, testbedGeniNameFilter, testbedNameFilter, testbedUrnNames, nextRunHelper == null ? false : nextRunHelper, disabled, ResourceCommon.parameterTruthOrNull(hasActiveTasksArg), Clock.nowTimestamp());
        UriTool uriAdder = this.configuration.getUriTool();
        ArrayList<TestInstanceStatistics> res = new ArrayList<TestInstanceStatistics>(resBase.size());
        for (TestInstanceStatisticsBuilder builder : resBase) {
            uriAdder.setUriRecursive(builder, true);
            TestInstanceStatistics tis = builder.create();
            res.add(tis);
            assert (tis.getTestInstanceId() != null);
        }
        return res;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{testInstanceId}")
    @Timed
    public TestInstanceStatistics get(@NotNull @PathParam(value="testInstanceId") Integer testInstanceId) {
        assert (testInstanceId != null);
        TestInstanceStatisticsBuilder resBuilder = this.testInstanceStatisticsDao.getByTestInstanceId(testInstanceId, Clock.nowTimestamp());
        if (resBuilder == null) {
            throw new NotFoundException("There is no TestInstanceStatistics for testInstanceId=" + testInstanceId);
        }
        UriTool uriAdder = this.configuration.getUriTool();
        uriAdder.setUriRecursive(resBuilder, true);
        TestInstanceStatistics res = resBuilder.create();
        assert (res.getTestInstanceId() != null);
        assert (res.getTestInstanceId().equals(testInstanceId));
        return res;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{testInstanceId}")
    @Timed
    public TestInstanceStatistics updateNextRun(@NotNull @PathParam(value="testInstanceId") Integer testInstanceId, TestInstanceStatistics testInstanceStatistics, @Context HttpServletRequest request) {
        boolean allowedPatch = true;
        if (testInstanceStatistics.getActiveTaskUri() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getActiveTaskId() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getLastResultExcludingCancelledId() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getLastResultExcludingCancelledInfo() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getLastResultInfo() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getLastResultId() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getLastResultInfos() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getRrdStatistics() != null) {
            allowedPatch = false;
        }
        if (testInstanceStatistics.getLastRun() != null) {
            allowedPatch = false;
        }
        if (!allowedPatch) {
            throw new WebApplicationException("You can only change nextRun", Response.Status.BAD_REQUEST);
        }
        if (testInstanceStatistics.getNextRun() == null) {
            throw new WebApplicationException("nextRun is needed (and needs to be an explicit RFC3339 timestamp, not null)", Response.Status.BAD_REQUEST);
        }
        assert (testInstanceId != null);
        this.testInstanceStatisticsDao.updateNextRun(testInstanceId, testInstanceStatistics.getNextRun());
        TestInstanceStatisticsBuilder resBuilder = this.testInstanceStatisticsDao.getByTestInstanceId(testInstanceId, Clock.nowTimestamp());
        if (resBuilder == null) {
            throw new NotFoundException("There is no TestInstanceStatistics for testInstanceId=" + testInstanceId);
        }
        UriTool uriAdder = this.configuration.getUriTool();
        uriAdder.setUriRecursive(resBuilder, true);
        TestInstanceStatistics res = resBuilder.create();
        assert (res.getTestInstanceId() != null);
        assert (res.getTestInstanceId().equals(testInstanceId));
        return res;
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        throw new WebApplicationException("You can delete the TestInstance, but not the TestInstanceStatistics.", Response.Status.BAD_REQUEST);
    }
}

