/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServiceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.lowlevel.authority.binding.Authorities;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.LegacyAuthorityListModel;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.LegacySfaAuthority;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.LegacyStoredAuthorityList;
import be.iminds.ilabt.jfed.lowlevel.lib.Gid;
import be.iminds.ilabt.jfed.lowlevel.lib.ServerType;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.codahale.metrics.annotation.Timed;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/testbeds.xml")
@Produces(value={"application/xml"})
public class TestbedXmlResource {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedXmlResource.class);
    @Context
    UriInfo uriInfo;
    private final ServiceDao serviceDao;
    private final TestbedDao testbedDao;
    private final FedmonWebApiServiceConfiguration configuration;
    static Map<String, String> specialCaseIdByFlag = new HashMap<String, String>();
    static Map<String, String> flagBySpecialCaseId = new HashMap<String, String>();

    public TestbedXmlResource(TestbedDao testbedDao, ServiceDao serviceDao, FedmonWebApiServiceConfiguration configuration) {
        this.testbedDao = testbedDao;
        this.serviceDao = serviceDao;
        this.configuration = configuration;
    }

    @GET
    @Timed
    @Produces(value={"application/xml"})
    public String testbedsXml() {
        List<TestbedBuilder> testbeds = this.testbedDao.query(this.configuration.getUriTool(), null, null, null, null, null, true);
        LOG.debug("testbedsXml() Got " + testbeds.size() + " testbeds");
        HashMap<String, Testbed> testbedsByUrnStringForDebugging = new HashMap<String, Testbed>();
        LegacyAuthorityListModel authorityListModel = new LegacyAuthorityListModel();
        for (TestbedBuilder testbedBuilder : testbeds) {
            Testbed testbed = testbedBuilder.create();
            if (testbed.getServers() != null && !testbed.getServers().isEmpty()) {
                LOG.debug("testbedsXml() Got " + testbed.getServers().size() + " servers for testbed " + (String)testbed.getId());
                for (Server server : testbed.getServers()) {
                    try {
                        ArrayList<LegacySfaAuthority.ProxyInfo> proxies;
                        LegacySfaAuthority.Location location;
                        String hrn;
                        String string = hrn = testbed.getServers().size() > 1 ? server.getName() : testbed.getLongName();
                        if (server.getLocation() != null) {
                            Location serverLocation = server.getLocation();
                            location = new LegacySfaAuthority.Location(serverLocation.getCountryCode(), serverLocation.getLatitude(), serverLocation.getLongitude());
                        } else {
                            location = null;
                        }
                        if (testbed.getProxies() == null || testbed.getProxies().isEmpty()) {
                            proxies = null;
                        } else {
                            proxies = new ArrayList<LegacySfaAuthority.ProxyInfo>();
                            for (Proxy proxy : testbed.getProxies()) {
                                if (!proxy.getType().equalsIgnoreCase("SSH")) continue;
                                Authorities.Authority.Proxies.Proxy p = new Authorities.Authority.Proxies.Proxy();
                                p.setHostKey(proxy.getHostKey());
                                p.setPortRange(proxy.getPortRange());
                                p.setHostname(proxy.getHostname());
                                p.setProxyType("jFed SSH Proxy");
                                proxies.add(new LegacySfaAuthority.ProxyInfo(p));
                            }
                        }
                        Gid gid = null;
                        HashMap<ServerType, URL> urls = new HashMap<ServerType, URL>();
                        if (server.getServices() != null) {
                            LOG.debug("testbedsXml() Got " + server.getServices().size() + " services for testbed " + (String)testbed.getId() + " server " + server.getId());
                            for (Service service : server.getServices()) {
                                urls.put(TestbedXmlResource.getServiceServerType(service), new URL(service.getUrl()));
                            }
                        } else {
                            LOG.debug("testbedsXml() Got null services for testbed " + (String)testbed.getId() + " server " + server.getId());
                        }
                        if (testbed.getDefaultComponentManagerUrn() == null) {
                            LOG.warn("A Testbed has NO component manager URN. Skipping it. Testbed id=" + (String)testbed.getId());
                            continue;
                        }
                        if (authorityListModel.getByUrnExact(testbed.getDefaultComponentManagerUrn()) != null) {
                            LegacySfaAuthority existingAuth = authorityListModel.getByUrnExact(testbed.getDefaultComponentManagerUrn());
                            Testbed existingTestbed = (Testbed)testbedsByUrnStringForDebugging.get(testbed.getDefaultComponentManagerUrn());
                            LOG.warn("A Testbed has with component manager URN " + testbed.getDefaultComponentManagerUrn() + " already exists (" + existingAuth.getName() + " testbedId=" + (existingTestbed == null ? "<no testbed found>" : (String)existingTestbed.getId()) + ")! Skipping this one. Testbed id=" + (String)testbed.getId());
                            continue;
                        }
                        testbedsByUrnStringForDebugging.put(testbed.getDefaultComponentManagerUrn(), testbed);
                        LegacySfaAuthority auth = new LegacySfaAuthority(testbed.getDefaultComponentManagerUrn(), hrn, location, urls, proxies, gid, server.getServerType());
                        auth.setSource(null);
                        if (server.getAllowedCertificateAlias() != null) {
                            auth.setAllowedCertificateHostnameAlias(Arrays.asList(server.getAllowedCertificateAlias()));
                        }
                        if (server.getCertificateChain() != null) {
                            auth.addPemSslTrustCert(server.getCertificateChain());
                        }
                        auth.setReconnectEachTime(false);
                        for (LegacySfaAuthority.SpecialCase specialCase : TestbedXmlResource.getSpecialCases(server)) {
                            auth.setSpecialCase(specialCase, true);
                            if (specialCase != LegacySfaAuthority.SpecialCase.RECONNECT_EACH_TIME) continue;
                            auth.setReconnectEachTime(true);
                        }
                        try {
                            if (server.getDefaultScs() != null && server.getDefaultScs().getId() != null) {
                                if (server.getDefaultScs().getUrn() != null) {
                                    auth.setDefaultScsUrn(new GeniUrn(server.getDefaultScs().getUrn()));
                                } else if (this.serviceDao != null) {
                                    Service fullScsService = this.serviceDao.findById((Integer)server.getDefaultScs().getId());
                                    if (fullScsService != null && fullScsService.getUrn() != null) {
                                        auth.setDefaultScsUrn(new GeniUrn(fullScsService.getUrn()));
                                    } else if (fullScsService == null) {
                                        LOG.warn("did not find default SCS service " + server.getDefaultScs().getId());
                                    } else if (fullScsService.getUrn() == null) {
                                        LOG.warn("Default SCS service has no urn :" + fullScsService);
                                    }
                                } else {
                                    LOG.warn("serviceDao is null, cannot fetch default SCS " + server.getDefaultScs().getId());
                                }
                            }
                        }
                        catch (Exception e) {
                            LOG.warn("Problem processing SCS urn: " + server.getDefaultScs());
                            auth.setDefaultScsUrn(null);
                        }
                        authorityListModel.addAuthority(auth);
                    }
                    catch (Exception e) {
                        LOG.error("Error processing Testbed " + (String)testbed.getId() + " Server " + server.getId(), e);
                    }
                }
                continue;
            }
            LOG.debug("testbedsXml() Got null or empty servers for testbed " + (String)testbed.getId());
            try {
                ArrayList<LegacySfaAuthority.ProxyInfo> proxies;
                String hrn = testbed.getLongName();
                if (testbed.getProxies() == null || testbed.getProxies().isEmpty()) {
                    proxies = null;
                } else {
                    proxies = new ArrayList<LegacySfaAuthority.ProxyInfo>();
                    for (Proxy proxy : testbed.getProxies()) {
                        if (!proxy.getType().equalsIgnoreCase("SSH")) continue;
                        Authorities.Authority.Proxies.Proxy p = new Authorities.Authority.Proxies.Proxy();
                        p.setHostKey(proxy.getHostKey());
                        p.setPortRange(proxy.getPortRange());
                        p.setHostname(proxy.getHostname());
                        p.setProxyType("jFed SSH Proxy");
                        proxies.add(new LegacySfaAuthority.ProxyInfo(p));
                    }
                }
                Gid gid = null;
                Map<ServerType, URL> urls = null;
                if (testbed.getDefaultComponentManagerUrn() == null) {
                    LOG.warn("A Testbed has NO component manager URN. Skipping it. Testbed id=" + (String)testbed.getId());
                    continue;
                }
                if (authorityListModel.getByUrnExact(testbed.getDefaultComponentManagerUrn()) != null) {
                    LegacySfaAuthority existingAuth = authorityListModel.getByUrnExact(testbed.getDefaultComponentManagerUrn());
                    Testbed existingTestbed = (Testbed)testbedsByUrnStringForDebugging.get(testbed.getDefaultComponentManagerUrn());
                    LOG.warn("A Testbed has with component manager URN " + testbed.getDefaultComponentManagerUrn() + " already exists (" + existingAuth.getName() + " testbedId=" + (existingTestbed == null ? "<no testbed found>" : (String)existingTestbed.getId()) + ")! Skipping this one. Testbed id=" + (String)testbed.getId());
                    continue;
                }
                testbedsByUrnStringForDebugging.put(testbed.getDefaultComponentManagerUrn(), testbed);
                LegacySfaAuthority.Location location = null;
                LegacySfaAuthority auth = new LegacySfaAuthority(testbed.getDefaultComponentManagerUrn(), hrn, location, urls, proxies, gid, "fake");
                auth.setSource(null);
                auth.setReconnectEachTime(false);
                if (testbed.getOrganisationId() != null && testbed.getOrganisationId().equals("fake-edge-vlan")) {
                    auth.setSpecialCase(LegacySfaAuthority.SpecialCase.SUPPORTS_STITCHING, true);
                }
                authorityListModel.addAuthority(auth);
            }
            catch (Exception e) {
                LOG.error("Error processing Testbed " + (String)testbed.getId() + " without Server", e);
            }
        }
        String authoritiesXml = LegacyStoredAuthorityList.toXml(authorityListModel);
        return authoritiesXml;
    }

    public static ServerType getServiceServerType(Service service) {
        ServerType.GeniServerRole role = TestbedXmlResource.apiToServerRole(service.getApi());
        return new ServerType(role, service.getApiVersion());
    }

    public static ServerType.GeniServerRole apiToServerRole(String api) {
        assert (api != null);
        assert (!api.isEmpty());
        String normalized = api.toLowerCase().replaceAll("[^A-Za-z0-9]", "");
        assert (!normalized.isEmpty());
        if (normalized.equals("am")) {
            return ServerType.GeniServerRole.AM;
        }
        if (normalized.equals("scs")) {
            return ServerType.GeniServerRole.SCS;
        }
        if (normalized.startsWith("geni")) {
            if (normalized.equals("geniam")) {
                return ServerType.GeniServerRole.AM;
            }
            if (normalized.equals("genisa")) {
                return ServerType.GeniServerRole.GENI_CH_SA;
            }
            if (normalized.equals("genima")) {
                return ServerType.GeniServerRole.GENI_CH_MA;
            }
            if (normalized.equals("genich")) {
                return ServerType.GeniServerRole.GENI_CH;
            }
            if (normalized.equals("geniscs")) {
                return ServerType.GeniServerRole.SCS;
            }
        }
        if (normalized.startsWith("protogeni")) {
            if (normalized.equals("protogenisa")) {
                return ServerType.GeniServerRole.PROTOGENI_SA;
            }
            if (normalized.equals("protogenich")) {
                return ServerType.GeniServerRole.PROTOGENI_CH;
            }
        }
        if (normalized.startsWith("fed4fire")) {
            if (normalized.equals("fed4firefedmon")) {
                return ServerType.GeniServerRole.Fedmon;
            }
            if (normalized.equals("fed4firereputationservice")) {
                return ServerType.GeniServerRole.REPUTATION_SERVICE;
            }
            if (normalized.equals("fed4firereservationcalendarpage")) {
                return ServerType.GeniServerRole.ReservationCalendarPage;
            }
            if (normalized.equals("fed4fireslacollector")) {
                return ServerType.GeniServerRole.SLA_COLLECTOR;
            }
        }
        if (normalized.equals("reservationcalendarpage")) {
            return ServerType.GeniServerRole.ReservationCalendarPage;
        }
        if (normalized.equals("slacollector")) {
            return ServerType.GeniServerRole.SLA_COLLECTOR;
        }
        if (normalized.equals("gts")) {
            return ServerType.GeniServerRole.GTS_REST;
        }
        if (normalized.startsWith("planetlab")) {
            if (normalized.equals("planetlabsliceregistry")) {
                return ServerType.GeniServerRole.PlanetLabSliceRegistry;
            }
            if (normalized.equals("planetlabsr")) {
                return ServerType.GeniServerRole.PlanetLabSliceRegistry;
            }
        }
        throw new IllegalArgumentException("Invalid server role: \"" + api + "\"  (normalized=" + normalized + ")");
    }

    public static String serverRoleToApi(ServerType.GeniServerRole role) {
        switch (role) {
            case PlanetLabSliceRegistry: {
                return "PlanetLabSliceRegistry";
            }
            case PROTOGENI_SA: {
                return "ProtoGeni.SA";
            }
            case AM: {
                return "Geni.AM";
            }
            case PROTOGENI_CH: {
                return "ProtoGeni.CH";
            }
            case GENI_CH: {
                return "Geni.CH";
            }
            case GENI_CH_SA: {
                return "Geni.SA";
            }
            case GENI_CH_MA: {
                return "Geni.MA";
            }
            case SCS: {
                return "Geni.SCS";
            }
            case GTS_REST: {
                return "GTS";
            }
            case Fedmon: {
                return "Fed4Fire.Fedmon";
            }
            case ReservationCalendarPage: {
                return "Fed4Fire.ReservationCalendarPage";
            }
            case SLA_COLLECTOR: {
                return "Fed4Fire.SlaCollector";
            }
            case REPUTATION_SERVICE: {
                return "Fed4Fire.ReputationService";
            }
        }
        throw new RuntimeException("Unsupported ServerType.GeniServerRole " + role);
    }

    public static Set<LegacySfaAuthority.SpecialCase> getSpecialCases(Server server) {
        if (server.getFlags() == null) {
            return Collections.emptySet();
        }
        HashSet<LegacySfaAuthority.SpecialCase> res = new HashSet<LegacySfaAuthority.SpecialCase>();
        for (String flag : server.getFlags()) {
            String specialCaseId = specialCaseIdByFlag.getOrDefault(flag, flag);
            try {
                LegacySfaAuthority.SpecialCase specialCase = LegacySfaAuthority.SpecialCase.fromString(specialCaseId);
                res.add(specialCase);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Ignoring unknown flag \"" + flag + "\" (mapped to " + specialCaseId + ")");
            }
        }
        return res;
    }

    public static String specialCaseToFlag(LegacySfaAuthority.SpecialCase specialCase) {
        return flagBySpecialCaseId.get(specialCase.getId());
    }

    static {
        for (Server.Flag flag : Server.Flag.values()) {
            specialCaseIdByFlag.put(flag.getJsonText(), flag.getSpecialCaseId());
            flagBySpecialCaseId.put(flag.getSpecialCaseId(), flag.getJsonText());
        }
    }
}

