/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.git;

import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.GitFetcherCommand;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GitFetcherCommandBuilder {
    private String gitUrl;
    private String repoSubDir;
    private String branch;
    private String username;
    private String password;
    private String privateKeyPemFile;
    private GitAuthPreferences.GitAuth gitAuth;
    private File targetDir;
    private boolean allowCreateDir;
    private boolean overwriteFilesInDir;

    public GitFetcherCommandBuilder() {
    }

    public static Optional<GitFetcherCommandBuilder> fromString(@Nonnull String command) {
        String branch;
        boolean isSpecialGit = command.trim().startsWith("git ");
        boolean isSpecialGithub = command.trim().startsWith("github ");
        if (!isSpecialGit && !isSpecialGithub) {
            return Optional.empty();
        }
        String[] gitSourceSpecSplit = command.trim().split(" ");
        if (gitSourceSpecSplit.length > 4) {
            throw new IllegalArgumentException("'" + command + "' has too many parts. Syntax: git[hub] https://<githubTLD>/<org>/<repo>.git [<subdir> [<branch>]]");
        }
        if (gitSourceSpecSplit.length < 2) {
            throw new IllegalArgumentException("'" + command + "' has too few parts. Syntax: git[hub] https://<githubTLD>/<org>/<repo>.git [<subdir> [<branch>]]");
        }
        assert (gitSourceSpecSplit[0].trim().startsWith("git"));
        String gitUrl = gitSourceSpecSplit[1];
        Object subDir = gitSourceSpecSplit.length > 2 ? gitSourceSpecSplit[2] : null;
        String string = branch = gitSourceSpecSplit.length > 3 ? gitSourceSpecSplit[3] : null;
        if (subDir != null && !((String)subDir).endsWith("/")) {
            subDir = (String)subDir + "/";
        }
        return Optional.of(new GitFetcherCommandBuilder().setGitUrl(gitUrl).setRepoSubDir((String)subDir).setBranch(branch).setAllowCreateDir(false).setOverwriteFilesInDir(false));
    }

    public GitFetcherCommandBuilder(@Nullable String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public GitFetcherCommandBuilder setGitUrl(@Nullable String gitUrl) {
        this.gitUrl = gitUrl;
        return this;
    }

    public GitFetcherCommandBuilder setRepoSubDir(@Nullable String repoSubDir) {
        this.repoSubDir = repoSubDir;
        return this;
    }

    public GitFetcherCommandBuilder setBranch(@Nullable String branch) {
        this.branch = branch;
        return this;
    }

    public GitFetcherCommandBuilder setUsername(@Nullable String username) {
        if (username == null) {
            this.username = null;
            return this;
        }
        if (this.gitAuth != null || this.privateKeyPemFile != null) {
            throw new IllegalStateException("cannot set username when other auth has been set");
        }
        this.username = username;
        return this;
    }

    public GitFetcherCommandBuilder setPassword(@Nullable String password) {
        if (password == null) {
            this.password = null;
            return this;
        }
        if (this.gitAuth != null || this.privateKeyPemFile != null) {
            throw new IllegalStateException("cannot set password when other auth has been set");
        }
        this.password = password;
        return this;
    }

    public GitFetcherCommandBuilder setPrivateKeyPemFile(@Nullable String privateKeyPemFile) {
        if (privateKeyPemFile == null) {
            this.privateKeyPemFile = null;
            return this;
        }
        if (this.gitAuth != null || this.username != null || this.password != null) {
            throw new IllegalStateException("cannot set privateKeyPemFile when other auth has been set");
        }
        this.privateKeyPemFile = privateKeyPemFile;
        return this;
    }

    public GitFetcherCommandBuilder setGitAuth(@Nonnull GitAuthPreferences.GitAuth gitAuth) {
        if (gitAuth == null) {
            this.gitAuth = null;
            return this;
        }
        if (this.privateKeyPemFile != null || this.username != null || this.password != null) {
            throw new IllegalStateException("cannot set gitAuth when other auth has been set");
        }
        this.gitAuth = gitAuth;
        if (this.gitUrl == null) {
            this.gitUrl = gitAuth.getRepoUrl();
        }
        return this;
    }

    public GitFetcherCommandBuilder setTargetDir(File targetDir) {
        this.targetDir = targetDir;
        return this;
    }

    public GitFetcherCommandBuilder setAllowCreateDir(boolean allowCreateDir) {
        this.allowCreateDir = allowCreateDir;
        return this;
    }

    public GitFetcherCommandBuilder setOverwriteFilesInDir(boolean overwriteFilesInDir) {
        this.overwriteFilesInDir = overwriteFilesInDir;
        return this;
    }

    public GitFetcherCommand build() {
        if (this.gitUrl == null) {
            throw new IllegalStateException("gitUrl is a required argument of GitFetchCommand");
        }
        File usedTargetDir = this.targetDir;
        if (usedTargetDir == null) {
            usedTargetDir = GitFetcherCommand.createTempDirectory();
        }
        if (this.gitAuth == null && this.gitUrl.startsWith("http") && this.username != null) {
            this.gitAuth = new GitAuthPreferences.GitAuthUserPass(this.gitUrl, this.username, this.password);
        }
        if (this.gitAuth == null && !this.gitUrl.startsWith("http") && this.privateKeyPemFile != null) {
            this.gitAuth = new GitAuthPreferences.GitAuthSsh(this.gitUrl, this.privateKeyPemFile);
        }
        return new GitFetcherCommand(this.gitUrl, this.repoSubDir, this.branch, this.gitAuth, usedTargetDir, this.allowCreateDir, this.overwriteFilesInDir);
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public String getRepoSubDir() {
        return this.repoSubDir;
    }

    public String getBranch() {
        return this.branch;
    }
}

