/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lib;

import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.SimpleGeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCertFileUserModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(KeyCertFileUserModule.class);
    private final String keyCertContent;
    private final char[] keyPass;
    private final File certificateKeyFile;
    private final File privateKeyFile;
    private final List<AnyCredential> speaksForCredentials;

    public KeyCertFileUserModule(String keyCertContent, char[] keyPass, File certificateKeyFile, File privateKeyFile) {
        this.keyCertContent = keyCertContent;
        this.keyPass = keyPass;
        this.certificateKeyFile = certificateKeyFile;
        this.privateKeyFile = privateKeyFile;
        this.speaksForCredentials = null;
    }

    public KeyCertFileUserModule(String keyCertContent, char[] keyPass, File certificateKeyFile, File privateKeyFile, List<AnyCredential> speaksForCredentials) {
        this.keyCertContent = keyCertContent;
        this.keyPass = keyPass;
        this.certificateKeyFile = certificateKeyFile;
        this.privateKeyFile = privateKeyFile;
        this.speaksForCredentials = speaksForCredentials == null || speaksForCredentials.isEmpty() ? null : speaksForCredentials;
    }

    @Provides
    @Singleton
    public GeniUser getGeniUser(GeniUserFactory geniUserFactory) {
        try {
            if (this.speaksForCredentials == null) {
                return geniUserFactory.createGeniUser(this.keyCertContent, this.keyPass, this.certificateKeyFile, this.privateKeyFile);
            }
            return geniUserFactory.createGeniUser(this.keyCertContent, this.keyPass, this.certificateKeyFile, this.privateKeyFile, this.speaksForCredentials);
        }
        catch (InvalidLoginException e) {
            LOG.error("Could not login the user", e);
            return null;
        }
        catch (SimpleGeniUserWithSpeaksFor.InvalidSpeaksForException e) {
            LOG.error("The provided speaksfor credential was invalid", e);
            return null;
        }
    }

    @Provides
    @Singleton
    @Named(value="userUrn")
    public GeniUrn getUserUrn(GeniUser geniUser) {
        if (geniUser != null) {
            return geniUser.getUserUrn();
        }
        return null;
    }

    @Provides
    public GeniUserProvider provideGeniUserProvider(final GeniUser geniUser) {
        return new GeniUserProvider(){

            @Override
            @Nonnull
            public GeniUser getLoggedInGeniUser() {
                return geniUser;
            }

            @Override
            public boolean isUserLoggedIn() {
                return geniUser != null;
            }
        };
    }

    @Override
    protected void configure() {
    }
}

