/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.log;

import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCallIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ApiCallIdGenerator.class);
    private static final File idFile = new File(JFedUtils.getUserDataDirectoryFile(), "apiCallId");
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final AtomicBoolean scheduled = new AtomicBoolean(false);
    private static final AtomicInteger nextId = new AtomicInteger(ApiCallIdGenerator.getInitialId());

    /*
     * Enabled aggressive exception aggregation
     */
    private static int getInitialId() {
        try (FileReader fr = new FileReader(idFile);){
            String resstrfull;
            BufferedReader br;
            block17: {
                int n;
                br = new BufferedReader(fr);
                try {
                    resstrfull = br.readLine();
                    if (resstrfull != null) break block17;
                    LOG.info("readLine on idFile return null");
                    n = 0;
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                br.close();
                return n;
            }
            String resstr = resstrfull.trim();
            int res = Integer.parseInt(resstr);
            if ((res += 100) > 0x66666660) {
                res = 0;
            }
            int n = res;
            br.close();
            return n;
        }
        catch (FileNotFoundException e) {
            LOG.info("No idFile");
            return 0;
        }
        catch (IOException e) {
            LOG.error("Failed to read idFile " + idFile.getAbsolutePath(), e);
            return 0;
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse idFile " + idFile.getAbsolutePath(), e);
            return 0;
        }
    }

    private static void saveId() {
        try (FileWriter fw = new FileWriter(idFile);){
            fw.write(nextId.get() + "\n");
        }
        catch (IOException e) {
            LOG.error("Failed to write to idFile " + idFile.getAbsolutePath(), e);
        }
        finally {
            scheduled.set(false);
        }
    }

    public static int getNextId() {
        int res = nextId.getAndIncrement();
        if (scheduled.compareAndSet(false, true)) {
            scheduler.schedule(ApiCallIdGenerator::saveId, 5L, TimeUnit.SECONDS);
        }
        return res;
    }

    public static int peekId() {
        return nextId.get();
    }
}

