/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi1;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationMemberAuthorityApi1
extends AbstractFederationApi1 {
    private static final Logger LOG = LoggerFactory.getLogger(FederationMemberAuthorityApi1.class);
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_MEMBER_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PUBLIC), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_UID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.UID, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PUBLIC), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_FIRSTNAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.IDENTIFYING), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_LASTNAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.IDENTIFYING), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_USERNAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, true, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PUBLIC), new AbstractFederationApi.GetVersionResult.FieldInfo("MEMBER", "MEMBER_EMAIL", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, false, AbstractFederationApi.GetVersionResult.FieldInfo.Protect.IDENTIFYING)));
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_KEY_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_MEMBER", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_ID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_PUBLIC", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.KEY, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_PRIVATE", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.KEY, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("KEY", "KEY_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, true, true)));
    private static final List<String> API_OBJECTS = Collections.unmodifiableList(Arrays.asList("MEMBER", "KEY"));

    public static String getApiName() {
        return "Uniform Federation Member Authority API v1";
    }

    @Override
    @Nonnull
    public String getName() {
        return FederationMemberAuthorityApi1.getApiName();
    }

    public FederationMemberAuthorityApi1(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nullable RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger2, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 1), jFedPreferences);
    }

    public FederationMemberAuthorityApi1(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull JFedPreferences jFedPreferences) {
        this(logger2, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    @Override
    public String getMethodObject(Method method) {
        if (Objects.equals(method.getName(), "createKey") || Objects.equals(method.getName(), "lookupKeys") || Objects.equals(method.getName(), "deleteKey") || Objects.equals(method.getName(), "updateKey")) {
            return "KEY";
        }
        if (Objects.equals(method.getName(), "lookupPublicMemberInfo") || Objects.equals(method.getName(), "lookupPrivateMemberInfo") || Objects.equals(method.getName(), "lookupIdentifyingMemberInfo") || Objects.equals(method.getName(), "updateMemberInfo")) {
            return "MEMBER";
        }
        return null;
    }

    @Override
    @Nonnull
    public List<AbstractFederationApi.GetVersionResult.FieldInfo> getMinimumFields(String objectName) {
        if (objectName.equalsIgnoreCase("MEMBER")) {
            return MINIMUM_MEMBER_FIELDS;
        }
        if (objectName.equalsIgnoreCase("KEY")) {
            return MINIMUM_KEY_FIELDS;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getApiObjects() {
        return API_OBJECTS;
    }

    @Override
    public List<String> getRequiredApiServices() {
        return Collections.singletonList("MEMBER");
    }

    @Override
    public List<String> getOptionalApiServices() {
        return Collections.singletonList("KEY");
    }

    @ApiMethod(order=1, hint="get_version call: Provide a structure detailing the version information as well as details of accepted options s for CH API calls.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.GetVersionResult> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", new ArrayList<Object>(), resultValueObject -> new AbstractFederationApi.GetVersionResult(resultValueObject, false));
    }

    @ApiMethod(order=2, hint="lookup_public_member_info call: Lookup public information about members matching given criteria", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> lookupPublicMemberInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nullable List<AnyCredential> credentialList, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookupPublicMemberInfo", "lookup_public_member_info", credentialList, match, filter, extraOptions, null, AbstractFederationApi.MemberInfoList::new);
    }

    @ApiMethod(order=3, hint="lookup_private_member_info call: Lookup private (SSL/SSH key) information about members matching given criteria")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> lookupPrivateMemberInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookupPrivateMemberInfo", "lookup_private_member_info", credentialList, match, filter, extraOptions, null, AbstractFederationApi.MemberInfoList::new);
    }

    @ApiMethod(order=4, hint="lookup_identifying_member_info call: Lookup identifying (e.g. name, email) info about matching members")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> lookupIdentifyingMemberInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookupIdentifyingMemberInfo", "lookup_identifying_member_info", credentialList, match, filter, extraOptions, null, AbstractFederationApi.MemberInfoList::new);
    }

    @ApiMethod(order=5, hint="update_member_info call: Update information about given member public, private or identifying information")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateMemberInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="urn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull String urn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "urn", urn, "fields", fields, "extraOptions", extraOptions);
        return this.genericUpdateCall(methodParams, con, "updateMemberInfo", "update_member_info", credentialList, urn, "member", fields, extraOptions);
    }

    @ApiMethod(order=6, hint="get_credentials call: Provide list of credentials (signed statements) for given member\nThis is member-specific information suitable for passing as credentials in an AM API call for aggregate authorization.")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<AnyCredential>> getCredentials(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "extraOptions", extraOptions);
        if (!Objects.equals(memberUrn.getEncodedResourceType(), "user")) {
            LOG.warn("member URN argument to getCredentials is not a valid member urn: \"" + memberUrn + "\" (will be used anyway)");
        }
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(memberUrn.toString());
        args.add(FederationMemberAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationMemberAuthorityApi1.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "getCredentials", "get_credentials", args, resultValueObject -> FederationMemberAuthorityApi1.apiSpecifiesListOfCredentials("FederationMemberAuthorityApi1 getCredentials", resultValueObject));
    }

    @ApiMethod(order=7, hint="lookup_keys call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Map<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>>> lookupKeys(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(FederationMemberAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (match != null) {
            options.put("match", match);
        }
        if (filter != null) {
            options.put("filter", filter);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupKeys", "lookup_keys", args, this::processLookupKeys);
    }

    private Map<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>> processLookupKeys(Object resultValueObject) throws BadReplyGeniException {
        HashMap<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>> resLookupResult = new HashMap<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>>();
        Map<String, Object> res2 = FederationMemberAuthorityApi1.apiSpecifiesMapStringToObject(resultValueObject);
        for (Map.Entry<String, Object> o : res2.entrySet()) {
            GeniUrn urn;
            try {
                urn = new GeniUrn(o.getKey());
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new BadReplyGeniException("Could not parse received URN '" + o.getKey() + "'");
            }
            List<Map> o2 = FederationMemberAuthorityApi1.apiSpecifiesListOfT(Map.class, o.getValue());
            ArrayList<AbstractFederationApi.MemberKeyInfo> covertedO2 = new ArrayList<AbstractFederationApi.MemberKeyInfo>();
            for (Map keyInfo : o2) {
                covertedO2.add(new AbstractFederationApi.MemberKeyInfo(FederationMemberAuthorityApi1.apiSpecifiesMapStringToString(keyInfo)));
            }
            resLookupResult.put(urn, covertedO2);
        }
        return resLookupResult;
    }

    @ApiMethod(order=8, hint="create_key call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberKeyInfo> createKey(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN) @Nullable GeniUrn memberUrn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nullable Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "fields", fields, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(FederationMemberAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (fields != null || memberUrn != null) {
            HashMap<String, String> allFields = new HashMap<String, String>();
            if (fields != null) {
                allFields.putAll(fields);
            }
            if (memberUrn != null) {
                assert (fields != null);
                if (fields.containsKey("KEY_MEMBER")) {
                    String fieldsKeyMember = fields.get("KEY_MEMBER");
                    if (Objects.equals(fieldsKeyMember, memberUrn.getValue())) {
                        LOG.error("Note: you specified both memberUrn and added KEY_MEMBER in fields, for createKey call.They are equal, so no problem. Note that the createKey call only requires one of them.");
                    } else {
                        LOG.error("WARNING: you specified both memberUrn and added KEY_MEMBER in fields for createKey call.They are NOT equal! memberUrn='" + memberUrn + "' KEY_MEMBER field value='" + fieldsKeyMember + "' Will give preference to memberUrn! THIS IS MOST LIKELY A BUG!");
                    }
                }
                allFields.put("KEY_MEMBER", memberUrn.getValue());
            }
            options.put("fields", allFields);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "createKey", "create_key", args, AbstractFederationApi.MemberKeyInfo::new);
    }

    @ApiMethod(order=9, hint="delete_key call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Boolean> deleteKey(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="keyId", parameterType=ApiMethodParameterType.STRING) @Nonnull String keyId, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "keyId", keyId, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(memberUrn.toString());
        args.add(keyId);
        args.add(FederationMemberAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationMemberAuthorityApi1.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "deleteKey", "delete_key", args, BOOLEAN_REPLY_CONVERTER, false);
    }

    @ApiMethod(order=10, hint="update_key call: Update the details of a key pair for given member ")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateKey(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="keyId", parameterType=ApiMethodParameterType.STRING) @Nonnull String keyId, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationMemberAuthorityApi1.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "keyId", keyId, "fields", fields, "extraOptions", extraOptions);
        ArrayList<Object> memberExtraArgument = new ArrayList<Object>();
        memberExtraArgument.add(memberUrn.getValue());
        return this.genericUpdateCall(methodParams, con, "updateKey", "update_key", credentialList, keyId, null, fields, extraOptions, memberExtraArgument);
    }
}

