/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationRegistryApi1;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationRegistryApi2
extends AbstractFederationApi2 {
    private static final Logger LOG = LoggerFactory.getLogger(FederationRegistryApi2.class);
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_SERVICE_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE", "SERVICE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, true, null), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE", "SERVICE_URL", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URL, true, null), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE", "SERVICE_TYPE", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, true, null), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE", "SERVICE_CERT", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.CERTIFICATE, false, null), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE", "SERVICE_NAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, false, null), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE", "SERVICE_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, false, null), new AbstractFederationApi.GetVersionResult.FieldInfo("SERVICE", "SERVICE_PEERS", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.PEERS, false, null)));

    public static String getApiName() {
        return "Uniform Federation Registry API v2";
    }

    @Override
    @Nonnull
    public String getName() {
        return FederationRegistryApi2.getApiName();
    }

    public FederationRegistryApi2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nullable RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger2, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH, 2), jFedPreferences);
    }

    public FederationRegistryApi2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull JFedPreferences jFedPreferences) {
        this(logger2, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    @ApiMethod(order=1, hint="get_version call: Provide a structure detailing the version information as well as details of accepted options for CH API calls.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.GetVersionResult> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", new ArrayList<Object>(), resultValueObject -> new AbstractFederationApi.GetVersionResult(resultValueObject, true));
    }

    @Override
    public List<String> getApiObjects() {
        return Collections.singletonList("SERVICE");
    }

    @Override
    public List<String> getRequiredApiServices() {
        return Collections.singletonList("SERVICE");
    }

    @Override
    public List<String> getOptionalApiServices() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<AbstractFederationApi.GetVersionResult.FieldInfo> getMinimumFields(String objectName) {
        if (objectName.equalsIgnoreCase("SERVICE")) {
            return MINIMUM_SERVICE_FIELDS;
        }
        return Collections.emptyList();
    }

    @ApiMethod(order=2, hint="lookup call: Return information about a service associated with the Federation", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<ServiceDetails>> lookup(@Nonnull SfaConnection con, @ApiMethodParameter(name="type", hint="object type to lookup", guiDefault="SERVICE", parameterType=ApiMethodParameterType.CH_API2_OBJECT_TYPE) @Nonnull String type, @ApiMethodParameter(name="filter", required=false, hint="fields names included in reply. If omitted: all fields.", parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationRegistryApi2.makeMethodParameters("filter", filter, "match", match, "extraOptions", extraOptions);
        return this.genericLookup(methodParams, con, "lookup", type, null, match, filter, extraOptions, null, new LookupResultServiceDetailsConverter(this.handleMalformedReplies));
    }

    @ApiMethod(order=4, hint="convenience method which calls \"lookup\" with SERVICE_TYPE=\"AGGREGATE_MANAGER\"", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="SERVICE")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<ServiceDetails>> lookupAM(@Nonnull SfaConnection con, @ApiMethodParameter(name="filter", hint="fields names included in reply. If omitted: all fields.", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        if (match == null) {
            match = new HashMap();
        }
        if (!match.containsKey("SERVICE_TYPE")) {
            match = Collections.singletonMap("SERVICE_TYPE", "AGGREGATE_MANAGER");
        }
        return this.lookup(con, "SERVICE", filter, match, extraOptions);
    }

    @ApiMethod(order=4, hint="convenience method which calls \"lookup\" with SERVICE_TYPE=\"SLICE_AUTHORITY\"", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="SERVICE")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<ServiceDetails>> lookupSA(@Nonnull SfaConnection con, @ApiMethodParameter(name="filter", hint="fields names included in reply. If omitted: all fields.", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        if (match == null) {
            match = new HashMap();
        }
        if (!match.containsKey("SERVICE_TYPE")) {
            HashMap helper = new HashMap();
            helper.putAll(match);
            helper.put("SERVICE_TYPE", "SLICE_AUTHORITY");
            match = helper;
        }
        return this.lookup(con, "SERVICE", filter, match, extraOptions);
    }

    @ApiMethod(order=5, hint="convenience method which calls \"lookup\" with SERVICE_TYPE=\"MEMBER_AUTHORITY\"", unprotected=true, convenienceMethodFor="lookup", convenienceMethodObjectType="SERVICE")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<ServiceDetails>> lookupMA(@Nonnull SfaConnection con, @ApiMethodParameter(name="filter", hint="fields names included in reply. If omitted: all fields.", required=false, parameterType=ApiMethodParameterType.CH_API2_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="match", required=false, parameterType=ApiMethodParameterType.CH_API2_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        if (match == null) {
            match = new HashMap();
        }
        if (!match.containsKey("SERVICE_TYPE")) {
            HashMap helper = new HashMap();
            helper.putAll(match);
            helper.put("SERVICE_TYPE", "MEMBER_AUTHORITY");
            match = helper;
        }
        return this.lookup(con, "SERVICE", filter, match, extraOptions);
    }

    @ApiMethod(order=10, hint="lookup_authorities_for_urns call: Lookup the authorities for a given URNs", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<Map<GeniUrn, URL>> lookupAuthoritiesForUrns(@Nonnull SfaConnection con, @ApiMethodParameter(name="urns", hint="URNs of entities for which the authority is requested", parameterType=ApiMethodParameterType.LIST_OF_URN_STRING) @Nonnull List<GeniUrn> urns) throws JFedException {
        Map<String, Object> methodParams = FederationRegistryApi2.makeMethodParameters("urns", urns);
        ArrayList<Object> args = new ArrayList<Object>(1);
        List stringUrns = urns.stream().map(GeniUrn::toString).collect(Collectors.toList());
        args.add(stringUrns);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupAuthoritiesForUrns", "lookup_authorities_for_urns", args, FederationRegistryApi1::processAuthoritiesLookup);
    }

    @ApiMethod(order=20, hint="get_trust_roots call: Return list of trust roots (certificates) associated with this CH. Often this concatenates of the trust roots of the included authorities.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<String>> getTrustRoots(@Nonnull SfaConnection con) throws JFedException {
        ArrayList<Object> args = new ArrayList<Object>();
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getTrustRoots", "get_trust_roots", args, AbstractApi::apiSpecifiesListOfString);
    }

    private static class LookupResultServiceDetailsConverter
    implements AbstractFederationApi.LookupResultConverter<ServiceDetails> {
        private final boolean handleMalformedReplies;

        public LookupResultServiceDetailsConverter(boolean handleMalformedReplies) {
            this.handleMalformedReplies = handleMalformedReplies;
        }

        @Override
        public ServiceDetails convert(Map h2) throws BadReplyGeniException {
            return new ServiceDetails(h2, !this.handleMalformedReplies);
        }
    }

    public static class ServiceDetails {
        private String serverRoleString;
        private ApiInfo.ApiName serverRole;
        private GeniUrn urn;
        private URL url;
        private String certificate;
        private String name;
        private String description;
        private List<Peer> peers;
        private final Map<String, Object> extraFields = new HashMap<String, Object>();

        public ServiceDetails(Object resultValueObject, boolean failOnMalformedReplies) throws BadReplyGeniException {
            Map<String, Object> fields = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            for (Map.Entry<String, Object> entry : fields.entrySet()) {
                boolean known = false;
                if (Objects.equals(entry.getKey(), "SERVICE_URN")) {
                    try {
                        this.urn = new GeniUrn(AbstractApi.apiSpecifiesNonNullString(entry.getValue()));
                    }
                    catch (BadReplyGeniException e) {
                        ServiceDetails.failOrLog("service value must be String for key SERVICE_URN", e, failOnMalformedReplies);
                    }
                    catch (GeniUrn.GeniUrnParseException e) {
                        ServiceDetails.failOrLog("Could not parse the value of SERVICE_URN", e, failOnMalformedReplies);
                    }
                    known = true;
                }
                if (Objects.equals(entry.getKey(), "SERVICE_TYPE")) {
                    try {
                        this.serverRoleString = AbstractApi.apiSpecifiesNonNullString(entry.getValue());
                        this.serverRole = null;
                        if (this.serverRoleString.equalsIgnoreCase("MEMBER_AUTHORITY")) {
                            this.serverRole = ApiInfo.ApiName.GENI_CH_MA;
                        }
                        if (this.serverRoleString.equalsIgnoreCase("SLICE_AUTHORITY")) {
                            this.serverRole = ApiInfo.ApiName.GENI_CH_SA;
                        }
                        if (this.serverRoleString.equalsIgnoreCase("AGGREGATE_MANAGER")) {
                            this.serverRole = ApiInfo.ApiName.GENI_AM;
                        }
                        if (this.serverRoleString.equalsIgnoreCase("STITCHING_COMPUTATION_SERVICE")) {
                            this.serverRole = ApiInfo.ApiName.GENI_SCS;
                        }
                    }
                    catch (BadReplyGeniException e) {
                        ServiceDetails.failOrLog("service value must be String for key SERVICE_TYPE", e, failOnMalformedReplies);
                    }
                    known = true;
                }
                if (Objects.equals(entry.getKey(), "SERVICE_URL")) {
                    try {
                        this.url = new URL(AbstractApi.apiSpecifiesNonNullString(entry.getValue()));
                    }
                    catch (BadReplyGeniException e) {
                        ServiceDetails.failOrLog("service value must be String for key SERVICE_URL", e, failOnMalformedReplies);
                    }
                    catch (MalformedURLException e) {
                        ServiceDetails.failOrLog("Error parsing Federation Registry reply. Malformed URL \"" + entry.getValue() + "\". Error: " + e.getMessage(), e, failOnMalformedReplies);
                    }
                    known = true;
                }
                if (Objects.equals(entry.getKey(), "SERVICE_CERTIFICATE")) {
                    try {
                        this.certificate = AbstractApi.apiSpecifiesNonNullString(entry.getValue());
                    }
                    catch (BadReplyGeniException e) {
                        ServiceDetails.failOrLog("service value must be String for key SERVICE_CERTIFICATE", e, failOnMalformedReplies);
                    }
                    known = true;
                }
                if (Objects.equals(entry.getKey(), "SERVICE_NAME")) {
                    try {
                        this.name = AbstractApi.apiSpecifiesNonNullString(entry.getValue());
                    }
                    catch (BadReplyGeniException e) {
                        ServiceDetails.failOrLog("service value must be String for key SERVICE_NAME", e, failOnMalformedReplies);
                    }
                    known = true;
                }
                if (Objects.equals(entry.getKey(), "SERVICE_DESCRIPTION")) {
                    try {
                        this.description = AbstractApi.apiSpecifiesNonNullString(entry.getValue());
                    }
                    catch (BadReplyGeniException e) {
                        ServiceDetails.failOrLog("service value must be String for key SERVICE_DESCRIPTION", e, failOnMalformedReplies);
                    }
                    known = true;
                }
                if (Objects.equals(entry.getKey(), "SERVICE_PEERS")) {
                    known = true;
                    try {
                        List<Map> peersList = AbstractApi.apiSpecifiesListOfT(Map.class, entry.getValue());
                        this.peers = new ArrayList<Peer>();
                        for (Map ht : peersList) {
                            this.peers.add(new Peer(ht));
                        }
                    }
                    catch (BadReplyGeniException e) {
                        ServiceDetails.failOrLog("SERVICE_PEERS must contain a list of Maps", e, failOnMalformedReplies);
                    }
                }
                if (known) continue;
                this.extraFields.put(entry.getKey(), entry.getValue());
            }
        }

        private static void failOrLog(String message, Exception e, boolean failOnMalformedReplies) throws BadReplyGeniException {
            if (failOnMalformedReplies) {
                throw new BadReplyGeniException(message, e);
            }
            LOG.info(message, e);
        }

        public ApiInfo.ApiName getServerRole() {
            return this.serverRole;
        }

        public GeniUrn getUrn() {
            return this.urn;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "ServiceDetails{serverRole=" + this.serverRole + ", type=" + this.serverRoleString + ", urn=" + this.urn + ", url=" + this.url + ", certificate='" + this.certificate + "', name='" + this.name + "', description='" + this.description + "', peers='" + this.peers + "', extraFields=" + this.extraFields + "}";
        }
    }

    public static class Peer {
        private final String version;
        private final String urlString;
        private final URL url;

        public Peer(Map h2) {
            this.version = (String)h2.get("version");
            this.urlString = (String)h2.get("url");
            URL url = null;
            if (this.urlString != null) {
                try {
                    url = new URL(this.urlString);
                }
                catch (MalformedURLException e) {
                    LOG.warn("Malformed url: \"" + this.urlString + "\"", e);
                }
            }
            this.url = url;
        }

        public String getVersion() {
            return this.version;
        }

        public URL getUrl() {
            return this.url;
        }

        public String toString() {
            return "Peer{version='" + this.version + "', urlString='" + this.urlString + "', url=" + this.url + "}";
        }
    }
}

