/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi1;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationSliceAuthorityApi1
extends AbstractFederationApi1 {
    private static final Logger LOG = LoggerFactory.getLogger(FederationSliceAuthorityApi1.class);
    protected static final String TYPE_SLICE = "SLICE";
    public static final String TYPE_PROJECT = "PROJECT";
    protected static final String FIELD_SLIVER_INFO_SLICE_URN = "SLIVER_INFO_SLICE_URN";
    protected static final String FIELD_SLIVER_INFO_URN = "SLIVER_INFO_URN";
    protected static final String FIELD_SLIVER_INFO_AGGREGATE_URN = "SLIVER_INFO_AGGREGATE_URN";
    protected static final String FIELD_SLIVER_INFO_CREATOR_URN = "SLIVER_INFO_CREATOR_URN";
    private static final List<String> API_OBJECTS = Collections.unmodifiableList(Arrays.asList("SLICE", "PROJECT"));
    private static final List<String> OPTIONAL_API_SERVICES = Collections.unmodifiableList(Arrays.asList("PROJECT", "SLICE_MEMBER", "PROJECT_MEMBER", "SLIVER_INFO"));
    protected static final String FIELD_SLICE_NAME = "SLICE_NAME";
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_SLICE_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_UID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.UID, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_CREATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_EXPIRATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_EXPIRED", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.BOOLEAN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_NAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("SLICE", "SLICE_PROJECT_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, true, false)));
    private static final List<AbstractFederationApi.GetVersionResult.FieldInfo> MINIMUM_PROJECT_FIELDS = Collections.unmodifiableList(Arrays.asList(new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_URN", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_UID", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.UID, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_CREATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_EXPIRATION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.DATETIME, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_EXPIRED", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.BOOLEAN, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.NOT_ALLOWED, true, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_NAME", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED, false, false), new AbstractFederationApi.GetVersionResult.FieldInfo("PROJECT", "PROJECT_DESCRIPTION", AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING, AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.ALLOWED, false, true)));

    public static String getApiName() {
        return "Uniform Federation Slice Authority API v1";
    }

    @Override
    @Nonnull
    public String getName() {
        return FederationSliceAuthorityApi1.getApiName();
    }

    public FederationSliceAuthorityApi1(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger2, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 1), jFedPreferences);
    }

    public FederationSliceAuthorityApi1(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull JFedPreferences jFedPreferences) {
        this(logger2, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    @ApiMethod(order=1, hint="get_version call: Provide a structure detailing the version information as well as details of accepted options s for CH API calls.", unprotected=true)
    @Nonnull
    public AbstractFederationApi.FederationApiReply<GetVersionSAResult> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", new ArrayList<Object>(), GetVersionSAResult::new);
    }

    @Override
    public String getMethodObject(Method method) {
        switch (method.getName()) {
            case "createSlice": 
            case "lookupSlices": 
            case "updateSlice": {
                return TYPE_SLICE;
            }
            case "createProject": 
            case "lookupProjects": 
            case "updateProject": {
                return TYPE_PROJECT;
            }
        }
        throw new IllegalArgumentException("The given method '" + method.getName() + "' was not expected");
    }

    @Override
    public List<String> getApiObjects() {
        return API_OBJECTS;
    }

    @Override
    public List<String> getRequiredApiServices() {
        return Collections.singletonList(TYPE_SLICE);
    }

    @Override
    public List<String> getOptionalApiServices() {
        return OPTIONAL_API_SERVICES;
    }

    @Override
    @Nonnull
    public List<AbstractFederationApi.GetVersionResult.FieldInfo> getMinimumFields(String objectName) {
        if (objectName.equalsIgnoreCase(TYPE_SLICE)) {
            return MINIMUM_SLICE_FIELDS;
        }
        if (objectName.equalsIgnoreCase(TYPE_PROJECT)) {
            return MINIMUM_PROJECT_FIELDS;
        }
        throw new IllegalArgumentException(objectName + " is invalid");
    }

    @ApiMethod(order=2, hint="create_slice call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfo> createSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceName", parameterType=ApiMethodParameterType.STRING) @Nonnull String sliceName, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliceName", sliceName, "fields", fields, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        HashMap<String, Object> options = new HashMap<String, Object>();
        HashMap<String, String> allFields = new HashMap<String, String>(fields);
        assert (!allFields.containsKey(FIELD_SLICE_NAME)) : "Add SLICE_NAME with the sliceName option, not directly in the \"fields\" argument";
        allFields.put(FIELD_SLICE_NAME, sliceName);
        options.put("fields", allFields);
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "createSlice", "create_slice", args, AbstractFederationApi.SliceInfo::new);
    }

    @ApiMethod(order=3, hint="lookup_slices call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliceInfoList> lookupSlices(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookupSlices", "lookup_slices", credentialList, match, filter, extraOptions, null, AbstractFederationApi.SliceInfoList::new);
    }

    @ApiMethod(order=4, hint="update_slice call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "fields", fields, "extraOptions", extraOptions);
        return this.genericUpdateCall(methodParams, con, "updateSlice", "update_slice", credentialList, sliceUrn.toString(), "slice", fields, extraOptions);
    }

    @ApiMethod(order=5, hint="get_credentials call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<AnyCredential>> getSliceCredentials(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, String> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "extraOptions", extraOptions);
        if (!Objects.equals(sliceUrn.getEncodedResourceType(), "slice")) {
            LOG.warn("slice URN argument to getSliceCredentials is not a valid slice urn: \"" + sliceUrn + "\" (will be used anyway)");
        }
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(sliceUrn.toString());
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationSliceAuthorityApi1.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "getSliceCredentials", "get_credentials", args, resultValueObject -> FederationSliceAuthorityApi1.apiSpecifiesListOfCredentials("FederationSliceAuthorityApi1 getSliceCredentials", resultValueObject));
    }

    @ApiMethod(order=6, hint="modify_slice_membership call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> modifySliceMembership(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="membersToAdd", parameterType=ApiMethodParameterType.CH_API_LIST_MEMBER_TUPLES) @Nonnull List<UrnRoleTuple> membersToAdd, @ApiMethodParameter(name="membersToRemove", parameterType=ApiMethodParameterType.LIST_OF_URN_STRING) @Nonnull List<GeniUrn> membersToRemove, @ApiMethodParameter(name="membersToChange", parameterType=ApiMethodParameterType.CH_API_LIST_MEMBER_TUPLES) @Nonnull List<UrnRoleTuple> membersToChange, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("sliceUrn", sliceUrn, "membersToAdd", membersToAdd, "membersToRemove", membersToRemove, "membersToChange", membersToChange, "credentialList", credentialList, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(6);
        args.add(sliceUrn.getValue());
        List membersToAddList = membersToAdd.stream().map(UrnRoleTuple::toList).collect(Collectors.toList());
        args.add(membersToAddList);
        List membersToRemoveList = membersToRemove.stream().map(GeniUrn::toString).collect(Collectors.toList());
        args.add(membersToRemoveList);
        List membersToChangeList = membersToChange.stream().map(UrnRoleTuple::toList).collect(Collectors.toList());
        args.add(membersToChangeList);
        List<Map> credentials = FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList);
        args.add(credentials);
        Map<String, Object> options = FederationSliceAuthorityApi1.createOptionsMap(extraOptions);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "modifySliceMembership", "modify_slice_membership", args, STRING_REPLY_CONVERTER);
    }

    @ApiMethod(order=7, hint="lookup_slice_members call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<UrnRoleTuple>> lookupSliceMembers(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(sliceUrn.toString());
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        if (extraOptions != null) {
            args.add(extraOptions);
        } else {
            args.add(Collections.emptyMap());
        }
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupSliceMembers", "lookup_slice_members", args, resultValueObject -> FederationSliceAuthorityApi1.processUrnRoleTuplesReply(resultValueObject, "SLICE_MEMBER", "SLICE_ROLE"));
    }

    @Nonnull
    private static List<UrnRoleTuple> processUrnRoleTuplesReply(Object resultValueObject, String urnKeyName, String roleKeyName) throws BadReplyGeniException {
        List<Map> resDicts = FederationSliceAuthorityApi1.apiSpecifiesListOfT(Map.class, resultValueObject);
        ArrayList<UrnRoleTuple> resList = new ArrayList<UrnRoleTuple>();
        for (Map dict : resDicts) {
            resList.add(new UrnRoleTuple(dict, urnKeyName, roleKeyName));
        }
        return resList;
    }

    @ApiMethod(order=8, hint="lookup_slices_for_member call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<UrnRoleTuple>> lookupSlicesForMember(@Nonnull SfaConnection con, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.USER_URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(memberUrn.toString());
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        if (extraOptions != null) {
            args.add(extraOptions);
        } else {
            args.add(Collections.emptyMap());
        }
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupSlicesForMember", "lookup_slices_for_member", args, resultValueObject -> FederationSliceAuthorityApi1.processUrnRoleTuplesReply(resultValueObject, "SLICE_URN", "SLICE_ROLE"));
    }

    @ApiMethod(order=9, hint="register_aggregate call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfo> createSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="convenience argument: SLIVER_INFO_SLICE_URN to add to fields option", parameterType=ApiMethodParameterType.SLICE_URN) @Nullable String sliceUrn, @ApiMethodParameter(name="sliverUrn", hint="convenience argument: SLIVER_INFO_URN to add to fields option", parameterType=ApiMethodParameterType.URN) @Nullable String sliverUrn, @ApiMethodParameter(name="aggregateUrn", hint="convenience argument: SLIVER_INFO_AGGREGATE_URN to add to fields option", parameterType=ApiMethodParameterType.URN) @Nullable String aggregateUrn, @ApiMethodParameter(name="creatorUrn", hint="convenience argument: SLIVER_INFO_CREATOR_URN to add to fields option", parameterType=ApiMethodParameterType.URN) @Nullable String creatorUrn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "sliverUrn", sliverUrn, "aggregateUrn", aggregateUrn, "creatorUrn", creatorUrn, "fields", fields, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        assert (fields.containsKey(FIELD_SLIVER_INFO_SLICE_URN) == (sliceUrn == null)) : "Either specify sliceUrn (non-null) or add \"SLIVER_INFO_SLICE_URN\" to \"fields\". (exactly 1 is required)";
        assert (fields.containsKey(FIELD_SLIVER_INFO_URN) == (sliverUrn == null)) : "Either specify sliverUrn (non-null) or add \"SLIVER_INFO_URN\" to \"fields\". (exactly 1 is required)";
        assert (fields.containsKey(FIELD_SLIVER_INFO_AGGREGATE_URN) == (aggregateUrn == null)) : "Either specify aggregateUrn (non-null) or add \"SLIVER_INFO_AGGREGATE_URN\" to \"fields\". (exactly 1 is required)";
        assert (fields.containsKey(FIELD_SLIVER_INFO_CREATOR_URN) == (creatorUrn == null)) : "Either specify creatorUrn (non-null) or add \"SLIVER_INFO_CREATOR_URN\" to \"fields\". (exactly 1 is required)";
        if (sliceUrn != null) {
            fields.put(FIELD_SLIVER_INFO_SLICE_URN, sliceUrn);
        }
        if (sliverUrn != null) {
            fields.put(FIELD_SLIVER_INFO_URN, sliverUrn);
        }
        if (aggregateUrn != null) {
            fields.put(FIELD_SLIVER_INFO_AGGREGATE_URN, aggregateUrn);
        }
        if (creatorUrn != null) {
            fields.put(FIELD_SLIVER_INFO_CREATOR_URN, creatorUrn);
        }
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        optionsMap.put("fields", fields);
        if (extraOptions != null) {
            optionsMap.putAll(extraOptions);
        }
        args.add(optionsMap);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "createSliverInfo", "create_sliver_info", args, AbstractFederationApi.SliverInfo::new);
    }

    @ApiMethod(order=10, hint="delete_sliver_info call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> deleteSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliverUrn", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn sliverUrn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliverUrn", sliverUrn, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(sliverUrn);
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationSliceAuthorityApi1.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "deleteSliverInfo", "delete_sliver_info", args, STRING_REPLY_CONVERTER);
    }

    @ApiMethod(order=11, hint="lookup_sliver_info call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.SliverInfoList> lookupSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="convenience argument: SLIVER_INFO_SLICE_URN to add to match argument", parameterType=ApiMethodParameterType.SLICE_URN) @Nullable GeniUrn sliceUrn, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "match", match, "filter", filter, "extraOptions", extraOptions);
        assert (match != null || sliceUrn != null);
        HashMap<Object, Object> matchMap = match == null ? new HashMap() : new HashMap(match);
        if (sliceUrn != null) {
            matchMap.put(FIELD_SLIVER_INFO_SLICE_URN, sliceUrn.getValue());
        }
        return this.internalLookup(methodParams, con, "lookupSliverInfo", "lookup_sliver_info", credentialList, matchMap, filter, extraOptions, null, AbstractFederationApi.SliverInfoList::new);
    }

    @ApiMethod(order=12, hint="lookup_sliver_info call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateSliverInfo(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="URN of sliver to update", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="fields", hint="fields top update", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "fields", fields, "extraOptions", extraOptions);
        return this.genericUpdateCall(methodParams, con, "updateSliverInfo", "update_sliver_info", credentialList, sliceUrn.getValue(), "slice", fields, extraOptions, null);
    }

    @ApiMethod(order=13, hint="create_project call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfo> createProject(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="projectName", required=false, parameterType=ApiMethodParameterType.STRING) @Nullable String projectName, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "projectName", projectName, "fields", fields, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        assert (fields.containsKey("PROJECT_NAME") == (projectName == null)) : "Either specify projectName (non-null) or add \"PROJECT_NAME\" to \"fields\". (exactly 1 is required)";
        if (projectName != null) {
            fields.put("PROJECT_NAME", projectName);
        }
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        optionsMap.put("fields", fields);
        if (extraOptions != null) {
            optionsMap.putAll(extraOptions);
        }
        args.add(optionsMap);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "createProject", "create_project", args, AbstractFederationApi.ProjectInfo::new);
    }

    @ApiMethod(order=14, hint="lookup_projects call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoMap> lookupProjects(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "match", match, "filter", filter, "extraOptions", extraOptions);
        return this.internalLookup(methodParams, con, "lookupProjects", "lookup_projects", credentialList, match, filter, extraOptions, null, AbstractFederationApi.ProjectInfoMap::new);
    }

    @ApiMethod(order=15, hint="update_project call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> updateProject(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="projectUrn", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn projectUrn, @ApiMethodParameter(name="fields", parameterType=ApiMethodParameterType.CH_API1_FIELDS) @Nonnull Map<String, String> fields, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "projectUrn", projectUrn, "fields", fields, "extraOptions", extraOptions);
        return this.genericUpdateCall(methodParams, con, "updateProject", "update_project", credentialList, projectUrn.getValue(), "project", fields, extraOptions);
    }

    @ApiMethod(order=16, hint="modify_project_membership call:")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> modifyProjectMembership(@Nonnull SfaConnection con, @ApiMethodParameter(name="projectUrn", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn projectUrn, @ApiMethodParameter(name="membersToAdd", parameterType=ApiMethodParameterType.CH_API_LIST_MEMBER_TUPLES) @Nonnull List<UrnRoleTuple> membersToAdd, @ApiMethodParameter(name="membersToRemove", parameterType=ApiMethodParameterType.LIST_OF_URN_STRING) @Nonnull List<GeniUrn> membersToRemove, @ApiMethodParameter(name="membersToChange", parameterType=ApiMethodParameterType.CH_API_LIST_MEMBER_TUPLES) @Nonnull List<UrnRoleTuple> membersToChange, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("projectUrn", projectUrn, "membersToAdd", membersToAdd, "membersToRemove", membersToRemove, "membersToChange", membersToChange, "credentialList", credentialList, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(6);
        args.add(projectUrn.getValue());
        List membersToAddList = membersToAdd.stream().map(UrnRoleTuple::toList).collect(Collectors.toList());
        args.add(membersToAddList);
        List membersToRemoveList = membersToRemove.stream().map(GeniUrn::toString).collect(Collectors.toList());
        args.add(membersToRemoveList);
        List membersToChangeList = membersToChange.stream().map(UrnRoleTuple::toList).collect(Collectors.toList());
        args.add(membersToChangeList);
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationSliceAuthorityApi1.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "modifyProjectMembership", "modify_project_membership", args, STRING_REPLY_CONVERTER);
    }

    @ApiMethod(order=17, hint="lookup_project_members call: Lookup members of given project and their roles within that project")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<UrnRoleTuple>> lookupProjectMembers(@Nonnull SfaConnection con, @ApiMethodParameter(name="projectUrn", hint="project_urn for which to provide current members and roles", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn projectUrn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "projectUrn", projectUrn, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(projectUrn.getValue());
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(FederationSliceAuthorityApi1.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupProjectMembers", "lookup_project_members", args, resultValueObject -> FederationSliceAuthorityApi1.processUrnRoleTuplesReply(resultValueObject, "PROJECT_MEMBER", "PROJECT_ROLE"));
    }

    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<UrnRoleTuple>> lookupProjectsForMember(@Nonnull SfaConnection con, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        return this.lookupProjectsForMember(con, memberUrn, credentialList, null, null, extraOptions);
    }

    @ApiMethod(order=18, hint="lookup_projects_for_member call  (doesn't actually support match or filter, but you can provide them anyway):")
    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<UrnRoleTuple>> lookupProjectsForMember(@Nonnull SfaConnection con, @ApiMethodParameter(name="memberUrn", parameterType=ApiMethodParameterType.URN) @Nonnull GeniUrn memberUrn, @ApiMethodParameter(name="credentialList", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="match", parameterType=ApiMethodParameterType.CH_API1_MATCH) @Nullable Map<String, ?> match, @ApiMethodParameter(name="filter", parameterType=ApiMethodParameterType.CH_API1_FILTER) @Nullable List<String> filter, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = FederationSliceAuthorityApi1.makeMethodParameters("credentialList", credentialList, "memberUrn", memberUrn, "extraOptions", extraOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(memberUrn.toString());
        args.add(FederationSliceAuthorityApi1.createCredentialsListWithTypeAndVersion(credentialList));
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (match != null) {
            HashMap newMatch = new HashMap(match);
            if (match.containsKey("EXPIRED")) {
                Object t = match.get("EXPIRED");
                newMatch.put("EXPIRED", TextUtil.objectToBoolean(t));
            }
            options.put("match", newMatch);
        }
        if (filter != null) {
            options.put("filter", filter);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "lookupProjectsForMember", "lookup_projects_for_member", args, resultValueObject -> FederationSliceAuthorityApi1.processUrnRoleTuplesReply(resultValueObject, "PROJECT_URN", "PROJECT_ROLE"));
    }

    public static class UrnRoleTuple {
        @Nonnull
        public final GeniUrn urn;
        @Nonnull
        public final String role;
        @Nullable
        public final Map dictRaw;

        public UrnRoleTuple(@Nonnull GeniUrn urn, @Nonnull String role) {
            this.dictRaw = null;
            this.urn = urn;
            this.role = role;
        }

        public UrnRoleTuple(@Nullable Map dictRaw, @Nonnull String urnKeyName, @Nonnull String roleKeyName) throws BadReplyGeniException {
            Map<String, Object> dict = AbstractApi.apiSpecifiesMapStringToObject(dictRaw);
            String urnString = (String)dict.get(urnKeyName);
            if (urnString == null) {
                throw new BadReplyGeniException("Dictionary should contain keys '" + urnKeyName + "' and '" + roleKeyName + ". It contains only: " + dict.keySet());
            }
            try {
                this.urn = new GeniUrn(urnString);
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new BadReplyGeniException("Could not parse URN '" + urnString + "'", e);
            }
            this.role = (String)dict.get(roleKeyName);
            if (this.role == null) {
                throw new BadReplyGeniException("Dictionary should contain keys '" + urnKeyName + "' and '" + roleKeyName + ". It contains only: " + dict.keySet());
            }
            this.dictRaw = dictRaw;
        }

        public List toList() {
            return Arrays.asList(this.urn.toString(), this.role);
        }

        @Nonnull
        public GeniUrn getUrn() {
            return this.urn;
        }

        @Nonnull
        public String getRole() {
            return this.role;
        }

        public boolean isExpired() {
            if (this.dictRaw == null) {
                return false;
            }
            if (this.dictRaw.containsKey("EXPIRED") && TextUtil.objectToBoolean(this.dictRaw.get("EXPIRED")).booleanValue()) {
                return true;
            }
            if (this.dictRaw.containsKey("PROJECT_EXPIRED") && TextUtil.objectToBoolean(this.dictRaw.get("PROJECT_EXPIRED")).booleanValue()) {
                return true;
            }
            return this.dictRaw.containsKey("SLICE_EXPIRED") && TextUtil.objectToBoolean(this.dictRaw.get("SLICE_EXPIRED")) != false;
        }

        public boolean hasExpiredKey() {
            return this.dictRaw != null && (this.dictRaw.containsKey("EXPIRED") || this.dictRaw.containsKey("PROJECT_EXPIRED") || this.dictRaw.containsKey("SLICE_EXPIRED"));
        }

        public String toString() {
            return "UrnRoleTuple{urn=\"" + this.urn + "\", role=\"" + this.role + "\"}";
        }
    }

    public static class GetVersionSAResult
    extends AbstractFederationApi.GetVersionResult {
        private final List<String> services;
        private final List<String> roles;

        public GetVersionSAResult(Object resultValueObject) throws BadReplyGeniException {
            super(resultValueObject, false);
            Map<String, Object> versionInfo = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            this.services = new ArrayList<String>(AbstractApi.apiSpecifiesListOfString(versionInfo.get("SERVICES")));
            this.roles = versionInfo.get("ROLES") != null ? new ArrayList<String>(AbstractApi.apiSpecifiesListOfString(versionInfo.get("ROLES"))) : Collections.emptyList();
        }

        public List<String> getServices() {
            return this.services;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        @Override
        public String toString() {
            return "GetVersionSAResult{version='" + this.version + "', supportedCredentialTypes=" + this.supportedCredentialTypes + ", fieldInfos=" + this.fieldInfos + ", services=" + this.services + ", roles=" + this.roles + "}";
        }
    }
}

